/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import android.support.annotation.NonNull;
import com.ss.bytertc.engine.BuildConfig;
import com.ss.bytertc.engine.KTVPlayerImpl;
import com.ss.bytertc.engine.NativeKTVManagerFunctions;
import com.ss.bytertc.engine.handler.KTVEventHandler;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.ktv.IKTVEventHandler;
import com.ss.bytertc.ktv.KTVManager;
import com.ss.bytertc.ktv.KTVPlayer;
import com.ss.bytertc.ktv.data.DownloadLyricType;
import com.ss.bytertc.ktv.data.MusicFilterType;
import com.ss.bytertc.ktv.data.MusicHotType;

public class KTVManagerImpl
extends KTVManager {
    private static final String TAG = "KTVManagerImpl";
    private final long mNativeKTVManager;
    private KTVEventHandler mKTVEventHandler;
    private KTVPlayer mKTVPlayer;
    private long mNativeKTVEventHandlerPtr;

    public KTVManagerImpl(long nativeKTVManager) {
        this.mNativeKTVManager = nativeKTVManager;
    }

    @Override
    public void setKTVEventHandler(IKTVEventHandler ktvEventHandler) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, setKTVEventHandler failed.");
            return;
        }
        this.mKTVEventHandler = new KTVEventHandler(ktvEventHandler);
        long oldNativeHandler = this.mNativeKTVEventHandlerPtr;
        this.mNativeKTVEventHandlerPtr = NativeKTVManagerFunctions.nativeSetKTVEventHandler(this.mNativeKTVManager, this.mKTVEventHandler);
        if (oldNativeHandler != 0L) {
            NativeKTVManagerFunctions.nativeReleaseKTVEventHandler(oldNativeHandler);
        }
    }

    @Override
    public void setMaxCacheSize(int maxCacheSizeMB) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, setMaxCacheSize failed.");
            return;
        }
        NativeKTVManagerFunctions.nativeSetMaxCacheSize(this.mNativeKTVManager, maxCacheSizeMB);
    }

    public IKTVEventHandler getHandler() {
        return this.mKTVEventHandler.getKTVHandler();
    }

    @Override
    public void getMusicList(int pageNum, int pageSize, @NonNull MusicFilterType[] filters) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, getMusicList failed.");
            return;
        }
        int filterValue = this.calculateMusicFilterValue(filters);
        if (filterValue == -1) {
            return;
        }
        NativeKTVManagerFunctions.nativeGetMusicList(this.mNativeKTVManager, pageNum, pageSize, filterValue);
    }

    @Override
    public void searchMusic(@NonNull String keyWord, int pageNum, int pageSize, @NonNull MusicFilterType[] filters) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, searchMusic failed.");
            return;
        }
        int filterValue = this.calculateMusicFilterValue(filters);
        if (filterValue == -1) {
            return;
        }
        NativeKTVManagerFunctions.nativeSearchMusic(this.mNativeKTVManager, keyWord, pageNum, pageSize, filterValue);
    }

    @Override
    public void getHotMusic(@NonNull MusicHotType[] hotTypes, @NonNull MusicFilterType[] filters) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, getHotMusic failed.");
            return;
        }
        int filterValue = this.calculateMusicFilterValue(filters);
        int hotTypeValue = this.calculateMusicHotTypeValue(hotTypes);
        if (filterValue == -1 || hotTypeValue == -1) {
            return;
        }
        NativeKTVManagerFunctions.nativeGetHotMusic(this.mNativeKTVManager, hotTypeValue, filterValue);
    }

    @Override
    public void getMusicDetail(@NonNull String musicId) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, getMusicDetail failed.");
            return;
        }
        NativeKTVManagerFunctions.nativeGetMusicDetail(this.mNativeKTVManager, musicId);
    }

    @Override
    public int downloadMusic(@NonNull String musicId) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, downloadMusic failed.");
            return -1;
        }
        return NativeKTVManagerFunctions.nativeDownloadMusic(this.mNativeKTVManager, musicId);
    }

    @Override
    public int downloadLyric(@NonNull String musicId, @NonNull DownloadLyricType lyricType) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, downloadLyric failed.");
            return -1;
        }
        return NativeKTVManagerFunctions.nativeDownloadLyric(this.mNativeKTVManager, musicId, lyricType.value());
    }

    @Override
    public int downloadMidi(@NonNull String musicId) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, downloadMidi failed.");
            return -1;
        }
        return NativeKTVManagerFunctions.nativeDownloadMidi(this.mNativeKTVManager, musicId);
    }

    @Override
    public void cancelDownload(int downloadId) {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, downloadLyric failed.");
        }
        NativeKTVManagerFunctions.nativeCancelDownload(this.mNativeKTVManager, downloadId);
    }

    @Override
    public void clearCache() {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, clearCache failed.");
        }
        NativeKTVManagerFunctions.nativeClearCache(this.mNativeKTVManager);
    }

    @Override
    public KTVPlayer getKTVPlayer() {
        if (this.mNativeKTVManager == 0L) {
            LogUtil.e(TAG, "native KTVManagerImpl is invalid, getPlayer failed.");
        }
        if (this.mKTVPlayer != null) {
            return this.mKTVPlayer;
        }
        long nativeKTVPlayer = NativeKTVManagerFunctions.nativeGetKTVPlayer(this.mNativeKTVManager);
        if (nativeKTVPlayer == 0L) {
            LogUtil.e(TAG, "native nativeKTVPlayer is invalid, getPlayer failed.");
            return null;
        }
        this.mKTVPlayer = new KTVPlayerImpl(nativeKTVPlayer);
        return this.mKTVPlayer;
    }

    @Override
    public void destroy() {
        if (this.mKTVPlayer != null) {
            this.mKTVPlayer.destroy();
            this.mKTVPlayer = null;
        }
        if (this.mNativeKTVEventHandlerPtr != 0L) {
            NativeKTVManagerFunctions.nativeReleaseKTVEventHandler(this.mNativeKTVEventHandlerPtr);
            this.mNativeKTVEventHandlerPtr = 0L;
        }
        this.mKTVEventHandler = null;
    }

    private int calculateMusicFilterValue(MusicFilterType[] filters) {
        int filterValue;
        int size;
        int n = size = filters == null ? 0 : filters.length;
        if (size == 0) {
            filterValue = MusicFilterType.MUSIC_FILTER_TYPE_NONE.value();
        } else if (size == 1) {
            filterValue = filters[0].value();
        } else {
            filterValue = filters[0].value();
            for (MusicFilterType filter : filters) {
                if (filterValue == MusicFilterType.MUSIC_FILTER_TYPE_NONE.value()) {
                    if (BuildConfig.DEBUG) {
                        throw new IllegalArgumentException("types contains 'MUSIC_FILTER_TYPE_NONE' and other");
                    }
                    LogUtil.e(TAG, "types contains 'MUSIC_FILTER_TYPE_NONE' and other");
                    return -1;
                }
                filterValue |= filter.value();
            }
        }
        return filterValue;
    }

    private int calculateMusicHotTypeValue(MusicHotType[] types) {
        int typeValue;
        int size;
        int n = size = types == null ? 0 : types.length;
        if (size == 0) {
            typeValue = MusicHotType.MUSIC_HOT_TYPE_CONTENT_CENTER.value();
        } else if (size == 1) {
            typeValue = types[0].value();
        } else {
            typeValue = types[0].value();
            for (MusicHotType type : types) {
                typeValue |= type.value();
            }
        }
        return typeValue;
    }
}

