/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.audio.ISpatialAudio;
import com.ss.bytertc.engine.data.HumanOrientation;
import com.ss.bytertc.engine.data.Position;
import com.ss.bytertc.engine.utils.LogUtil;

public class NativeSpatialAudio
implements ISpatialAudio {
    private static final String TAG = "NativeSpatialAudio";
    private long mNaiveInstance = 0L;

    public NativeSpatialAudio(long instance) {
        this.mNaiveInstance = instance;
    }

    public void release() {
        this.mNaiveInstance = 0L;
    }

    @Override
    public void enableSpatialAudio(boolean enable) {
        if (this.mNaiveInstance == 0L) {
            LogUtil.e(TAG, "native SpatialAudio is invalid, enableSpatialAudio failed.");
            return;
        }
        NativeSpatialAudio.nativeEnableSpatialAudio(this.mNaiveInstance, enable);
    }

    @Override
    public int updatePosition(Position pos) {
        if (this.mNaiveInstance == 0L) {
            LogUtil.e(TAG, "native SpatialAudio is invalid, updatePosition failed.");
            return -1;
        }
        return NativeSpatialAudio.nativeUpdatePosition(this.mNaiveInstance, pos.x, pos.y, pos.z);
    }

    @Override
    public int updateSelfOrientation(HumanOrientation orientation) {
        if (this.mNaiveInstance == 0L) {
            LogUtil.e(TAG, "native SpatialAudio is invalid, updateSelfOrientation failed.");
            return -1;
        }
        return NativeSpatialAudio.nativeUpdateSelfOrientation(this.mNaiveInstance, orientation.forward.x, orientation.forward.y, orientation.forward.z, orientation.right.x, orientation.right.y, orientation.right.z, orientation.up.x, orientation.up.y, orientation.up.z);
    }

    @Override
    public void disableRemoteOrientation() {
        if (this.mNaiveInstance == 0L) {
            LogUtil.e(TAG, "native SpatialAudio is invalid, disableRemoteOrientation failed.");
            return;
        }
        NativeSpatialAudio.nativeDisableRemoteOrientation(this.mNaiveInstance);
    }

    public static native void nativeEnableSpatialAudio(long var0, boolean var2);

    public static native int nativeUpdatePosition(long var0, int var2, int var3, int var4);

    public static native int nativeUpdateSelfOrientation(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    public static native void nativeDisableRemoteOrientation(long var0);
}

