/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.PublisherParameters;
import com.ss.bytertc.engine.utils.LogUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class PublisherConfiguration {
    private static final String TAG = "PublisherConfiguration";
    private JSONObject mJsonObject;

    public boolean validate() {
        return this.mJsonObject != null;
    }

    public String toJsonString() {
        return this.validate() ? this.mJsonObject.toString() : null;
    }

    public PublisherConfiguration() {
    }

    private PublisherConfiguration(Builder builder) {
        try {
            this.mJsonObject = new JSONObject();
            this.mJsonObject.put("owner", ((Builder)builder).params.owner);
            this.mJsonObject.put("lifecycle", ((Builder)builder).params.lifecycle);
            this.mJsonObject.put("defaultLayout", ((Builder)builder).params.defaultLayout);
            this.mJsonObject.put("width", ((Builder)builder).params.width);
            this.mJsonObject.put("height", ((Builder)builder).params.height);
            this.mJsonObject.put("framerate", ((Builder)builder).params.framerate);
            this.mJsonObject.put("bitrate", ((Builder)builder).params.kBitrate);
            this.mJsonObject.put("mosaicStream", (Object)((Builder)builder).params.mosaicStream);
            this.mJsonObject.put("extraInfo", (Object)((Builder)builder).params.extraInfo);
            this.mJsonObject.put("audiosamplerate", ((Builder)builder).params.audiosamplerate);
            this.mJsonObject.put("audiobitrate", ((Builder)builder).params.audioKBitrate * 1000);
            this.mJsonObject.put("audiochannels", ((Builder)builder).params.audiochannels);
        }
        catch (JSONException e) {
            this.mJsonObject = null;
            LogUtil.w(TAG, "failed to create PublisherConfiguration");
        }
    }

    public static class Builder {
        private PublisherParameters params = new PublisherParameters();

        public Builder owner(boolean isRoomOwner) {
            this.params.owner = isRoomOwner;
            return this;
        }

        public Builder liftCycle(int lifecycle) {
            this.params.lifecycle = lifecycle;
            return this;
        }

        public Builder size(int width, int height) {
            this.params.width = width;
            this.params.height = height;
            return this;
        }

        public Builder frameRate(int framerate) {
            this.params.framerate = framerate;
            return this;
        }

        public Builder kBitRate(int kBitrate) {
            this.params.kBitrate = kBitrate;
            return this;
        }

        public Builder defaultLayout(int layoutStyle) {
            this.params.defaultLayout = layoutStyle;
            return this;
        }

        public Builder extraInfo(String optionalInfo) {
            this.params.extraInfo = optionalInfo;
            return this;
        }

        public Builder audioSampleRate(int rate) {
            this.params.audiosamplerate = rate;
            return this;
        }

        public Builder audioKBitrate(int bitrate) {
            this.params.audioKBitrate = bitrate / 1000;
            return this;
        }

        public Builder audioChannels(int channel) {
            this.params.audiochannels = channel;
            return this;
        }

        public Builder publishUrl(String url) {
            this.params.mosaicStream = url;
            return this;
        }

        public PublisherConfiguration build() {
            return new PublisherConfiguration(this);
        }
    }
}

