/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.data.RemoteVideoConfig;
import com.ss.bytertc.engine.type.ChannelProfile;
import org.webrtc.CalledByNative;

public class RTCRoomConfig {
    public ChannelProfile profile;
    public boolean isAutoPublish;
    public boolean isAutoSubscribeAudio;
    public boolean isAutoSubscribeVideo;
    public RemoteVideoConfig remoteVideoConfig = null;

    public RTCRoomConfig(ChannelProfile channelProfile, boolean isAutoPublish, boolean isAutoSubscribeAudio, boolean isAutoSubscribeVideo) {
        this.profile = channelProfile;
        this.isAutoPublish = isAutoPublish;
        this.isAutoSubscribeAudio = isAutoSubscribeAudio;
        this.isAutoSubscribeVideo = isAutoSubscribeVideo;
    }

    public RTCRoomConfig(ChannelProfile channelProfile, boolean isAutoPublish, boolean isAutoSubscribeAudio, boolean isAutoSubscribeVideo, RemoteVideoConfig remoteVideoConfig) {
        this.profile = channelProfile;
        this.isAutoPublish = isAutoPublish;
        this.isAutoSubscribeAudio = isAutoSubscribeAudio;
        this.isAutoSubscribeVideo = isAutoSubscribeVideo;
        this.remoteVideoConfig = remoteVideoConfig;
    }

    @CalledByNative
    public int getProfile() {
        switch (this.profile) {
            case CHANNEL_PROFILE_COMMUNICATION: {
                return 0;
            }
            case CHANNEL_PROFILE_LIVE_BROADCASTING: {
                return 1;
            }
            case CHANNEL_PROFILE_CLOUD_GAME: {
                return 3;
            }
            case CHANNEL_PROFILE_GAME: {
                return 2;
            }
            case CHANNEL_PROFILE_LOW_LATENCY: {
                return 4;
            }
            case CHANNEL_PROFILE_CHAT: {
                return 5;
            }
            case CHANNEL_PROFILE_CHAT_ROOM: {
                return 6;
            }
            case CHANNEL_PROFILE_LW_TOGETHER: {
                return 7;
            }
            case CHANNEL_PROFILE_GAME_HD: {
                return 8;
            }
            case CHANNEL_PROFILE_CO_HOST: {
                return 9;
            }
            case CHANNEL_PROFILE_INTERACTIVE_PODCAST: {
                return 10;
            }
            case CHANNEL_PROFILE_KTV: {
                return 11;
            }
            case CHANNEL_PROFILE_CHORUS: {
                return 12;
            }
            case CHANNEL_PROFIEL_VR_CHAT: {
                return 13;
            }
            case CHANNEL_PROFILE_GAME_STREAMING: {
                return 14;
            }
            case CHANNEL_PROFILE_LAN_LIVE_STREAMING: {
                return 15;
            }
            case CHANNEL_PROFIEL_MEETING: {
                return 16;
            }
            case CHANNEL_PROFILE_MEETING_ROOM: {
                return 17;
            }
            case CHANNEL_PROFILE_CLASSROOM: {
                return 18;
            }
        }
        return 0;
    }

    @CalledByNative
    public boolean isAutoPublish() {
        return this.isAutoPublish;
    }

    @CalledByNative
    public boolean isAutoSubscribeAudio() {
        return this.isAutoSubscribeAudio;
    }

    @CalledByNative
    public boolean isAutoSubscribeVideo() {
        return this.isAutoSubscribeVideo;
    }

    @CalledByNative
    public int getRemoteVideoConfigWidth() {
        if (this.remoteVideoConfig != null) {
            return this.remoteVideoConfig.getWidth();
        }
        return 0;
    }

    @CalledByNative
    public int getRemoteVideoConfigHeight() {
        if (this.remoteVideoConfig != null) {
            return this.remoteVideoConfig.getHeight();
        }
        return 0;
    }

    @CalledByNative
    public int getRemoteVideoConfigFrameRate() {
        if (this.remoteVideoConfig != null) {
            return this.remoteVideoConfig.getFrameRate();
        }
        return 0;
    }

    public String toString() {
        return "RTCRoomConfig{profile=" + (Object)((Object)this.profile) + ", isAutoPublish=" + this.isAutoPublish + ", isAutoSubscribeAudio=" + this.isAutoSubscribeAudio + ", isAutoSubscribeVideo=" + this.isAutoSubscribeVideo + '}';
    }
}

