/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.InternalForwardStreamInfo;
import com.ss.bytertc.engine.NativeRTCRoomFunctions;
import com.ss.bytertc.engine.NativeRangeAudio;
import com.ss.bytertc.engine.NativeSpatialAudio;
import com.ss.bytertc.engine.RTCRoom;
import com.ss.bytertc.engine.RTCRoomConfig;
import com.ss.bytertc.engine.SubscribeVideoConfig;
import com.ss.bytertc.engine.UserInfo;
import com.ss.bytertc.engine.audio.IRangeAudio;
import com.ss.bytertc.engine.audio.ISpatialAudio;
import com.ss.bytertc.engine.data.ForwardStreamInfo;
import com.ss.bytertc.engine.data.RemoteVideoConfig;
import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.handler.IRTCRoomEventHandler;
import com.ss.bytertc.engine.handler.RTCRoomEventHandler;
import com.ss.bytertc.engine.live.ILiveTranscodingObserver;
import com.ss.bytertc.engine.live.LiveTranscoding;
import com.ss.bytertc.engine.live.LiveTranscodingObserver;
import com.ss.bytertc.engine.publicstream.PublicStreaming;
import com.ss.bytertc.engine.type.MediaStreamType;
import com.ss.bytertc.engine.type.MessageConfig;
import com.ss.bytertc.engine.type.PauseResumeControlMediaType;
import com.ss.bytertc.engine.type.SubscribeMediaType;
import com.ss.bytertc.engine.utils.LogUtil;
import java.util.LinkedList;
import java.util.List;

public class RTCRoomImpl
extends RTCRoom {
    private static final String TAG = "RtcRoom";
    private long mNativeRtcRoom = 0L;
    private IRTCRoomEventHandler mRtcRoomHandler;
    private RTCRoomEventHandler mRtcRoomEventHandler;
    private boolean mEnableTranscode = false;
    private LiveTranscoding mLiveTranscoding = null;
    private long mNativeRtcRoomEventHandler = 0L;
    private ILiveTranscodingObserver mLiveTranscodingObserver;
    private LiveTranscodingObserver mLiveJniObserver;
    private PublicStreaming mPublicStreaming = null;
    private NativeRangeAudio mRangeAudio = null;
    private NativeSpatialAudio mSpatialAudio = null;
    private String mRoom;
    private String mUser;

    public String getmRoom() {
        return this.mRoom;
    }

    public String getmUser() {
        return this.mUser;
    }

    public IRTCRoomEventHandler getRtcRoomHandler() {
        return this.mRtcRoomHandler;
    }

    public RTCRoomImpl(String roomId, long nativeRtcRoom) {
        this.mNativeRtcRoom = nativeRtcRoom;
        this.mRoom = roomId;
        this.mLiveJniObserver = new LiveTranscodingObserver();
    }

    @Override
    public int joinRoom(String token, UserInfo userInfo, RTCRoomConfig roomConfig) {
        LogUtil.d(TAG, "joinRoom with token: " + token + ",room" + this.mRoom + " and uid: " + (userInfo == null ? "" : userInfo.getUid()));
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native room is invalid, joinRoom failed.");
            return -3;
        }
        if (userInfo == null || userInfo.getUid() == null || userInfo.getUid().isEmpty()) {
            LogUtil.e(TAG, "native uid is invalid, joinRoom failed.");
            return -1;
        }
        this.mUser = userInfo.getUid();
        return NativeRTCRoomFunctions.nativeJoinRoomWithRoomConfig(this.mNativeRtcRoom, token, userInfo, roomConfig);
    }

    @Override
    public void setRTCRoomEventHandler(IRTCRoomEventHandler rtcRoomEventHandler) {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native room is invalid, setRTCRoomEventHandler failed.");
            return;
        }
        this.mRtcRoomHandler = rtcRoomEventHandler;
        this.mRtcRoomEventHandler = new RTCRoomEventHandler(this);
        long handler = this.mNativeRtcRoomEventHandler;
        this.mNativeRtcRoomEventHandler = NativeRTCRoomFunctions.nativeSetRTCRoomEventHandler(this.mNativeRtcRoom, this.mRtcRoomEventHandler);
        if (handler != 0L) {
            NativeRTCRoomFunctions.nativeReleaseRTCRoomEventHandler(handler);
        }
    }

    @Override
    public void leaveRoom() {
        LogUtil.d(TAG, "leaveChannel");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, leaveChannel failed.");
            return;
        }
        this.mRoom = "";
        this.mUser = "";
        NativeRTCRoomFunctions.nativeLeaveRoom(this.mNativeRtcRoom);
    }

    @Override
    public void setUserVisibility(boolean enable) {
        LogUtil.d(TAG, "setUserVisibility. enable : " + enable);
        if (this.mNativeRtcRoom == -1L) {
            LogUtil.e(TAG, "native engine is invalid, setUserVisibility failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeSetUserVisibility(this.mNativeRtcRoom, enable);
    }

    @Override
    public void updateToken(String token) {
        LogUtil.d(TAG, "updateToken. token : " + token);
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, updateToken failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeUpdateToken(this.mNativeRtcRoom, token);
    }

    @Override
    public long sendUserMessage(String uid, String message, MessageConfig config) {
        LogUtil.d(TAG, "SendUserMessage. uid : " + uid + ", message" + message);
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, SendUserMessage failed.");
            return -1L;
        }
        return NativeRTCRoomFunctions.nativeSendUserMessage(this.mNativeRtcRoom, uid, message, config.value());
    }

    @Override
    public long sendUserBinaryMessage(String uid, byte[] buffer, MessageConfig config) {
        LogUtil.d(TAG, "SendUserBinaryMessage. uid : " + uid + ", message length:" + buffer.length);
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, SendUserBinaryMessage failed.");
            return -1L;
        }
        return NativeRTCRoomFunctions.nativeSendUserBinaryMessage(this.mNativeRtcRoom, uid, buffer, config.value());
    }

    @Override
    public long sendRoomMessage(String message) {
        LogUtil.d(TAG, "SendRoomMessage ");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, SendRoomMessage failed.");
            return -1L;
        }
        return NativeRTCRoomFunctions.nativeSendRoomMessage(this.mNativeRtcRoom, message);
    }

    @Override
    public long sendRoomBinaryMessage(byte[] buffer) {
        LogUtil.d(TAG, "SendRoomBinaryMessage ");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, SendRoomBinaryMessage failed.");
            return -1L;
        }
        return NativeRTCRoomFunctions.nativeSendRoomBinaryMessage(this.mNativeRtcRoom, buffer);
    }

    @Override
    public int setMultiDeviceAVSync(String audioUserId) {
        LogUtil.d(TAG, "setMultiDeviceAVSync ");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, setMultiDeviceAVSync failed.");
            return -1;
        }
        return NativeRTCRoomFunctions.nativeSetMultiDeviceAVSync(this.mNativeRtcRoom, audioUserId);
    }

    @Override
    public void setRemoteVideoConfig(String userId, RemoteVideoConfig remoteVideoConfig) {
        LogUtil.d(TAG, "setRemoteVideoConfig");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid,setRemoteVideoConfig failed.\"");
            return;
        }
        NativeRTCRoomFunctions.nativeSetRemoteVideoConfig(this.mNativeRtcRoom, userId, remoteVideoConfig.getWidth(), remoteVideoConfig.getHeight(), remoteVideoConfig.getFrameRate());
    }

    @Override
    public void publishStream(MediaStreamType type) {
        LogUtil.d(TAG, "publishStream");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, publishStream failed.\"");
            return;
        }
        NativeRTCRoomFunctions.nativePublishStream(this.mNativeRtcRoom, type.value);
    }

    @Override
    public void unpublishStream(MediaStreamType type) {
        LogUtil.d(TAG, "unpublishStream");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native unpublishStream is invalid");
            return;
        }
        NativeRTCRoomFunctions.nativeUnpublishStream(this.mNativeRtcRoom, type.value);
    }

    @Override
    public void publishScreen(MediaStreamType type) {
        LogUtil.d(TAG, "publishScreen");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, publishScreen failed.");
            return;
        }
        NativeRTCRoomFunctions.nativePublishScreenWithMediaStreamType(this.mNativeRtcRoom, type.value);
    }

    @Override
    public void unpublishScreen(MediaStreamType type) {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, unpublishScreen failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeUnpublishScreenWithMediaStreamType(this.mNativeRtcRoom, type.value);
    }

    @Override
    public void subscribeUserStream(String uid, StreamIndex streamType, SubscribeMediaType mediaType, SubscribeVideoConfig subscribeVideoConfig) {
        boolean isScreen;
        boolean bl = isScreen = streamType == StreamIndex.STREAM_INDEX_SCREEN;
        if (subscribeVideoConfig != null) {
            if (this.mNativeRtcRoom == 0L) {
                LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
                return;
            }
            int media_type = 0;
            switch (mediaType) {
                case RTC_SUBSCRIBE_MEDIA_TYPE_NONE: {
                    media_type = 0;
                    break;
                }
                case RTC_SUBSCRIBE_MEDIA_TYPE_AUDIO_ONLY: {
                    media_type = 1;
                    break;
                }
                case RTC_SUBSCRIBE_MEDIA_TYPE_VIDEO_ONLY: {
                    media_type = 2;
                    break;
                }
                case RTC_SUBSCRIBE_MEDIA_TYPE_AUDIO_AND_VIDEO: {
                    media_type = 3;
                }
            }
            NativeRTCRoomFunctions.nativeSubscribeUserStream(this.mNativeRtcRoom, uid, isScreen, media_type, subscribeVideoConfig.getVideoIndex(), subscribeVideoConfig.getPriority());
        }
    }

    @Override
    public void subscribeStream(String uid, MediaStreamType type) {
        LogUtil.d(TAG, "subscribeStream: " + uid + ", MediaStreamType:" + (Object)((Object)type));
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeSubscribeStreamWithMediaStreamType(this.mNativeRtcRoom, uid, type.value);
    }

    @Override
    public void subscribeAllStreams(MediaStreamType type) {
        LogUtil.d(TAG, "subscribeStream, MediaStreamType:" + (Object)((Object)type));
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native engine is invalid, subscribeAllStreams failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeSubscribeAllStreamsWithMediaStreamType(this.mNativeRtcRoom, type.value);
    }

    @Override
    public void unsubscribeStream(String uid, MediaStreamType type) {
        LogUtil.d(TAG, "unsubscribeStream: " + uid + ", MediaStreamType:" + (Object)((Object)type));
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeUnsubscribeStreamWithMediaStreamType(this.mNativeRtcRoom, uid, type.value);
    }

    @Override
    public void unsubscribeAllStreams(MediaStreamType type) {
        LogUtil.d(TAG, "unsubscribeAllStreams MediaStreamType:" + (Object)((Object)type));
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeUnsubscribeAllStreamsWithMediaStreamType(this.mNativeRtcRoom, type.value);
    }

    @Override
    public void subscribeScreen(String uid, MediaStreamType type) {
        LogUtil.d(TAG, "subscribeScreen: " + uid + ", MediaStreamType:" + (Object)((Object)type));
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native engine is invalid, subscribeScreen failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeSubscribeScreenWithMediaStreamType(this.mNativeRtcRoom, uid, type.value);
    }

    @Override
    public void unsubscribeScreen(String uid, MediaStreamType type) {
        LogUtil.d(TAG, "unsubscribeScreen: " + uid + ", MediaStreamType:" + (Object)((Object)type));
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeUnsubscribeScreenWithMediaStreamType(this.mNativeRtcRoom, uid, type.value);
    }

    @Override
    public void enableSubscribeLocalStream(boolean enable) {
        LogUtil.d(TAG, "enableSubscribeLocalStream: " + enable);
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, EnableSubscribeLocalStream failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeEnableSubscribeLocalStream(this.mNativeRtcRoom, enable);
    }

    @Override
    public void pauseAllSubscribedStream(PauseResumeControlMediaType mediaType) {
        LogUtil.d(TAG, "pauseAllSubscribedStream...");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, pauseAllSubscribedStream failed.");
            return;
        }
        int pause_type = 0;
        switch (mediaType) {
            case RTC_PAUSE_RESUME_CONTROL_AUDIO: {
                pause_type = 0;
                break;
            }
            case RTC_PAUSE_RESUME_CONTROL_VIDEO: {
                pause_type = 1;
                break;
            }
            case RTC_PAUSE_RESUME_CONTROL_AUDIO_AND_VIDEO: {
                pause_type = 2;
            }
        }
        NativeRTCRoomFunctions.nativePauseAllSubscribedStream(this.mNativeRtcRoom, pause_type);
    }

    @Override
    public void resumeAllSubscribedStream(PauseResumeControlMediaType mediaType) {
        LogUtil.d(TAG, "resumeAllSubscribedStream...");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, resumeAllSubscribedStream failed.");
            return;
        }
        int resume_type = 0;
        switch (mediaType) {
            case RTC_PAUSE_RESUME_CONTROL_AUDIO: {
                resume_type = 0;
                break;
            }
            case RTC_PAUSE_RESUME_CONTROL_VIDEO: {
                resume_type = 1;
                break;
            }
            case RTC_PAUSE_RESUME_CONTROL_AUDIO_AND_VIDEO: {
                resume_type = 2;
            }
        }
        NativeRTCRoomFunctions.nativeResumeAllSubscribedStream(this.mNativeRtcRoom, resume_type);
    }

    @Override
    public void setCustomUserRole(String role) {
        LogUtil.d(TAG, "SetCustomUserRole ");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, SetCustomUserRole failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeSetCustomUserRole(this.mNativeRtcRoom, role);
    }

    @Override
    public void destroy() {
        LogUtil.d(TAG, "Destroy ");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, Destroy failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeDestory(this.mNativeRtcRoom);
        this.mNativeRtcRoom = 0L;
        NativeRTCRoomFunctions.nativeReleaseRTCRoomEventHandler(this.mNativeRtcRoomEventHandler);
        this.mNativeRtcRoomEventHandler = 0L;
        if (this.mRangeAudio != null) {
            this.mRangeAudio.release();
        }
        if (this.mSpatialAudio != null) {
            this.mSpatialAudio.release();
        }
    }

    @Override
    public void startCloudRendering(String effectInfo) {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, startCloudRendering failed.");
            return;
        }
        String renderInfo = RTCEngineImpl.getCloudRenderingInfo("started", effectInfo);
        if (renderInfo == null) {
            return;
        }
        NativeRTCRoomFunctions.nativeUpdateCloudRending(this.mNativeRtcRoom, renderInfo);
    }

    @Override
    public void updateCloudRendering(String effectInfo) {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, updateCloudRendering failed.");
            return;
        }
        String renderInfo = RTCEngineImpl.getCloudRenderingInfo("changed", effectInfo);
        if (renderInfo == null) {
            return;
        }
        NativeRTCRoomFunctions.nativeUpdateCloudRending(this.mNativeRtcRoom, renderInfo);
    }

    @Override
    public void stopCloudRendering() {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, stopCloudRendering failed.");
            return;
        }
        String renderInfo = RTCEngineImpl.getCloudRenderingInfo("stopped", "");
        if (renderInfo == null) {
            return;
        }
        NativeRTCRoomFunctions.nativeUpdateCloudRending(this.mNativeRtcRoom, renderInfo);
    }

    @Override
    public int startForwardStreamToRooms(List<ForwardStreamInfo> forwardStreamInfos) {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, startForwardStreamToRooms failed.");
            return -1;
        }
        if (forwardStreamInfos == null) {
            return -1;
        }
        LinkedList<InternalForwardStreamInfo> internalForwardStreamInfos = new LinkedList<InternalForwardStreamInfo>();
        for (ForwardStreamInfo forwardStreamInfo : forwardStreamInfos) {
            internalForwardStreamInfos.add(new InternalForwardStreamInfo(forwardStreamInfo));
        }
        return NativeRTCRoomFunctions.nativeStartForwardStreamToRooms(this.mNativeRtcRoom, internalForwardStreamInfos);
    }

    @Override
    public int updateForwardStreamToRooms(List<ForwardStreamInfo> forwardStreamInfos) {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, updateForwardStreamToRooms failed.");
            return -1;
        }
        if (forwardStreamInfos == null) {
            return -1;
        }
        LinkedList<InternalForwardStreamInfo> internalForwardStreamInfos = new LinkedList<InternalForwardStreamInfo>();
        for (ForwardStreamInfo forwardStreamInfo : forwardStreamInfos) {
            internalForwardStreamInfos.add(new InternalForwardStreamInfo(forwardStreamInfo));
        }
        return NativeRTCRoomFunctions.nativeUpdateForwardStreamToRooms(this.mNativeRtcRoom, internalForwardStreamInfos);
    }

    @Override
    public void stopForwardStreamToRooms() {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, stopForwardStreamToRooms failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeStopForwardStreamToRooms(this.mNativeRtcRoom);
    }

    @Override
    public void pauseForwardStreamToAllRooms() {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, pauseForwardStreamToAllRooms failed.");
            return;
        }
        NativeRTCRoomFunctions.nativePauseForwardStreamToAllRooms(this.mNativeRtcRoom);
    }

    @Override
    public void resumeForwardStreamToAllRooms() {
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, resumeForwardStreamToAllRooms failed.");
            return;
        }
        NativeRTCRoomFunctions.nativeResumeForwardStreamToAllRooms(this.mNativeRtcRoom);
    }

    @Override
    public IRangeAudio getRangeAudio() {
        LogUtil.d(TAG, "getRangeAudio...");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, getRangeAudio failed.");
            return null;
        }
        if (this.mRangeAudio != null) {
            return this.mRangeAudio;
        }
        long nativeRangeAudio = NativeRTCRoomFunctions.nativeGetRangeAudio(this.mNativeRtcRoom);
        if (nativeRangeAudio == 0L) {
            LogUtil.e(TAG, "getRangeAudio failed");
            return null;
        }
        this.mRangeAudio = new NativeRangeAudio(nativeRangeAudio);
        return this.mRangeAudio;
    }

    @Override
    public ISpatialAudio getSpatialAudio() {
        LogUtil.d(TAG, "getSpatialAudio...");
        if (this.mNativeRtcRoom == 0L) {
            LogUtil.e(TAG, "native rtcroom is invalid, getSpatialAudio failed.");
            return null;
        }
        if (this.mSpatialAudio != null) {
            return this.mSpatialAudio;
        }
        long nativeSpatialAudio = NativeRTCRoomFunctions.nativeGetSpatialAudio(this.mNativeRtcRoom);
        if (nativeSpatialAudio == 0L) {
            LogUtil.e(TAG, "getSpatialAudio failed");
            return null;
        }
        this.mSpatialAudio = new NativeSpatialAudio(nativeSpatialAudio);
        return this.mSpatialAudio;
    }
}

