/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import android.content.Context;
import android.opengl.EGLContext;
import android.util.Log;
import com.ss.bytertc.base.utils.RtcContextUtils;
import com.ss.bytertc.engine.RTCHttpClient;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.utils.TextureHelper;
import com.ss.bytertc.engine.utils.VideoFrameConverter;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;

public class RtcSharedContext {
    private static String mPackageName;
    private static VideoFrameConverter mVideoFrameConverter;
    private static RTCHttpClient nativeHttpClient;
    private static EglBase mRootEglBase;

    public static void initialize(Context appContext) {
        RtcContextUtils.initialize(appContext);
        mPackageName = appContext.getPackageName();
    }

    public static Context getApplicationContext() {
        return RtcContextUtils.getApplicationContext();
    }

    public static synchronized void setVideoFrameConverter(VideoFrameConverter converter) {
        mVideoFrameConverter = converter;
    }

    public static synchronized void setHttpClient(RTCHttpClient client) {
        nativeHttpClient = client;
    }

    public static synchronized void setRootEglBase(EglBase rootEglBase) {
        mRootEglBase = rootEglBase;
    }

    public static boolean initEglContext(Object eglContext) {
        if (eglContext == null) {
            mRootEglBase = EglBase.create();
            return false;
        }
        mRootEglBase = eglContext instanceof javax.microedition.khronos.egl.EGLContext ? EglBase.createEgl10((javax.microedition.khronos.egl.EGLContext)eglContext, EglBase.CONFIG_PLAIN) : (eglContext instanceof EGLContext ? EglBase.createEgl14((EGLContext)eglContext, EglBase.CONFIG_PLAIN) : (eglContext instanceof EglBase ? EglBase.create(((EglBase)eglContext).getEglBaseContext(), EglBase.CONFIG_PLAIN) : EglBase.create()));
        return true;
    }

    public static void releaseEglContext() {
        if (mRootEglBase != null) {
            mRootEglBase.release();
            mRootEglBase = null;
        }
    }

    public static EglBase getEGLContext() {
        return mRootEglBase;
    }

    @CalledByNative
    public static long getNativeEGLContext() {
        long nativeContext = 0L;
        TextureHelper textureHelper = RtcSharedContext.getTextureHelper();
        if (textureHelper != null) {
            nativeContext = textureHelper.getNativeEglContext();
        } else if (mRootEglBase != null) {
            nativeContext = mRootEglBase.getEglBaseContext().getNativeEglContext();
        }
        return nativeContext;
    }

    @CalledByNative
    public static TextureHelper getTextureHelper() {
        return mVideoFrameConverter.getTextureHelper();
    }

    @CalledByNative
    public static VideoFrameConverter getVideoFrameConverter() {
        return mVideoFrameConverter;
    }

    @CalledByNative
    public static String getRtcPackageName() {
        if (mPackageName != null) {
            return mPackageName;
        }
        return "";
    }

    @CalledByNative
    public static void httpGetAsync(String url, int timeoutMillisecond, int callbackId, int clientId) {
        if (nativeHttpClient == null) {
            Log.d((String)"bytertc", (String)"native http client has not been init!");
            return;
        }
        RTCEngineImpl.RtcHttpCallbackImpl callback = new RTCEngineImpl.RtcHttpCallbackImpl();
        callback.setCallbackId(callbackId);
        callback.setClientId(clientId);
        nativeHttpClient.GetAsync(url, callback, timeoutMillisecond);
    }

    @CalledByNative
    public static void httpPostAsync(String url, String content, int timeoutMillisecond, int callbackId, int clientId) {
        if (nativeHttpClient == null) {
            Log.d((String)"bytertc", (String)"native http client has not been init!");
            return;
        }
        Log.d((String)"bytertc", (String)("http in java called, callback Id: " + callbackId));
        RTCEngineImpl.RtcHttpCallbackImpl callback = new RTCEngineImpl.RtcHttpCallbackImpl();
        callback.setCallbackId(callbackId);
        callback.setClientId(clientId);
        nativeHttpClient.PostAsync(url, content, callback, timeoutMillisecond);
    }

    static {
        mVideoFrameConverter = null;
        nativeHttpClient = null;
        mRootEglBase = null;
    }
}

