/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.ISingScoringEventHandler;
import com.ss.bytertc.engine.NativeSingScoringManagerFunctions;
import com.ss.bytertc.engine.audio.ISingScoringManager;
import com.ss.bytertc.engine.data.SingScoringConfig;
import com.ss.bytertc.engine.data.StandardPitchInfo;
import com.ss.bytertc.engine.handler.NativeSingScoringEventHandler;
import com.ss.bytertc.engine.utils.LogUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;

public class SingScoringManager
extends ISingScoringManager {
    private static final String TAG = "SingScoringManager";
    private long mNativeSingScoringManager = 0L;
    private long mNativeRTCVideoEngine = 0L;
    private WeakReference<ISingScoringEventHandler> mSingScoringEventHandler;
    NativeSingScoringEventHandler mNativeHandler;

    public SingScoringManager(long nativeRTCVideoEngine, long nativeSingScoringManager) {
        this.mNativeRTCVideoEngine = nativeRTCVideoEngine;
        this.mNativeSingScoringManager = nativeSingScoringManager;
        this.mNativeHandler = new NativeSingScoringEventHandler(this);
    }

    @Override
    public int initSingScoring(String singScoringAppkey, String singAcoringToken, ISingScoringEventHandler handler) {
        if (this.mNativeSingScoringManager == 0L) {
            LogUtil.e(TAG, "native SingScoringManager is invalid, initSingScoring failed.");
            return -1;
        }
        this.mSingScoringEventHandler = new WeakReference<ISingScoringEventHandler>(handler);
        if (handler == null) {
            return NativeSingScoringManagerFunctions.nativeInitSingScoring(this.mNativeRTCVideoEngine, this.mNativeSingScoringManager, singScoringAppkey, singAcoringToken, null);
        }
        return NativeSingScoringManagerFunctions.nativeInitSingScoring(this.mNativeRTCVideoEngine, this.mNativeSingScoringManager, singScoringAppkey, singAcoringToken, this.mNativeHandler);
    }

    @Override
    public int setSingScoringConfig(SingScoringConfig config) {
        if (this.mNativeSingScoringManager == 0L) {
            LogUtil.e(TAG, "native SingScoringManager is invalid, setSingScoringConfig failed.");
            return -1;
        }
        return NativeSingScoringManagerFunctions.nativeSetSingScoringConfig(this.mNativeSingScoringManager, config.sampleRate.value(), config.mode.value(), config.lyricsFilepath, config.midiFilepath);
    }

    @Override
    public List<StandardPitchInfo> getStandardPitchInfo(String midiFilepath) {
        if (this.mNativeSingScoringManager == 0L) {
            LogUtil.e(TAG, "native SingScoringManager is invalid, getStandardPitchInfo failed.");
            return null;
        }
        return Arrays.asList(NativeSingScoringManagerFunctions.nativeGetStandardPitchInfo(this.mNativeSingScoringManager, midiFilepath));
    }

    @Override
    public int startSingScoring(int position, int scoringInfoInterval) {
        if (this.mNativeSingScoringManager == 0L) {
            LogUtil.e(TAG, "native SingScoringManager is invalid, startSingScoring failed.");
            return -1;
        }
        return NativeSingScoringManagerFunctions.nativeStartSingScoring(this.mNativeSingScoringManager, position, scoringInfoInterval);
    }

    @Override
    public int stopSingScoring() {
        if (this.mNativeSingScoringManager == 0L) {
            LogUtil.e(TAG, "native SingScoringManager is invalid, stopSingScoring failed.");
            return -1;
        }
        return NativeSingScoringManagerFunctions.nativeStopSingScoring(this.mNativeSingScoringManager);
    }

    @Override
    public int getLastSentenceScore() {
        if (this.mNativeSingScoringManager == 0L) {
            LogUtil.e(TAG, "native SingScoringManager is invalid, getLastSentenceScore failed.");
            return -1;
        }
        return NativeSingScoringManagerFunctions.nativeGetLastSentenceScore(this.mNativeSingScoringManager);
    }

    @Override
    public int getTotalScore() {
        if (this.mNativeSingScoringManager == 0L) {
            LogUtil.e(TAG, "native SingScoringManager is invalid, getTotalScore failed.");
            return -1;
        }
        return NativeSingScoringManagerFunctions.nativeGetTotalScore(this.mNativeSingScoringManager);
    }

    @Override
    public int getAverageScore() {
        if (this.mNativeSingScoringManager == 0L) {
            LogUtil.e(TAG, "native SingScoringManager is invalid, getAverageScore failed.");
            return -1;
        }
        return NativeSingScoringManagerFunctions.nativeGetAverageScore(this.mNativeSingScoringManager);
    }

    public ISingScoringEventHandler getSingScoringEventHandler() {
        return (ISingScoringEventHandler)this.mSingScoringEventHandler.get();
    }
}

