/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import org.webrtc.CalledByNative;

public class SubscribeConfig {
    public boolean isScreen;
    public boolean subVideo;
    public boolean subAudio;
    public int videoIndex;
    public int sub_width = 0;
    public int sub_height = 0;
    public int sub_video_index = -1;
    public SVCLayer svcLayer = SVCLayer.SVCLayerDefault;
    public int framerate = 0;

    public SubscribeConfig() {
    }

    public SubscribeConfig(SubscribeConfig oldConfig) {
        if (oldConfig != null) {
            this.isScreen = oldConfig.isScreen;
            this.subVideo = oldConfig.subVideo;
            this.subAudio = oldConfig.subAudio;
            this.videoIndex = oldConfig.videoIndex;
            this.svcLayer = oldConfig.svcLayer;
            this.sub_width = oldConfig.sub_width;
            this.sub_height = oldConfig.sub_height;
            this.sub_video_index = oldConfig.sub_video_index;
        }
    }

    public SubscribeConfig(boolean isScreen, boolean subVideo, boolean subAudio, int videoIndex) {
        this.isScreen = isScreen;
        this.subVideo = subVideo;
        this.subAudio = subAudio;
        this.videoIndex = videoIndex;
        this.svcLayer = SVCLayer.SVCLayerDefault;
        this.sub_width = 0;
        this.sub_height = 0;
        this.sub_video_index = -1;
    }

    public SubscribeConfig(boolean isScreen, boolean subVideo, boolean subAudio, int videoIndex, int svcLayer) {
        this.isScreen = isScreen;
        this.subVideo = subVideo;
        this.subAudio = subAudio;
        this.videoIndex = videoIndex;
        this.svcLayer = SVCLayer.convertFromInt(svcLayer);
        this.sub_width = 0;
        this.sub_height = 0;
        this.sub_video_index = -1;
    }

    public SubscribeConfig(boolean isScreen, boolean subVideo, boolean subAudio, int videoIndex, int svcLayer, int sub_width, int sub_height, int sub_video_index) {
        this.isScreen = isScreen;
        this.subVideo = subVideo;
        this.subAudio = subAudio;
        this.videoIndex = videoIndex;
        this.svcLayer = SVCLayer.convertFromInt(svcLayer);
        this.sub_width = sub_width;
        this.sub_height = sub_height;
        this.sub_video_index = sub_video_index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribeConfig that = (SubscribeConfig)o;
        return this.isScreen == that.isScreen && this.subVideo == that.subVideo && this.subAudio == that.subAudio && this.videoIndex == that.videoIndex && this.svcLayer == that.svcLayer && this.sub_width == that.sub_width && this.sub_height == that.sub_height;
    }

    public String toString() {
        return "SubscribeConfig{isScreen=" + this.isScreen + ", subVideo=" + this.subVideo + ", subAudio=" + this.subAudio + ", videoIndex=" + this.videoIndex + ", svcLayer=" + (Object)((Object)this.svcLayer) + ", sub_width=" + this.sub_width + ", sub_height=" + this.sub_height + ", sub_video_index=" + this.sub_video_index + "}";
    }

    @CalledByNative
    private static SubscribeConfig create(boolean isScreen, boolean subVideo, boolean subAudio, int videoIndex, int svcLayer, int sub_width, int sub_height, int sub_video_index) {
        return new SubscribeConfig(isScreen, subVideo, subAudio, videoIndex, svcLayer, sub_width, sub_height, sub_video_index);
    }

    public static enum SVCLayer {
        SVCLayerDefault(0),
        SVCLayerBase(1),
        SVCLayerMain(2),
        SVCLayerHigh(3);

        private int value;

        private SVCLayer(int v) {
            this.value = v;
        }

        public static SVCLayer convertFromInt(int v) {
            return SVCLayer.values()[v];
        }

        public int getValue() {
            return this.value;
        }
    }
}

