/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.data;

import android.util.Pair;
import com.ss.bytertc.engine.VideoStreamDescription;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.engine.video.VideoEncoderConfiguration;
import java.util.Arrays;

public class RTCData {
    private static final String TAG = "RTCData";
    private VideoStreamDescription[] videoStreamDescriptions = new VideoStreamDescription[1];
    private VideoEncoderConfiguration.OrientationMode mOrientationMode;

    public static RTCData instance() {
        return SingletonHelper.INSTANCE;
    }

    public RTCData() {
        VideoStreamDescription description = new VideoStreamDescription();
        description.videoSize = new Pair((Object)640, (Object)360);
        description.frameRate = 20;
        description.maxKbps = 600;
        this.videoStreamDescriptions[0] = description;
        this.mOrientationMode = VideoEncoderConfiguration.OrientationMode.ORIENTATION_MODE_ADAPTIVE;
    }

    public void setVideoStreamDescriptions(VideoStreamDescription[] videoStreamDescriptions) {
        LogUtil.i(TAG, "setVideoStreamDescriptions: " + Arrays.toString(videoStreamDescriptions));
        this.videoStreamDescriptions = videoStreamDescriptions;
    }

    public void setOrientationMode(VideoEncoderConfiguration.OrientationMode orientationMode) {
        this.mOrientationMode = orientationMode;
    }

    public VideoEncoderConfiguration.OrientationMode getOrientationMode() {
        return this.mOrientationMode;
    }

    public VideoStreamDescription[] getVideoStreamDescriptions() {
        return this.videoStreamDescriptions;
    }

    private static class SingletonHelper {
        private static final RTCData INSTANCE = new RTCData();

        private SingletonHelper() {
        }
    }
}

