/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.engineimpl;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.opengl.EGLContext;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ss.bytertc.base.utils.NetworkConnectChangeReceiver;
import com.ss.bytertc.base.utils.NetworkUtils;
import com.ss.bytertc.base.utils.RtcContextUtils;
import com.ss.bytertc.engine.AudioMixingManager;
import com.ss.bytertc.engine.IAudioFrameObserver;
import com.ss.bytertc.engine.IAudioFrameProcessor;
import com.ss.bytertc.engine.IAudioProcessor;
import com.ss.bytertc.engine.IMetadataObserver;
import com.ss.bytertc.engine.IRTCAudioDeviceManagerEx;
import com.ss.bytertc.engine.InternalCloudProxyInfo;
import com.ss.bytertc.engine.InternalExpressDetectConfig;
import com.ss.bytertc.engine.InternalForwardStreamInfo;
import com.ss.bytertc.engine.InternalScreenSharingParams;
import com.ss.bytertc.engine.InternalVideoCaptureConfig;
import com.ss.bytertc.engine.InternalVideoEncoderConfig;
import com.ss.bytertc.engine.InternalVideoStreamDescription;
import com.ss.bytertc.engine.NativeFunctions;
import com.ss.bytertc.engine.RTCAudioDeviceManagerEx;
import com.ss.bytertc.engine.RTCEngine;
import com.ss.bytertc.engine.RTCEngineEx;
import com.ss.bytertc.engine.RTCHttpClient;
import com.ss.bytertc.engine.RTCRoomConfig;
import com.ss.bytertc.engine.SubscribeConfig;
import com.ss.bytertc.engine.SubscribeVideoConfig;
import com.ss.bytertc.engine.UserInfo;
import com.ss.bytertc.engine.VideoCanvas;
import com.ss.bytertc.engine.VideoEncoderConfig;
import com.ss.bytertc.engine.VideoStreamDescription;
import com.ss.bytertc.engine.adapter.VideoSinkAdapter;
import com.ss.bytertc.engine.adapter.VideoSinkTask;
import com.ss.bytertc.engine.audio.IAudioMixingManager;
import com.ss.bytertc.engine.data.AudioFormat;
import com.ss.bytertc.engine.data.AudioFrameCallbackMethod;
import com.ss.bytertc.engine.data.AudioPlaybackDevice;
import com.ss.bytertc.engine.data.AudioProcessorMethod;
import com.ss.bytertc.engine.data.AudioPropertiesConfig;
import com.ss.bytertc.engine.data.AudioRenderType;
import com.ss.bytertc.engine.data.AudioRoute;
import com.ss.bytertc.engine.data.AudioSourceType;
import com.ss.bytertc.engine.data.CameraId;
import com.ss.bytertc.engine.data.CloudProxyInfo;
import com.ss.bytertc.engine.data.EarMonitorMode;
import com.ss.bytertc.engine.data.EchoTestConfig;
import com.ss.bytertc.engine.data.EffectBeautyMode;
import com.ss.bytertc.engine.data.ForwardStreamInfo;
import com.ss.bytertc.engine.data.MediaInputType;
import com.ss.bytertc.engine.data.MirrorMode;
import com.ss.bytertc.engine.data.MirrorType;
import com.ss.bytertc.engine.data.MuteState;
import com.ss.bytertc.engine.data.RTCASRConfig;
import com.ss.bytertc.engine.data.RTCData;
import com.ss.bytertc.engine.data.RecordingConfig;
import com.ss.bytertc.engine.data.RemoteStreamKey;
import com.ss.bytertc.engine.data.RemoteVideoConfig;
import com.ss.bytertc.engine.data.ScreenMediaType;
import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.data.StreamSycnInfoConfig;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoOrientation;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.data.VideoRotationMode;
import com.ss.bytertc.engine.data.VideoSourceType;
import com.ss.bytertc.engine.data.VirtualBackgroundSource;
import com.ss.bytertc.engine.handler.IExternalVideoEncoderEventHandler;
import com.ss.bytertc.engine.handler.IRTCASREngineEventHandler;
import com.ss.bytertc.engine.handler.IRTCEngineEventHandler;
import com.ss.bytertc.engine.handler.IRTCEngineInternalEventHandler;
import com.ss.bytertc.engine.handler.NativeAudioFrameProcessor;
import com.ss.bytertc.engine.handler.NativeAudioProcessor;
import com.ss.bytertc.engine.handler.RTCASREngineEventHandler;
import com.ss.bytertc.engine.handler.RTCAudioDeviceEventHandler;
import com.ss.bytertc.engine.handler.RTCAudioFrameObserver;
import com.ss.bytertc.engine.handler.RTCEncryptHandler;
import com.ss.bytertc.engine.handler.RTCEngineEventHandler;
import com.ss.bytertc.engine.handler.RTCEngineInternalEventHandler;
import com.ss.bytertc.engine.handler.RTCExternalVideoEncoderEventHandler;
import com.ss.bytertc.engine.handler.RTCFaceDetectionObserver;
import com.ss.bytertc.engine.handler.RTCLocalEncodedVideoFrameObserver;
import com.ss.bytertc.engine.handler.RTCMetadataObserver;
import com.ss.bytertc.engine.handler.RTCRemoteEncodedVideoFrameObserver;
import com.ss.bytertc.engine.handler.RTCVideoFrameObserver;
import com.ss.bytertc.engine.handler.RTCVideoProcessor;
import com.ss.bytertc.engine.live.ILiveTranscodingObserver;
import com.ss.bytertc.engine.live.LiveTranscoding;
import com.ss.bytertc.engine.live.LiveTranscodingObserver;
import com.ss.bytertc.engine.loader.RTCNativeLibraryListenerImpl;
import com.ss.bytertc.engine.loader.RTCNativeLibraryLoaderInfo;
import com.ss.bytertc.engine.loader.RTCNativeLibraryLoaderListener;
import com.ss.bytertc.engine.mediaio.ILocalEncodedVideoFrameObserver;
import com.ss.bytertc.engine.mediaio.IRemoteEncodedVideoFrameObserver;
import com.ss.bytertc.engine.mediaio.RTCEncodedVideoFrame;
import com.ss.bytertc.engine.publicstream.PublicStreaming;
import com.ss.bytertc.engine.type.AudioProfileType;
import com.ss.bytertc.engine.type.AudioScenarioType;
import com.ss.bytertc.engine.type.BackgroundMode;
import com.ss.bytertc.engine.type.ChannelProfile;
import com.ss.bytertc.engine.type.ClientRole;
import com.ss.bytertc.engine.type.DivideModel;
import com.ss.bytertc.engine.type.MediaStreamType;
import com.ss.bytertc.engine.type.MessageConfig;
import com.ss.bytertc.engine.type.NetworkDetectionStartReturn;
import com.ss.bytertc.engine.type.PauseResumeControlMediaType;
import com.ss.bytertc.engine.type.ProblemFeedback;
import com.ss.bytertc.engine.type.PublishFallbackOption;
import com.ss.bytertc.engine.type.RangeAudioMode;
import com.ss.bytertc.engine.type.RecordingType;
import com.ss.bytertc.engine.type.RemoteUserPriority;
import com.ss.bytertc.engine.type.RtcMode;
import com.ss.bytertc.engine.type.SubscribeFallbackOptions;
import com.ss.bytertc.engine.type.SubscribeMediaType;
import com.ss.bytertc.engine.type.SubscribeMode;
import com.ss.bytertc.engine.type.TorchState;
import com.ss.bytertc.engine.type.VoiceChangerType;
import com.ss.bytertc.engine.type.VoiceReverbType;
import com.ss.bytertc.engine.utils.AppMonitor;
import com.ss.bytertc.engine.utils.AudioFrame;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.engine.utils.VideoFrameConverter;
import com.ss.bytertc.engine.video.IFaceDetectionObserver;
import com.ss.bytertc.engine.video.IVideoProcessor;
import com.ss.bytertc.engine.video.IVideoSink;
import com.ss.bytertc.engine.video.RTCWatermarkConfig;
import com.ss.bytertc.engine.video.ScreenSharingParameters;
import com.ss.bytertc.engine.video.VideoCaptureConfig;
import com.ss.bytertc.engine.video.VideoDecoderConfig;
import com.ss.bytertc.engine.video.VideoEffectExpressionConfig;
import com.ss.bytertc.engine.video.VideoEncoderConfiguration;
import com.ss.bytertc.engine.video.VideoFrame;
import com.ss.bytertc.engine.video.VideoPreprocessorConfig;
import com.ss.bytertc.engine.video.builder.GLTextureVideoFrameBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;
import org.webrtc.ThreadUtils;

@SuppressLint(value={"DefaultLocale"})
public class RTCEngineImpl
extends RTCEngineEx {
    private static RTCEngineImpl sRtcEngineInstance;
    private static boolean mLibraryLoaded;
    private static RTCNativeLibraryLoaderListener mRtcNativeLibraryListener;
    private static RTCNativeLibraryLoaderInfo sRtcLoaderInfo;
    private WeakReference<IRTCEngineEventHandler> mRtcEngineHandler;
    private WeakReference<IExternalVideoEncoderEventHandler> mExternalVideoEncoderHandler;
    private WeakReference<IAudioFrameObserver> mAudioFrameObserver;
    private WeakReference<IAudioProcessor> mAudioProcessor;
    private WeakReference<IAudioFrameProcessor> mAudioFrameProcessor;
    private WeakReference<IVideoProcessor> mCustomVideoPreprocessor;
    private WeakReference<ILocalEncodedVideoFrameObserver> mLocalEncodedVideoFrameObserver;
    private WeakReference<IRemoteEncodedVideoFrameObserver> mRemoteEncodedVideoFrameObserver;
    private WeakReference<IMetadataObserver> mMetadataObserver;
    private ILiveTranscodingObserver mLiveTranscodingObserver;
    private RTCEngineEventHandler mEngineEventHandler;
    private RTCEngineInternalEventHandler mEngineInternalEventHandler;
    private Context mContext;
    private VideoFrameConverter mVideoFrameConverter;
    private VideoFrameConverter mScreenFrameConverter;
    private String mAppId;
    private WeakReference<IFaceDetectionObserver> mFaceDetectionObserver;
    private State mState;
    private String mRoom;
    private String mUser;
    private String mSessionId;
    private String mToken;
    private boolean mIsUseCustomEglEnv = false;
    private boolean isMultiRoom = false;
    private int mChannelProfile = 0;
    private boolean mUseExtVideoSource = false;
    private boolean mPushMode = true;
    private boolean mUseExtTexture = false;
    private boolean mRequestSoftwareEncoder = false;
    private boolean mVideoEnabled = true;
    private boolean mAudioEnabled = true;
    private int mClientRole = 2;
    private long mNativeEngine = 0L;
    private LiveTranscoding mLiveTranscoding = null;
    private boolean mEnableTranscode = false;
    private static final String TAG = "RtcEngineImpl";
    private static final String sAppID = "1303";
    private static final String sSoLibraryName = "volcenginertc";
    private Runnable mOnDestroyCompletedCallback = null;
    private RTCVideoFrameObserver mRtcVideoFrameObserver = null;
    private RTCVideoProcessor mRtcVideoPreprocessor = null;
    private RTCAudioFrameObserver mRtcAudioFrameObserver = null;
    private NativeAudioProcessor mNativeAudioProcessor = null;
    private NativeAudioFrameProcessor mNativeAudioFrameProcessor = null;
    private RTCExternalVideoEncoderEventHandler mRtcExVideoEncoderHandler = null;
    private RTCLocalEncodedVideoFrameObserver mRtcLocalEncodedVideoFrameObserver = null;
    private RTCRemoteEncodedVideoFrameObserver mRtcRemoteEncodedVideoFrameObserver = null;
    private VideoSinkTask mVideoSinkTask;
    private boolean mIsVideoMirror = true;
    private EglBase mRootEglBase = null;
    private HandlerThread mEglThread;
    private Handler mEglHandler;
    private static RTCHttpClient nativeHttpClient;
    private RTCMetadataObserver mRtcMetadataObserver = null;
    private LiveTranscodingObserver mTranscodingObserver = null;
    private boolean mIsFront = true;
    private static WeakReference<IRTCAudioDeviceManagerEx.IRTCAudioDeviceEventHandler> mAudioDeviceManagerEventHandler;
    private static RTCAudioDeviceEventHandler mRTCAudioDeviceManagerEventHandler;
    private static RTCAudioDeviceManagerEx mAudioDeviceManager;
    private static String mDeviceId;
    private static String mPackageName;
    private BroadcastReceiver mBroadcastReceiver = null;
    private RTCASREngineEventHandler mRTCASREngineEventHandler;
    private AudioMixingManager mAudioMixingManager = null;
    private RTCFaceDetectionObserver mRTCFaceDetectionObserver = null;
    private PublicStreaming mPublicStreaming = null;
    private LogUtil.LoggerSink mLoggerSink = (level, msg, throwable) -> {
        IRTCEngineEventHandler handler = this.getRtcEngineHandler();
        try {
            if (handler != null) {
                handler.onLoggerMessage(level, msg, throwable);
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Exception in App thread when handler onLoggerMessage , e : " + e.getMessage()), (Throwable)e);
        }
    };
    private AppMonitor.Callback appStateCallback = state -> NativeFunctions.nativeSetAppState(this.mNativeEngine, state == 1 ? "active" : "background");
    private NetworkConnectChangeReceiver.Callback SetNetworkTypeCallback = (type, extraInfo) -> {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetNetworkType failed.");
            return;
        }
        NativeFunctions.nativeSetNetworkType(this.mNativeEngine, type, extraInfo);
    };

    public static Context getApplicationContext() {
        return RtcContextUtils.getApplicationContext();
    }

    public RTCEngineImpl(Context context, String appId, IRTCEngineEventHandler handler, JSONObject parameters) throws IllegalStateException {
        LogUtil.d(TAG, "create RtcEngineImpl with appId: " + appId);
        if (mLibraryLoaded && appId != null) {
            sRtcEngineInstance = this;
            Object eglEglBaseContext = null;
            long nativeEglContext = 0L;
            this.mEglThread = new HandlerThread("rtc_egl_thread");
            this.mEglThread.start();
            this.mVideoSinkTask = new VideoSinkTask();
            this.mVideoSinkTask.init();
            this.mEglHandler = new Handler(this.mEglThread.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(this.mEglHandler, () -> {
                this.initEglContext(null);
                this.mRootEglBase.createDummyPbufferSurface();
                this.mRootEglBase.makeCurrent();
                NativeFunctions.nativeSetHardWareEncodeContext();
                this.mRootEglBase.detachCurrent();
            });
            this.mRtcVideoPreprocessor = new RTCVideoProcessor(this);
            this.mContext = context.getApplicationContext();
            mPackageName = this.mContext.getPackageName();
            this.mAppId = appId;
            this.mState = State.IDLE;
            this.mRtcEngineHandler = new WeakReference<IRTCEngineEventHandler>(handler);
            LogUtil.setLoggerSink(this.mLoggerSink);
            this.mEngineEventHandler = new RTCEngineEventHandler(this);
            this.mEngineInternalEventHandler = new RTCEngineInternalEventHandler(this);
            this.mVideoFrameConverter = new VideoFrameConverter();
            this.mScreenFrameConverter = new VideoFrameConverter();
            this.mRtcVideoFrameObserver = new RTCVideoFrameObserver();
            this.mRtcAudioFrameObserver = new RTCAudioFrameObserver(this);
            this.mNativeAudioProcessor = new NativeAudioProcessor(this);
            this.mNativeAudioFrameProcessor = new NativeAudioFrameProcessor(this);
            this.mRtcLocalEncodedVideoFrameObserver = new RTCLocalEncodedVideoFrameObserver(this);
            this.mRtcRemoteEncodedVideoFrameObserver = new RTCRemoteEncodedVideoFrameObserver(this);
            this.mRtcMetadataObserver = new RTCMetadataObserver(this);
            this.mTranscodingObserver = new LiveTranscodingObserver();
            this.mRTCASREngineEventHandler = new RTCASREngineEventHandler();
            this.mRtcExVideoEncoderHandler = new RTCExternalVideoEncoderEventHandler(this);
            this.mRTCFaceDetectionObserver = new RTCFaceDetectionObserver(this);
            try {
                this.mNativeEngine = NativeFunctions.nativeCreateEngine(this.mContext.getApplicationContext(), appId, this.mEngineEventHandler, parameters == null ? "" : parameters.toString());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
                throw new UnsatisfiedLinkError("rtc loader info:" + sRtcLoaderInfo.toString() + " exception info:" + unsatisfiedLinkError.getStackTrace().toString());
            }
            if (this.engineInvalid()) {
                LogUtil.e(TAG, "create native engine error, native engine is invalid.");
            } else {
                NativeFunctions.nativeRegisterInternalEventObserver(this.mNativeEngine, this.mEngineInternalEventHandler);
            }
        } else {
            int errorCode;
            String errorMessage;
            JSONObject params = new JSONObject();
            if (!mLibraryLoaded) {
                errorMessage = "rtc sdk load so failed";
                errorCode = -1072;
            } else {
                errorMessage = "app id is null";
                errorCode = -1005;
            }
            try {
                params.put("event_key", (Object)"rtc_error");
                params.put("rtc_app_id", (Object)appId);
                params.put("device_id", (Object)mDeviceId);
                params.put("error_code", errorCode);
                params.put("message", (Object)errorMessage);
                params.put("timestamp", System.currentTimeMillis());
                params.put("rtc_timestamp", System.currentTimeMillis());
                params.put("os", (Object)"android");
                params.put("product_line", (Object)"rtc");
                params.put("report_version", 5);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (handler != null) {
                handler.onLogReport("live_webrtc_monitor_log", params);
                handler.onError(errorCode);
            }
            LogUtil.e(TAG, errorMessage);
            throw new IllegalStateException("Create engine failed " + errorMessage);
        }
        this.mBroadcastReceiver = new NetworkConnectChangeReceiver(this.SetNetworkTypeCallback);
        NetworkUtils.registerReceiver(context, this.mBroadcastReceiver);
        AppMonitor.get(context).register(context, this.appStateCallback);
    }

    private JSONObject AddParameters(JSONObject parameters, Context context) {
        String path;
        if (parameters == null) {
            parameters = new JSONObject();
        }
        if ((path = context.getFilesDir().getPath()) == null || path.isEmpty()) {
            path = "/data/data/" + context.getPackageName() + "/files";
        }
        try {
            parameters.put("rtc.log_location", (Object)(path + "/rtc_log"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return parameters;
    }

    @Override
    public void setInternalEventHandler(IRTCEngineInternalEventHandler handler) {
        this.mEngineInternalEventHandler.setInternalEventHandler(handler);
    }

    public IRTCEngineEventHandler getRtcEngineHandler() {
        return (IRTCEngineEventHandler)this.mRtcEngineHandler.get();
    }

    @Override
    public void setRtcEngineEventHandler(IRTCEngineEventHandler engineEventHandler) {
        LogUtil.d(TAG, "setRtcEngineEventHandler");
        this.mRtcEngineHandler = new WeakReference<IRTCEngineEventHandler>(engineEventHandler);
    }

    public IAudioFrameObserver getAudioFrameObserver() {
        return (IAudioFrameObserver)this.mAudioFrameObserver.get();
    }

    public IAudioProcessor getAudioProcessor() {
        return (IAudioProcessor)this.mAudioProcessor.get();
    }

    public IAudioFrameProcessor getAudioFrameProcessor() {
        return (IAudioFrameProcessor)this.mAudioFrameProcessor.get();
    }

    public IVideoProcessor getCustomVideoPreprocessor() {
        return (IVideoProcessor)this.mCustomVideoPreprocessor.get();
    }

    public ILocalEncodedVideoFrameObserver getEncodedVideoFrameObserver() {
        return (ILocalEncodedVideoFrameObserver)this.mLocalEncodedVideoFrameObserver.get();
    }

    public IRemoteEncodedVideoFrameObserver getRemoteEncodedVideoFrameObserver() {
        return (IRemoteEncodedVideoFrameObserver)this.mRemoteEncodedVideoFrameObserver.get();
    }

    public void doDestroy() {
        LogUtil.d(TAG, "destroy RtcEngineImpl.");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, no need to destroy now.");
            return;
        }
        this.mState = State.DESTORY;
        AudioMixingManager mixingManager = this.mAudioMixingManager;
        if (mixingManager instanceof AudioMixingManager) {
            mixingManager.destroy();
        }
        NetworkUtils.unregisterReceiver(this.mContext, this.mBroadcastReceiver);
        this.mBroadcastReceiver = null;
        NativeFunctions.nativeDestroyEngine(this.mNativeEngine);
        NativeFunctions.nativeClearHardWareEncodeContext();
        this.mNativeEngine = 0L;
        this.mIsFront = true;
        this.mIsVideoMirror = true;
        this.mVideoFrameConverter.dispose();
        this.mVideoFrameConverter = null;
        this.mScreenFrameConverter.dispose();
        this.mScreenFrameConverter = null;
        new Handler(Looper.getMainLooper()).post(() -> {
            if (this.mOnDestroyCompletedCallback != null) {
                this.mOnDestroyCompletedCallback.run();
            }
        });
        AppMonitor.get(this.mContext).unRegister(this.appStateCallback).release(this.mContext);
        this.mRtcVideoPreprocessor.dispose();
        this.mRtcVideoPreprocessor = null;
        ThreadUtils.invokeAtFrontUninterruptibly(this.mEglHandler, () -> {
            if (this.mRootEglBase != null) {
                this.mRootEglBase.release();
                this.mRootEglBase = null;
            }
        });
        if (this.mEglThread != null) {
            this.mEglThread.quit();
        }
        if (this.mVideoSinkTask != null) {
            this.mVideoSinkTask.exit();
        }
        LogUtil.setLoggerSink(null);
    }

    public static int setDeviceId(String deviceId) {
        if (deviceId == null) {
            return -1;
        }
        mDeviceId = deviceId;
        if (!mLibraryLoaded) {
            return -1;
        }
        return NativeFunctions.nativeSetDeviceId(deviceId);
    }

    public static int setEnv(RTCEngine.Env env) {
        if (!mLibraryLoaded) {
            return -1;
        }
        int rtcEnv = 0;
        switch (env) {
            case ENV_PRODUCT: {
                rtcEnv = 0;
                break;
            }
            case ENV_BOE: {
                rtcEnv = 1;
                break;
            }
            case ENV_TEST: {
                rtcEnv = 2;
                break;
            }
        }
        return NativeFunctions.nativeSetEnv(rtcEnv);
    }

    @Override
    public void startVideoCapture() {
        LogUtil.d(TAG, "startVideoCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startVideoCapture failed.");
            return;
        }
        NativeFunctions.nativeStartVideoCapture(this.mNativeEngine);
    }

    @Override
    public void stopVideoCapture() {
        LogUtil.d(TAG, "stopVideoCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopVideoCapture failed.");
            return;
        }
        NativeFunctions.nativeStopVideoCapture(this.mNativeEngine);
    }

    @Override
    public void startAudioCapture() {
        LogUtil.d(TAG, "startAudioCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startAudioCapture failed.");
            return;
        }
        NativeFunctions.nativeStartAudioCapture(this.mNativeEngine);
    }

    @Override
    public void stopAudioCapture() {
        LogUtil.d(TAG, "stopAudioCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopAudioCapture failed.");
            return;
        }
        NativeFunctions.nativeStopAudioCapture(this.mNativeEngine);
    }

    @Override
    public void setAudioScenario(AudioScenarioType audioScenario) {
        LogUtil.d(TAG, "setAudioScenario...audioScenario: " + (Object)((Object)audioScenario));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioScenario failed.");
            return;
        }
        int scenario = 0;
        switch (audioScenario) {
            case AUDIO_SCENARIO_MUSIC: {
                scenario = 0;
                break;
            }
            case AUDIO_SCENARIO_HIGHQUALITY_COMMUNICATION: {
                scenario = 1;
                break;
            }
            case AUDIO_SCENARIO_COMMUNICATION: {
                scenario = 2;
                break;
            }
            case AUDIO_SCENARIO_MEDIA: {
                scenario = 3;
                break;
            }
            case AUDIO_SCENARIO_GAME_STREAMING: {
                scenario = 4;
                break;
            }
            case AUDIO_SCENARIO_HIGHQUALITY_CHAT: {
                scenario = 5;
                break;
            }
        }
        NativeFunctions.nativeSetAudioScenario(this.mNativeEngine, scenario);
    }

    @Override
    public void setAudioProfile(AudioProfileType audioProfile) {
        LogUtil.d(TAG, "setAudioProfile:" + (Object)((Object)audioProfile));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioProfile failed.");
            return;
        }
        if (audioProfile != null) {
            NativeFunctions.nativeSetAudioProfile(this.mNativeEngine, audioProfile.value());
        }
    }

    @Override
    public void setVoiceChangerType(VoiceChangerType voiceChanger) {
        LogUtil.d(TAG, "setVoiceChangerType...voiceChanger: " + (Object)((Object)voiceChanger));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVoiceChangerType failed.");
        }
        int voice = 0;
        switch (voiceChanger) {
            case VOICE_CHANGER_ORIGINAL: {
                voice = 0;
                break;
            }
            case VOICE_CHANGER_GIANT: {
                voice = 1;
                break;
            }
            case VOICE_CHANGER_CHIPMUNK: {
                voice = 2;
                break;
            }
            case VOICE_CHANGER_MINIONST: {
                voice = 3;
                break;
            }
            case VOICE_CHANGER_VIBRATO: {
                voice = 4;
                break;
            }
            case VOICE_CHANGER_ROBOT: {
                voice = 5;
                break;
            }
        }
        NativeFunctions.nativeSetVoiceChangerType(this.mNativeEngine, voice);
    }

    @Override
    public void setVoiceReverbType(VoiceReverbType voiceReverb) {
        LogUtil.d(TAG, "setVoiceReverbType...voiceReverb: " + (Object)((Object)voiceReverb));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVoiceReverbType failed.");
        }
        int effect = 0;
        switch (voiceReverb) {
            case VOICE_REVERB_ORIGINAL: {
                effect = 0;
                break;
            }
            case VOICE_REVERB_ECHO: {
                effect = 1;
                break;
            }
            case VOICE_REVERB_CONCERT: {
                effect = 2;
                break;
            }
            case VOICE_REVERB_ETHEREAL: {
                effect = 3;
                break;
            }
            case VOICE_REVERB_KTV: {
                effect = 4;
                break;
            }
            case VOICE_REVERB_STUDIO: {
                effect = 5;
                break;
            }
        }
        NativeFunctions.nativeSetVoiceReverbType(this.mNativeEngine, effect);
    }

    public static int setParameters(String parameters) {
        if (!mLibraryLoaded) {
            return -1;
        }
        if (parameters == null || parameters.isEmpty()) {
            return -1;
        }
        return NativeFunctions.nativeSetParameters(parameters);
    }

    @Override
    public int setUserRole(ClientRole clientRole) {
        LogUtil.d(TAG, "setUserRole. role : " + (Object)((Object)clientRole));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setUserRole failed.");
            return -1;
        }
        int role = 2;
        switch (clientRole) {
            case CLIENT_ROLE_BROADCASTER: {
                role = 1;
                break;
            }
            case CLIENT_ROLE_SILENT_AUDIENCE: {
                role = 2;
                break;
            }
        }
        NativeFunctions.nativeSetUserRole(this.mNativeEngine, role);
        return 0;
    }

    @Override
    public int setUserVisibility(boolean enable) {
        LogUtil.d(TAG, "setUserVisibility. enable : " + enable);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setUserVisibility failed.");
            return -1;
        }
        NativeFunctions.nativeSetUserVisibility(this.mNativeEngine, enable);
        return 0;
    }

    @Override
    public int publish() {
        LogUtil.d(TAG, "publish");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, publish failed.");
            return -1;
        }
        NativeFunctions.nativePublish(this.mNativeEngine);
        return 0;
    }

    @Override
    public int publishStream(MediaStreamType type) {
        LogUtil.d(TAG, "publish");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, publish failed.");
            return -1;
        }
        NativeFunctions.nativePublishStream(this.mNativeEngine, type.value);
        return 0;
    }

    @Override
    public int unpublish() {
        LogUtil.d(TAG, "unpublish");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, unpublish failed.");
            return -1;
        }
        NativeFunctions.nativeUnPublish(this.mNativeEngine);
        return 0;
    }

    @Override
    public int unpublishStream(MediaStreamType type) {
        LogUtil.d(TAG, "unpublishStream");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, unpublishStream failed.");
            return -1;
        }
        NativeFunctions.nativeUnpublishStream(this.mNativeEngine, type.value);
        return 0;
    }

    @Override
    public int startAudioMixing(String filePath, boolean loopback, boolean replace, int cycle) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startAudioMixing failed.");
            return -1;
        }
        return NativeFunctions.nativeStartAudioMixing(this.mNativeEngine, filePath, loopback, replace, cycle);
    }

    @Override
    public int stopAudioMixing() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopAudioMixing failed.");
            return -1;
        }
        NativeFunctions.nativeStopAudioMixing(this.mNativeEngine);
        return 0;
    }

    @Override
    public void setRecordingVolume(int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setRecordingVolume failed.");
            return;
        }
        NativeFunctions.nativeSetRecordingVolume(this.mNativeEngine, volume);
    }

    @Override
    public void setPlaybackVolume(int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setPlaybackVolume failed.");
            return;
        }
        NativeFunctions.nativeSetPlaybackVolume(this.mNativeEngine, volume);
    }

    @Override
    public void setLocalVoicePitch(int pitch) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setLocalVoicePitch failed.");
            return;
        }
        NativeFunctions.nativeSetLocalVoicePitch(this.mNativeEngine, pitch);
    }

    @Override
    public void enableVocalInstrumentBalance(boolean enable) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, EnableVocalInstrumentBalance failed.");
            return;
        }
        NativeFunctions.nativeEnableVocalInstrumentBalance(this.mNativeEngine, enable);
    }

    @Override
    public void enablePlaybackDucking(boolean enable) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, EnablePlaybackDucking failed.");
            return;
        }
        NativeFunctions.nativeEnablePlaybackDucking(this.mNativeEngine, enable);
    }

    @Override
    public int pauseAudioMixing() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, pauseAudioMixing failed.");
            return -1;
        }
        return NativeFunctions.nativePauseAudioMixing(this.mNativeEngine);
    }

    @Override
    public int resumeAudioMixing() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, resumeAudioMixing failed.");
            return -1;
        }
        return NativeFunctions.nativeResumeAudioMixing(this.mNativeEngine);
    }

    @Override
    public int adjustAudioMixingVolume(int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, adjustAudioMixingVolume failed.");
            return -1;
        }
        return NativeFunctions.nativeAdjustAudioMixingVolume(this.mNativeEngine, volume);
    }

    @Override
    public int getAudioMixingDuration() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getAudioMixingDuration failed.");
            return -1;
        }
        return NativeFunctions.nativeGetAudioMixingDuration(this.mNativeEngine);
    }

    @Override
    public int getAudioMixingCurrentPosition() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getAudioMixingCurrentPosition failed.");
            return -1;
        }
        return NativeFunctions.nativeGetAudioMixingCurrentPosition(this.mNativeEngine);
    }

    @Override
    public int setAudioMixingPosition(int pos) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioMixingPosition failed.");
            return -1;
        }
        return NativeFunctions.nativeSetAudioMixingPosition(this.mNativeEngine, pos);
    }

    @Override
    public int adjustAudioMixingPlayoutVolume(int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, adjustAudioMixingPlayoutVolume failed.");
            return -1;
        }
        return NativeFunctions.nativeAdjustAudioMixingPlayoutVolume(this.mNativeEngine, volume);
    }

    @Override
    public int adjustAudioMixingPublishVolume(int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, adjustAudioMixingPublishVolume failed.");
            return -1;
        }
        return NativeFunctions.nativeAdjustAudioMixingPublishVolume(this.mNativeEngine, volume);
    }

    @Override
    public int getEffectVolume(int soundId) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getEffectVolume failed.");
            return -1;
        }
        return NativeFunctions.nativeGetEffectVolume(this.mNativeEngine, soundId);
    }

    @Override
    public int setVolumeOfEffect(int soundId, int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVolumeOfEffect failed.");
            return -1;
        }
        return NativeFunctions.nativeSetVolumeOfEffect(this.mNativeEngine, soundId, volume);
    }

    @Override
    public int setEffectsVolume(int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setEffectsVolume failed.");
            return -1;
        }
        return NativeFunctions.nativeSetEffectsVolume(this.mNativeEngine, volume);
    }

    @Override
    public int playEffect(int soundId, String filePath, boolean loopback, int cycle, int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, playEffect failed.");
            return -1;
        }
        return NativeFunctions.nativePlayEffect(this.mNativeEngine, soundId, filePath, loopback, cycle, volume);
    }

    @Override
    public int preloadEffect(int soundId, String filePath) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, preloadEffect failed.");
            return -1;
        }
        return NativeFunctions.nativePreloadEffect(this.mNativeEngine, soundId, filePath);
    }

    @Override
    public int unloadEffect(int soundId) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, unloadEffect failed.");
            return -1;
        }
        return NativeFunctions.nativeUnloadEffect(this.mNativeEngine, soundId);
    }

    @Override
    public int stopEffect(int soundId) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopEffect failed.");
            return -1;
        }
        return NativeFunctions.nativeStopEffect(this.mNativeEngine, soundId);
    }

    @Override
    public int pauseEffect(int soundId) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, pauseEffect failed.");
            return -1;
        }
        return NativeFunctions.nativePauseEffect(this.mNativeEngine, soundId);
    }

    @Override
    public int resumeEffect(int soundId) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, resumeEffect failed.");
            return -1;
        }
        return NativeFunctions.nativeResumeEffect(this.mNativeEngine, soundId);
    }

    @Override
    public int stopAllEffects() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopAllEffects failed.");
            return -1;
        }
        return NativeFunctions.nativeStopAllEffects(this.mNativeEngine);
    }

    @Override
    public int unloadAllEffects() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, unloadAllEffects failed.");
            return -1;
        }
        return NativeFunctions.nativeUnloadAllEffects(this.mNativeEngine);
    }

    @Override
    public int pauseAllEffects() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, pauseAllEffects failed.");
            return -1;
        }
        return NativeFunctions.nativePauseAllEffects(this.mNativeEngine);
    }

    @Override
    public int resumeAllEffects() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, resumeAllEffects failed.");
            return -1;
        }
        return NativeFunctions.nativeResumeAllEffects(this.mNativeEngine);
    }

    @Override
    public void enableAudioFrameCallback(AudioFrameCallbackMethod method, AudioFormat format) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableAudioFrameCallback failed.");
            return;
        }
        NativeFunctions.nativeEnableAudioFrameCallback(this.mNativeEngine, method.value(), format.sampleRate.value(), format.channel.value());
    }

    @Override
    public void disableAudioFrameCallback(AudioFrameCallbackMethod method) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, disableAudioFrameCallback failed.");
            return;
        }
        NativeFunctions.nativeDisableAudioFrameCallback(this.mNativeEngine, method.value());
    }

    @Override
    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        this.mAudioFrameObserver = new WeakReference<IAudioFrameObserver>(observer);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerAudioFrameObserver failed.");
            return -1;
        }
        if (observer == null) {
            NativeFunctions.nativeSetAudioFrameObserver(this.mNativeEngine, null);
        } else {
            NativeFunctions.nativeSetAudioFrameObserver(this.mNativeEngine, this.mRtcAudioFrameObserver);
        }
        return 0;
    }

    @Override
    public int registerLocalAudioProcessor(IAudioProcessor audioProcessor, AudioFormat audioFormat) {
        this.mAudioProcessor = new WeakReference<IAudioProcessor>(audioProcessor);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerAudioFrameObserver failed.");
            return -1;
        }
        if (audioProcessor == null) {
            NativeFunctions.nativeSetAudioProcessor(this.mNativeEngine, null, -1, -1);
        } else {
            NativeFunctions.nativeSetAudioProcessor(this.mNativeEngine, this.mNativeAudioProcessor, audioFormat.sampleRate.value(), audioFormat.channel.value());
        }
        return 0;
    }

    @Override
    public int registerAudioProcessor(IAudioFrameProcessor audioFrameProcessor) {
        this.mAudioFrameProcessor = new WeakReference<IAudioFrameProcessor>(audioFrameProcessor);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerAudioProcessor failed.");
            return -1;
        }
        if (audioFrameProcessor == null) {
            NativeFunctions.nativeSetAudioFrameProcessor(this.mNativeEngine, null);
        } else {
            NativeFunctions.nativeSetAudioFrameProcessor(this.mNativeEngine, this.mNativeAudioFrameProcessor);
        }
        return 0;
    }

    @Override
    public void enableAudioProcessor(AudioProcessorMethod method, AudioFormat format) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableAudioProcessor failed.");
            return;
        }
        NativeFunctions.nativeEnableAudioProcessor(this.mNativeEngine, method.value(), format.sampleRate.value(), format.channel.value());
    }

    @Override
    public void disableAudioProcessor(AudioProcessorMethod method) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, disableAudioProcessor failed.");
            return;
        }
        NativeFunctions.nativeDisableAudioProcessor(this.mNativeEngine, method.value());
    }

    @Override
    public int registerLocalVideoProcessor(IVideoProcessor processor, VideoPreprocessorConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerLocalVideoProcessor failed.");
            return -1;
        }
        if (config == null) {
            config = new VideoPreprocessorConfig();
        }
        if (this.mRtcVideoPreprocessor == null || this.mRtcVideoPreprocessor.registerLocalVideoProcessor(processor, config.required_pixel_format) != 0) {
            return -1;
        }
        this.mCustomVideoPreprocessor = new WeakReference<IVideoProcessor>(processor);
        VideoPixelFormat adapted_format = config.required_pixel_format;
        if (adapted_format != VideoPixelFormat.kVideoPixelFormatI420 && adapted_format != VideoPixelFormat.kVideoPixelFormatUnknown) {
            adapted_format = VideoPixelFormat.kVideoPixelFormatUnknown;
        }
        if (processor == null) {
            return NativeFunctions.nativeRegisterLocalVideoProcessor(this.mNativeEngine, null, adapted_format.value());
        }
        return NativeFunctions.nativeRegisterLocalVideoProcessor(this.mNativeEngine, this.mRtcVideoPreprocessor, adapted_format.value());
    }

    @Override
    public void registerLocalEncodedVideoFrameObserver(ILocalEncodedVideoFrameObserver observer) {
        this.mLocalEncodedVideoFrameObserver = new WeakReference<ILocalEncodedVideoFrameObserver>(observer);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerAudioFrameObserver failed.");
            return;
        }
        if (observer == null) {
            NativeFunctions.nativeRegisterLocalEncodedVideoFrameObserver(this.mNativeEngine, null);
        } else {
            NativeFunctions.nativeRegisterLocalEncodedVideoFrameObserver(this.mNativeEngine, this.mRtcLocalEncodedVideoFrameObserver);
        }
    }

    @Override
    public void registerRemoteEncodedVideoFrameObserver(IRemoteEncodedVideoFrameObserver observer) {
        this.mRemoteEncodedVideoFrameObserver = new WeakReference<IRemoteEncodedVideoFrameObserver>(observer);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, RegisterRemoteEncodedVideoFrameObserver failed.");
            return;
        }
        if (observer == null) {
            NativeFunctions.nativeRegisterRemoteEncodedVideoFrameObserver(this.mNativeEngine, null);
        } else {
            NativeFunctions.nativeRegisterRemoteEncodedVideoFrameObserver(this.mNativeEngine, this.mRtcRemoteEncodedVideoFrameObserver);
        }
    }

    private boolean engineInvalid() {
        return this.mNativeEngine == 0L;
    }

    @Override
    public int setRemoteVideoCanvas(String userId, StreamIndex streamIndex, VideoCanvas canvas) {
        if (canvas == null || canvas.uid == null) {
            LogUtil.i(TAG, "EventType: setupRemoteVideo canvas or uid is null");
            return -1;
        }
        NativeFunctions.nativeSetRemoteVideoCanvas(this.mNativeEngine, canvas.uid, streamIndex.value(), canvas.renderView, canvas.renderMode, canvas.background_color);
        return 0;
    }

    @Override
    @Deprecated
    public int setupLocalVideoRender(com.ss.bytertc.engine.mediaio.IVideoSink deprecatedVideoSink, String uid) {
        VideoSinkAdapter sinkAdapter;
        if (uid == null) {
            LogUtil.e(TAG, "EventType: setupLocalVideoRender, uid is null");
            return -2;
        }
        if (deprecatedVideoSink == null) {
            LogUtil.i(TAG, "EventType: setupLocalVideoRender deprecatedVideoSink is null");
            sinkAdapter = null;
        } else {
            LogUtil.i(TAG, "EventType: setupLocalVideoRender canvas:" + deprecatedVideoSink.hashCode());
            sinkAdapter = new VideoSinkAdapter(deprecatedVideoSink, this.mVideoSinkTask);
            deprecatedVideoSink.onInitialize();
            deprecatedVideoSink.onStart();
        }
        this.setLocalVideoSink(StreamIndex.STREAM_INDEX_MAIN, sinkAdapter, 1);
        return 0;
    }

    @Override
    @Deprecated
    public int setupRemoteVideoRender(com.ss.bytertc.engine.mediaio.IVideoSink deprecatedVideoSink, String uid) {
        return this.setupRemoteVideoRender(deprecatedVideoSink, this.mRoom, uid);
    }

    @Override
    @Deprecated
    public int setupRemoteVideoRender(com.ss.bytertc.engine.mediaio.IVideoSink deprecatedVideoSink, String roomid, String uid) {
        VideoSinkAdapter sinkAdapter;
        if (uid == null) {
            LogUtil.e(TAG, "EventType: setupRemoteVideoRender, uid is null");
            return -2;
        }
        if (deprecatedVideoSink == null) {
            LogUtil.i(TAG, "EventType: setupRemoteVideoRender deprecatedVideoSink is null");
            sinkAdapter = null;
        } else {
            LogUtil.i(TAG, "EventType: setupLocalVideoRender canvas:" + deprecatedVideoSink.hashCode());
            sinkAdapter = new VideoSinkAdapter(deprecatedVideoSink, this.mVideoSinkTask);
            deprecatedVideoSink.onInitialize();
            deprecatedVideoSink.onStart();
        }
        RemoteStreamKey key = new RemoteStreamKey(this.mRoom, uid, StreamIndex.STREAM_INDEX_MAIN);
        this.setRemoteVideoSink(key, sinkAdapter, 1);
        return 0;
    }

    @Override
    public void setRemoteVideoSink(RemoteStreamKey streamKey, IVideoSink videoSink, int requiredFormat) {
        if (streamKey == null) {
            LogUtil.e(TAG, "EventType: setupRemoteRenderInternal, streamKey is null");
            return;
        }
        if (streamKey.getStreamIndex() == null) {
            LogUtil.e(TAG, "EventType: setupRemoteRenderInternal, streamIndex is null");
            return;
        }
        String roomid = streamKey.getRoomId() == null || streamKey.getRoomId().isEmpty() ? (this.mRoom != null ? this.mRoom : "") : streamKey.getRoomId();
        VideoSinkAdapter sinkAdapter = null;
        if (videoSink != null) {
            sinkAdapter = new VideoSinkAdapter(videoSink);
        }
        NativeFunctions.nativeSetRemoteVideoSink(this.mNativeEngine, roomid, streamKey.getUserId(), streamKey.getStreamIndex().value(), sinkAdapter, requiredFormat);
    }

    @Override
    public void setLocalVideoSink(StreamIndex index, IVideoSink videoSink, int requiredFormat) {
        if (index == null) {
            LogUtil.e(TAG, "EventType: setLocalVideoSink, streamIndex is null");
            return;
        }
        VideoSinkAdapter sinkAdapter = null;
        if (videoSink != null) {
            sinkAdapter = new VideoSinkAdapter(videoSink);
        }
        NativeFunctions.nativeSetLocalVideoSink(this.mNativeEngine, index.value(), sinkAdapter, requiredFormat);
    }

    private int setupRemoteVideoRenderInternal(com.ss.bytertc.engine.mediaio.IVideoSink videoSink, String roomid, @NonNull String uid, boolean isScreen, boolean isInitialized) {
        if (uid == null) {
            LogUtil.e(TAG, "EventType: setupRemoteRenderInternal, uid is null");
            return -2;
        }
        if (videoSink == null) {
            LogUtil.i(TAG, "EventType: setupRemoteRenderInternal videoSink is null");
            Object sinkAdapter = null;
        } else {
            LogUtil.i(TAG, "EventType: setupRemoteRenderInternal canvas:" + videoSink.hashCode());
            VideoSinkAdapter sinkAdapter = new VideoSinkAdapter(videoSink, this.mVideoSinkTask);
        }
        return 0;
    }

    @Override
    public int setLocalVideoMirrorMode(MirrorMode mode) {
        this.mIsVideoMirror = mode != MirrorMode.MIRROR_MODE_OFF;
        NativeFunctions.nativeSetLocalVideoMirrorMode(this.mNativeEngine, mode.value());
        return 0;
    }

    @Override
    public int setLocalVideoMirrorType(MirrorType mirrorType) {
        NativeFunctions.nativeSetLocalVideoMirrorType(this.mNativeEngine, mirrorType.value());
        return 0;
    }

    @Override
    public int setVideoRotationMode(VideoRotationMode rotationMode) {
        return NativeFunctions.nativeSetVideoRotationMode(this.mNativeEngine, rotationMode.value());
    }

    public String getLocalUser() {
        return this.mUser;
    }

    public String getRoomName() {
        return this.mRoom;
    }

    @Override
    public int setLocalVideoCanvas(StreamIndex index, VideoCanvas videoCanvas) {
        if (videoCanvas == null) {
            LogUtil.i(TAG, "EventType: setLocalVideoCanvas canvas is null");
            return -1;
        }
        NativeFunctions.nativeSetLocalVideoCanvas(this.mNativeEngine, index.value(), videoCanvas.renderView, videoCanvas.renderMode, videoCanvas.background_color);
        return 0;
    }

    @Override
    public int updateLocalVideoCanvas(StreamIndex index, int renderMode, int background_color) {
        NativeFunctions.nativeUpdateLocalVideoCanvas(this.mNativeEngine, index.value(), renderMode, background_color);
        return 0;
    }

    @Override
    public void updateRemoteStreamVideoCanvas(String roomId, String userId, StreamIndex index, int renderMode, int background_color) {
        NativeFunctions.nativeUpdateRemoteStreamVideoCanvas(this.mNativeEngine, roomId, userId, index.value(), renderMode, background_color);
    }

    private int setLocalRenderInternal(com.ss.bytertc.engine.mediaio.IVideoSink videoSink, @NonNull String uid, boolean isScreen, boolean isInitialized) {
        if (uid == null) {
            LogUtil.e(TAG, "setLocalRenderInternal, uid is null set failed.");
            return -2;
        }
        if (videoSink == null) {
            LogUtil.i(TAG, "EventType: setLocalRenderInternal videoSink is null, ThreadPool  workthreadID" + Thread.currentThread().getId());
            Object sinkAdapter = null;
        } else {
            LogUtil.i(TAG, "EventType: setLocalRenderInternal videoSink:" + videoSink.hashCode() + ", ThreadPool  workthreadID" + Thread.currentThread().getId());
            VideoSinkAdapter sinkAdapter = new VideoSinkAdapter(videoSink, this.mVideoSinkTask);
        }
        if (!isScreen) {
            // empty if block
        }
        return 0;
    }

    @Override
    public int joinRoom(String token, String roomId, @NonNull UserInfo userInfo, ChannelProfile profile_type) {
        LogUtil.d(TAG, "joinChannel with token: " + token + " , roomId: " + roomId + " and uid: " + (userInfo == null ? "" : userInfo.getUid()));
        if (this.mState != State.IDLE) {
            return -4;
        }
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, joinChannel failed.");
            return -3;
        }
        if (userInfo == null) {
            LogUtil.e(TAG, "userInfo is null, joinChannel failed");
            return -2;
        }
        if (userInfo.getUid() == null || userInfo.getUid().isEmpty()) {
            LogUtil.e(TAG, "uid is invalid, joinChannel failed.");
            return -2;
        }
        if (roomId == null || roomId.isEmpty()) {
            LogUtil.e(TAG, "channel is invalid, joinChannel failed.");
            return -1;
        }
        this.mState = State.IN_ROOM;
        this.mRoom = roomId;
        this.mUser = userInfo.getUid();
        int profileType = 0;
        switch (profile_type) {
            case CHANNEL_PROFILE_GAME: {
                profileType = 2;
                break;
            }
            case CHANNEL_PROFILE_CLOUD_GAME: {
                profileType = 3;
                break;
            }
            case CHANNEL_PROFILE_COMMUNICATION: {
                profileType = 0;
                break;
            }
            case CHANNEL_PROFILE_LIVE_BROADCASTING: {
                profileType = 1;
                break;
            }
            case CHANNEL_PROFILE_LOW_LATENCY: {
                profileType = 4;
                break;
            }
            case CHANNEL_PROFILE_CHAT: {
                profileType = 5;
                break;
            }
            case CHANNEL_PROFILE_CHAT_ROOM: {
                profileType = 6;
                break;
            }
            case CHANNEL_PROFILE_LW_TOGETHER: {
                profileType = 7;
                break;
            }
            case CHANNEL_PROFILE_GAME_HD: {
                profileType = 8;
                break;
            }
            case CHANNEL_PROFILE_CO_HOST: {
                profileType = 9;
                break;
            }
            case CHANNEL_PROFILE_INTERACTIVE_PODCAST: {
                profileType = 10;
                break;
            }
            case CHANNEL_PROFILE_KTV: {
                profileType = 11;
                break;
            }
            case CHANNEL_PROFILE_CHORUS: {
                profileType = 12;
                break;
            }
            case CHANNEL_PROFIEL_VR_CHAT: {
                profileType = 13;
                break;
            }
            case CHANNEL_PROFILE_GAME_STREAMING: {
                profileType = 14;
                break;
            }
            case CHANNEL_PROFILE_LAN_LIVE_STREAMING: {
                profileType = 15;
                break;
            }
            case CHANNEL_PROFIEL_MEETING: {
                profileType = 16;
                break;
            }
            case CHANNEL_PROFILE_MEETING_ROOM: {
                profileType = 17;
                break;
            }
            case CHANNEL_PROFILE_CLASSROOM: {
                profileType = 18;
                break;
            }
        }
        int joinres = NativeFunctions.nativeJoinRoom(this.mNativeEngine, token, roomId, userInfo, profileType);
        return Math.min(joinres, 0);
    }

    @Override
    public int joinRoom(String token, String roomId, UserInfo userInfo, RTCRoomConfig roomConfig) {
        if (roomId == null || roomId.isEmpty()) {
            LogUtil.e(TAG, "channel is invalid, joinChannel failed.");
            return -1;
        }
        if (userInfo == null || userInfo.getUid() == null || userInfo.getUid().isEmpty()) {
            LogUtil.e(TAG, "userInfo is null, joinChannel failed");
            return -2;
        }
        LogUtil.d(TAG, "joinChannel with token: " + token + " , roomId: " + roomId + " and uid: " + (userInfo.getUid() == null ? "" : userInfo.getUid()));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, joinChannel failed.");
            return -3;
        }
        this.mState = State.IN_ROOM;
        this.mRoom = roomId;
        this.mUser = userInfo.getUid();
        int joinres = NativeFunctions.nativeJoinRoomWithRoomConfig(this.mNativeEngine, token, roomId, userInfo, roomConfig);
        return Math.min(joinres, 0);
    }

    @Override
    public int leaveRoom() {
        IRTCEngineEventHandler handler;
        LogUtil.d(TAG, "leaveChannel");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, leaveChannel failed.");
            return -1;
        }
        this.mState = State.IDLE;
        this.mRoom = "";
        this.mUser = "";
        this.mSessionId = "";
        this.mToken = "";
        IRTCEngineEventHandler iRTCEngineEventHandler = handler = this.mRtcEngineHandler == null ? null : (IRTCEngineEventHandler)this.mRtcEngineHandler.get();
        if (handler != null) {
            handler.onLeaveRoom(null);
        }
        NativeFunctions.nativeLeaveRoom(this.mNativeEngine);
        return 0;
    }

    public static String getSdkVersion() {
        String sdkVersion = "";
        if (!mLibraryLoaded) {
            return sdkVersion;
        }
        try {
            sdkVersion = NativeFunctions.nativeGetSDKVersion();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            throw new UnsatisfiedLinkError("rtc loader info:" + sRtcLoaderInfo.toString() + " exception info:" + unsatisfiedLinkError.getStackTrace().toString());
        }
        return NativeFunctions.nativeGetSDKVersion();
    }

    public static String getErrorDescription(int code) {
        String description = "";
        switch (code) {
            case -1072: {
                description = "Failed to load library.";
                break;
            }
            default: {
                description = NativeFunctions.nativeGetErrorDescription(code);
            }
        }
        return description;
    }

    @Override
    public boolean isSpeakerphoneEnabled() {
        Context context = this.mContext;
        if (context == null) {
            return false;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager.isSpeakerphoneOn();
    }

    @Override
    public void muteLocalAudio(MuteState muteState) {
        LogUtil.d(TAG, "muteLocalAudio " + muteState.value());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, muteLocalAudio failed.");
            return;
        }
        NativeFunctions.nativeMuteLocalAudio(this.mNativeEngine, muteState.value());
    }

    @Override
    public void muteAllRemoteAudio(MuteState muteState) {
        LogUtil.d(TAG, "muteAllRemoteAudio: " + muteState.value());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, muteAllRemoteAudio failed.");
            return;
        }
        NativeFunctions.nativeMuteAllRemoteAudio(this.mNativeEngine, muteState.value());
    }

    @Override
    public void pauseAllSubscribedStream(PauseResumeControlMediaType mediaType) {
        LogUtil.d(TAG, "pauseAllSubscribedStream: " + (Object)((Object)mediaType));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, muteAllRemoteAudio failed.");
            return;
        }
        int pause_type = 0;
        switch (mediaType) {
            case RTC_PAUSE_RESUME_CONTROL_AUDIO: {
                pause_type = 0;
                break;
            }
            case RTC_PAUSE_RESUME_CONTROL_VIDEO: {
                pause_type = 1;
                break;
            }
            case RTC_PAUSE_RESUME_CONTROL_AUDIO_AND_VIDEO: {
                pause_type = 2;
            }
        }
        NativeFunctions.nativePauseAllSubscribedStream(this.mNativeEngine, pause_type);
    }

    @Override
    public void resumeAllSubscribedStream(PauseResumeControlMediaType mediaType) {
        LogUtil.d(TAG, "resumeAllSubscribedStream: " + (Object)((Object)mediaType));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, muteAllRemoteAudio failed.");
            return;
        }
        int resume_type = 0;
        switch (mediaType) {
            case RTC_PAUSE_RESUME_CONTROL_AUDIO: {
                resume_type = 0;
                break;
            }
            case RTC_PAUSE_RESUME_CONTROL_VIDEO: {
                resume_type = 1;
                break;
            }
            case RTC_PAUSE_RESUME_CONTROL_AUDIO_AND_VIDEO: {
                resume_type = 2;
            }
        }
        NativeFunctions.nativeResumeAllSubscribedStream(this.mNativeEngine, resume_type);
    }

    @Override
    public void muteRemoteAudio(@NonNull String uid, MuteState muteState) {
        LogUtil.d(TAG, "muteRemoteAudio, uid: " + uid + " , muted: " + muteState.value());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, muteRemoteAudio failed.");
            return;
        }
        if (uid == null) {
            LogUtil.e(TAG, "muteRemoteAudio, uid is null mute failed.");
            return;
        }
        NativeFunctions.nativeMuteRemoteAudio(this.mNativeEngine, uid, muteState.value());
    }

    @Override
    public int muteRemoteVideo(String uid, MuteState muteState) {
        boolean muted = muteState == MuteState.MUTE_STATE_ON;
        LogUtil.d(TAG, "muteRemoteVideoStream, uid: " + uid + " , muted: " + muted);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, muteRemoteVideo failed.");
            return -1;
        }
        if (uid == null) {
            LogUtil.e(TAG, "muteRemoteVideoStream, uid is null mute failed");
            return -2;
        }
        NativeFunctions.nativeMuteRemoteVideo(this.mNativeEngine, uid, muteState.value());
        return 0;
    }

    @Override
    public int updateToken(String var1) {
        LogUtil.d(TAG, "updateToken: " + var1);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, updateToken failed.");
            return -1;
        }
        NativeFunctions.nativeUpdateToken(this.mNativeEngine, var1);
        return 0;
    }

    @Override
    public int switchCamera(CameraId cameraId) {
        LogUtil.d(TAG, "switchCamera");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, switchCamera failed.");
            return -1;
        }
        NativeFunctions.nativeSwitchCamera(this.mNativeEngine, cameraId.value());
        this.mIsFront = !this.mIsFront;
        return 0;
    }

    @Override
    public int replaceBackground(BackgroundMode mode, DivideModel divide_model) {
        return 0;
    }

    @Override
    public void muteLocalVideo(MuteState muteState) {
        LogUtil.d(TAG, "muteLocalVideo: " + muteState.toString());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, muteLocalVideoStream failed.");
        }
        NativeFunctions.nativeMuteLocalVideo(this.mNativeEngine, muteState.value());
    }

    @Override
    public int muteAllRemoteVideo(MuteState muteState) {
        boolean muted = muteState == MuteState.MUTE_STATE_ON;
        LogUtil.d(TAG, "muteAllRemoteVideoStreams: " + muted);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, muteAllRemoteVideoStreams failed.");
            return -1;
        }
        NativeFunctions.nativeMuteAllRemoteVideo(this.mNativeEngine, muteState.value());
        return 0;
    }

    @Override
    public void setAudioVolumeIndicationInterval(int interval) {
        LogUtil.d(TAG, "setAudioVolumeIndicationInterval interval: " + interval);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioVolumeIndicationInterval failed.");
            return;
        }
        NativeFunctions.nativeSetAudioVolumeIndicationInterval(this.mNativeEngine, interval);
    }

    @Override
    public void setVideoInputType(MediaInputType type) {
        boolean bl = this.mUseExtVideoSource = type == MediaInputType.MEDIA_INPUT_TYPE_EXTERNAL;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoInputType failed.");
            return;
        }
        NativeFunctions.nativeSetVideoInputType(this.mNativeEngine, type.value());
    }

    @Override
    public void setVideoSourceType(VideoSourceType type) {
        boolean bl = this.mUseExtVideoSource = type == VideoSourceType.VIDEO_SOURCE_TYPE_EXTERNAL;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoInputType failed.");
            return;
        }
        NativeFunctions.nativeSetVideoSourceType(this.mNativeEngine, type.value());
    }

    @Override
    public void setVideoSourceType(StreamIndex index, VideoSourceType type) {
        boolean bl = this.mUseExtVideoSource = type == VideoSourceType.VIDEO_SOURCE_TYPE_EXTERNAL;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoInputType failed.");
            return;
        }
        NativeFunctions.nativeSetVideoSourceTypeWithStreamId(this.mNativeEngine, index.value(), type.value());
    }

    @Override
    public void startLiveTranscoding(String taskId, LiveTranscoding liveTranscode, ILiveTranscodingObserver observer) {
        this.mLiveTranscodingObserver = observer;
        if (this.mTranscodingObserver != null) {
            this.mTranscodingObserver.setUserObserver(taskId, this.mLiveTranscodingObserver);
        }
        LogUtil.d(TAG, "enableLiveTranscoding...");
        if (liveTranscode == null) {
            LogUtil.d(TAG, "enableLiveTranscoding...liveTranscode is null, no effect, please check.");
            return;
        }
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableLiveTranscoding failed.");
            return;
        }
        this.mEnableTranscode = true;
        this.mLiveTranscoding = liveTranscode;
        this.mLiveTranscoding.setAction("started");
        JSONObject jsonObject = this.mLiveTranscoding.getTranscodeMessage();
        if (jsonObject == null) {
            return;
        }
        String message = jsonObject.toString();
        LogUtil.d(TAG, "enableLiveTranscoding...liveTranscodeJson: " + message);
        NativeFunctions.nativeStartLiveTranscoding(this.mNativeEngine, taskId, this.mLiveTranscoding, this.mTranscodingObserver);
    }

    @Override
    public void stopLiveTranscoding(String taskId) {
        LogUtil.d(TAG, "disableLiveTranscoding...");
        this.mEnableTranscode = false;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, disableLiveTranscoding failed.");
            return;
        }
        NativeFunctions.nativeStopLiveTranscoding(this.mNativeEngine, taskId);
    }

    @Override
    public void updateLiveTranscoding(String taskId, LiveTranscoding transcoding) {
        LogUtil.d(TAG, "updateLiveTranscoding...");
        if (transcoding == null) {
            LogUtil.d(TAG, "updateLiveTranscoding...mLiveTranscoding is null, no effect, please check.");
            return;
        }
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, updateLiveTranscoding failed.");
            return;
        }
        transcoding.setAction("layoutChanged");
        JSONObject jsonObject = transcoding.getTranscodeMessage();
        if (jsonObject == null) {
            return;
        }
        String message = jsonObject.toString();
        LogUtil.d(TAG, "updateLiveTranscoding...liveTranscodeJson: " + message);
        NativeFunctions.nativeUpdateLiveTranscoding(this.mNativeEngine, taskId, transcoding);
    }

    @Override
    public int setAudioPlaybackDevice(AudioPlaybackDevice audioPlaybackDevice) {
        LogUtil.d(TAG, "setAudioPlaybackDevice: " + audioPlaybackDevice.value());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioPlaybackDevice failed.");
            return -1;
        }
        return NativeFunctions.nativeSetAudioPlaybackDevice(this.mNativeEngine, audioPlaybackDevice.value());
    }

    @Override
    public int setAudioRoute(AudioRoute audioRoute) {
        LogUtil.d(TAG, "setAudioRoute: " + audioRoute.value());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioRoute failed.");
            return -1;
        }
        if (audioRoute == null) {
            LogUtil.e(TAG, "param audioRoute is null, setAudioRoute failed.");
            return -1;
        }
        return NativeFunctions.nativeSetAudioRoute(this.mNativeEngine, audioRoute.value());
    }

    @Override
    public int setDefaultAudioRoute(AudioRoute audioRoute) {
        LogUtil.d(TAG, "setDefaultAudioRoute: " + audioRoute.value());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setDefaultAudioRoute failed.");
            return -1;
        }
        return NativeFunctions.nativeSetDefaultAudioRoute(this.mNativeEngine, audioRoute.value());
    }

    @Override
    public AudioRoute getAudioRoute() {
        LogUtil.d(TAG, "getAudioRoute");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getAudioRoute failed.");
            return null;
        }
        int res = NativeFunctions.nativeGetAudioRoute(this.mNativeEngine);
        return AudioRoute.fromId(res);
    }

    @Override
    public void enableExternalSoundCard(boolean enable) {
        LogUtil.d(TAG, "enableExternalSoundCard: " + enable);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableExternalSoundCard failed.");
            return;
        }
        NativeFunctions.nativeEnableExternalSoundCard(this.mNativeEngine, enable);
    }

    public void setAudioMode(int audioMode) {
        if (this.mContext == null) {
            return;
        }
        AudioManager audioManger = (AudioManager)this.mContext.getSystemService("audio");
        if (audioManger != null && audioManger.getMode() != audioMode) {
            audioManger.setMode(audioMode);
        }
    }

    @Override
    public void enableSubscribeLocalStream(boolean enable) {
        LogUtil.d(TAG, "enableSubscribeLocalStream: " + enable);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableSubscribeLocalStream failed.");
            return;
        }
        NativeFunctions.nativeEnableSubscribeLocalStream(this.mNativeEngine, enable);
    }

    @Override
    public int setVideoCaptureConfig(VideoCaptureConfig videoCaptureConfig) {
        if (videoCaptureConfig == null || this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid or videoCaptureConfig is null, setVideoCaptureConfig failed.");
            return -1;
        }
        LogUtil.d(TAG, "setVideoCaptureConfig: " + videoCaptureConfig.toString());
        InternalVideoCaptureConfig captureConfig = new InternalVideoCaptureConfig(videoCaptureConfig.capturePreference.getValue(), videoCaptureConfig.width, videoCaptureConfig.height, videoCaptureConfig.frameRate);
        return NativeFunctions.nativeSetVideoCaptureConfig(this.mNativeEngine, captureConfig);
    }

    @Override
    public int setVideoEncoderConfig(List<VideoStreamDescription> videoStreamDescriptions) {
        return this.setVideoEncoderConfig(videoStreamDescriptions, VideoEncoderConfiguration.OrientationMode.ORIENTATION_MODE_ADAPTIVE);
    }

    @Override
    public int setVideoEncoderConfig(List<VideoStreamDescription> videoStreamDescriptions, VideoEncoderConfiguration.OrientationMode orientationMode) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoResolutions failed.");
            return -1;
        }
        RTCData.instance().setOrientationMode(orientationMode);
        this.setVideoEncoderConfig(StreamIndex.STREAM_INDEX_MAIN, videoStreamDescriptions);
        return 0;
    }

    @Override
    public int setVideoEncoderConfig(StreamIndex streamIndex, List<VideoStreamDescription> videoStreamDescriptions) {
        if (videoStreamDescriptions == null) {
            videoStreamDescriptions = new ArrayList<VideoStreamDescription>();
        }
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoResolutions failed.");
            return -1;
        }
        ArrayList<InternalVideoStreamDescription> internalVideoStreamDescriptionList = new ArrayList<InternalVideoStreamDescription>();
        for (VideoStreamDescription description : videoStreamDescriptions) {
            if (streamIndex == StreamIndex.STREAM_INDEX_MAIN && !description.isValid()) {
                LogUtil.e(TAG, "setVideoResolutions with illegal params");
                return -2;
            }
            internalVideoStreamDescriptionList.add(new InternalVideoStreamDescription(description));
        }
        NativeFunctions.nativeSetVideoEncoderConfig(this.mNativeEngine, streamIndex.value(), internalVideoStreamDescriptionList);
        return 0;
    }

    @Override
    public int enableSimulcastMode(boolean enabled) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoResolutions failed.");
            return -1;
        }
        NativeFunctions.nativeEnableSimulcastMode(this.mNativeEngine, enabled);
        return 0;
    }

    @Override
    public int setRemoteVideoConfig(String userId, RemoteVideoConfig videoConfig) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoResolutions failed.");
            return -1;
        }
        NativeFunctions.nativeSetRemoteVideoConfig(this.mNativeEngine, userId, videoConfig.getWidth(), videoConfig.getHeight(), videoConfig.getFrameRate());
        return 0;
    }

    @Override
    public int setVideoEncoderConfig(VideoEncoderConfig max_solution) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoResolutions failed.");
            return -1;
        }
        VideoEncoderConfig[] channel_solutions = new VideoEncoderConfig[]{max_solution};
        return this.setVideoEncoderConfig(channel_solutions);
    }

    @Override
    public int setVideoEncoderConfig(VideoEncoderConfig[] channel_solutions) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEncoderConfig failed.");
            return -1;
        }
        if (channel_solutions == null) {
            return -1;
        }
        ArrayList<InternalVideoEncoderConfig> internalVideoEncoderConfigList = new ArrayList<InternalVideoEncoderConfig>();
        for (VideoEncoderConfig config : channel_solutions) {
            if (!config.isValid()) {
                LogUtil.e(TAG, "setVideoEncoderConfig with illegal params");
                return -2;
            }
            internalVideoEncoderConfigList.add(new InternalVideoEncoderConfig(config));
        }
        return NativeFunctions.nativeSetVideoEncoderConfigV2(this.mNativeEngine, internalVideoEncoderConfigList);
    }

    @Override
    public int setScreenVideoEncoderConfig(VideoEncoderConfig screen_solution) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEncoderConfig failed.");
            return -1;
        }
        InternalVideoEncoderConfig internal_screen_solution = new InternalVideoEncoderConfig(screen_solution);
        return NativeFunctions.nativeSetScreenVideoEncoderConfig(this.mNativeEngine, internal_screen_solution);
    }

    @Override
    public void enableAutoSubscribe(SubscribeMode audioMode, SubscribeMode videoMode) {
        LogUtil.d(TAG, "enableAutoSubscribe: audio:" + (Object)((Object)audioMode) + ", video: " + (Object)((Object)videoMode));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableAutoSubscribe failed.");
            return;
        }
        NativeFunctions.nativeEnableAutoSubscribe(this.mNativeEngine, audioMode.value(), videoMode.value());
    }

    @Override
    public void subscribeStream(String userId, SubscribeConfig info) {
        LogUtil.d(TAG, "subscribeStream: " + userId + ", info:" + (info == null ? "null" : info.toString()));
        if (info != null) {
            if (this.engineInvalid()) {
                LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
                return;
            }
            NativeFunctions.nativeSubscribeStream(this.mNativeEngine, userId, info.isScreen, info.subVideo, info.subAudio, info.videoIndex, info.svcLayer.getValue(), info.sub_width, info.sub_height, info.sub_video_index);
        }
    }

    @Override
    public void subscribeUserStream(String uid, StreamIndex streamType, SubscribeMediaType mediaType, SubscribeVideoConfig subscribeVideoConfig) {
        boolean isScreen = streamType == StreamIndex.STREAM_INDEX_SCREEN;
        LogUtil.d(TAG, "subscribeUserStream: " + uid + ", isScreen: " + isScreen + ", mediaType: " + (Object)((Object)mediaType) + ", info: " + (subscribeVideoConfig == null ? "null" : subscribeVideoConfig.toString()));
        if (subscribeVideoConfig != null) {
            if (this.engineInvalid()) {
                LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
                return;
            }
            int media_type = 0;
            switch (mediaType) {
                case RTC_SUBSCRIBE_MEDIA_TYPE_NONE: {
                    media_type = 0;
                    break;
                }
                case RTC_SUBSCRIBE_MEDIA_TYPE_AUDIO_ONLY: {
                    media_type = 1;
                    break;
                }
                case RTC_SUBSCRIBE_MEDIA_TYPE_VIDEO_ONLY: {
                    media_type = 2;
                    break;
                }
                case RTC_SUBSCRIBE_MEDIA_TYPE_AUDIO_AND_VIDEO: {
                    media_type = 3;
                }
            }
            NativeFunctions.nativeSubscribeUserStream(this.mNativeEngine, uid, isScreen, media_type, subscribeVideoConfig.getVideoIndex(), subscribeVideoConfig.getPriority());
        }
    }

    @Override
    public void subscribeStream(String uid, MediaStreamType type) {
        LogUtil.d(TAG, "subscribeStream: " + uid + ", MediaStreamType:" + (Object)((Object)type));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
            return;
        }
        NativeFunctions.nativeSubscribeStreamWithMediaStreamType(this.mNativeEngine, uid, type.value);
    }

    @Override
    public void unsubscribeStream(String uid, MediaStreamType type) {
        LogUtil.d(TAG, "unsubscribeStream: " + uid + ", MediaStreamType:" + (Object)((Object)type));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
            return;
        }
        NativeFunctions.nativeUnsubscribeStreamWithMediaStreamType(this.mNativeEngine, uid, type.value);
    }

    @Override
    public void subscribeScreen(String uid, MediaStreamType type) {
        LogUtil.d(TAG, "subscribeScreen: " + uid + ", MediaStreamType:" + (Object)((Object)type));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, subscribeScreen failed.");
            return;
        }
        NativeFunctions.nativeSubscribeScreenWithMediaStreamType(this.mNativeEngine, uid, type.value);
    }

    @Override
    public void unsubscribeScreen(String uid, MediaStreamType type) {
        LogUtil.d(TAG, "unsubscribeScreen: " + uid + ", MediaStreamType:" + (Object)((Object)type));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, subscribeStream failed.");
            return;
        }
        NativeFunctions.nativeUnsubscribeScreenWithMediaStreamType(this.mNativeEngine, uid, type.value);
    }

    @Override
    public void unSubscribe(String userId, boolean isScreen) {
        LogUtil.d(TAG, "unSubscribe: " + userId);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, unSubscribe failed.");
            return;
        }
        NativeFunctions.nativeUnSubscribe(this.mNativeEngine, userId, isScreen);
    }

    @Override
    public void enableExternalAudioDevice(AudioFormat recordingFormat, AudioFormat playbackFormat) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableExternalAudioDevice failed.");
            return;
        }
        if (recordingFormat.sampleRate == null || recordingFormat.channel == null || playbackFormat.sampleRate == null || playbackFormat.channel == null) {
            LogUtil.e(TAG, "parameter is invalid, EnableExternalAudioDevice failed.");
            return;
        }
        NativeFunctions.nativeEnableExternalAudioDevice(this.mNativeEngine, recordingFormat.sampleRate.value(), recordingFormat.channel.value(), playbackFormat.sampleRate.value(), playbackFormat.channel.value());
    }

    @Override
    public void disableExternalAudioDevice() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, disableExternalAudioDevice failed.");
            return;
        }
        NativeFunctions.nativeDisableExternalAudioDevice(this.mNativeEngine);
    }

    @Override
    public int pushExternalAudioFrame(AudioFrame audioFrame) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, pushExternalAudioFrame failed.");
            return -1;
        }
        boolean ret = NativeFunctions.nativePushExternalAudioFrame(this.mNativeEngine, audioFrame.buffer, audioFrame.samples, audioFrame.sampleRate.value(), audioFrame.channel.value());
        return ret ? 0 : -2;
    }

    @Override
    public int pullExternalAudioFrame(AudioFrame audioFrame) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, pullExternalAudioFrame failed.");
            return -1;
        }
        boolean ret = NativeFunctions.nativePullExternalAudioFrame(this.mNativeEngine, audioFrame.buffer, audioFrame.samples, audioFrame.sampleRate.value(), audioFrame.channel.value());
        return ret ? 0 : -2;
    }

    @Override
    public int setAudioSourceType(AudioSourceType type) {
        LogUtil.d(TAG, "SetAudioSourceType");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetAudioSourceType failed.");
            return -1;
        }
        return NativeFunctions.nativeSetAudioSourceType(this.mNativeEngine, type.value());
    }

    @Override
    public int setAudioRenderType(AudioRenderType type) {
        LogUtil.d(TAG, "SetAudioRenderType");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetAudioRenderType failed.");
            return -1;
        }
        return NativeFunctions.nativeSetAudioRenderType(this.mNativeEngine, type.value());
    }

    @Override
    public boolean pushExternalVideoFrame(VideoFrame frame) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "pushExternalVideoFrame: native engine is invalid, pushExternalVideoFrame failed.");
            return false;
        }
        if (frame == null) {
            LogUtil.i(TAG, "pushExternalVideoFrame: videoFrame is null, drop frame.");
            return false;
        }
        if (!this.mUseExtVideoSource) {
            LogUtil.i(TAG, "pushExternalVideoFrame: not enable external video source, drop frame.");
            return false;
        }
        if (frame.getFrameType() == VideoFrameType.kVideoFrameTypeRawMemory || frame.hasReleaseCallback()) {
            NativeFunctions.nativePushExternalByteRtcVideoFrame(this.mNativeEngine, frame);
        } else {
            CountDownLatch pushExternalVideoFrameLatch = new CountDownLatch(1);
            frame.retain();
            VideoFrame syncFrame = new GLTextureVideoFrameBuilder(frame.getPixelFormat()).setTextureID(frame.getTextureID()).setTextureMatrix(frame.getTextureMatrix()).setEGLContext(frame.getEGLContext()).setColorSpace(frame.getColorSpace()).setWidth(frame.getWidth()).setHeight(frame.getHeight()).setRotation(frame.getRotation()).setExternalDataInfo(frame.getExternalDataInfo()).setSupplementaryInfo(frame.getSupplementaryInfo()).setTimeStampUs(frame.getTimeStampUs()).setReleaseCallback(() -> {
                frame.release();
                pushExternalVideoFrameLatch.countDown();
            }).build();
            NativeFunctions.nativePushExternalByteRtcVideoFrame(this.mNativeEngine, syncFrame);
            syncFrame.release();
            ThreadUtils.awaitUninterruptibly(pushExternalVideoFrameLatch);
        }
        return true;
    }

    @Override
    public boolean pushExternalVideoFrame(VideoFrame frame, boolean directEncode) {
        return this.pushExternalVideoFrame(frame);
    }

    @Override
    public int publishScreen() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, publishScreen failed.");
            return -1;
        }
        return NativeFunctions.nativePublishScreen(this.mNativeEngine);
    }

    @Override
    public int publishScreen(MediaStreamType type) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, publishScreen failed.");
            return -1;
        }
        return NativeFunctions.nativePublishScreenWithMediaStreamType(this.mNativeEngine, type.value);
    }

    @Override
    public int unpublishScreen() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, unpublishScreen failed.");
            return -1;
        }
        return NativeFunctions.nativeUnpublishScreen(this.mNativeEngine);
    }

    @Override
    public int unpublishScreen(MediaStreamType type) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, publishScreen failed.");
            return -1;
        }
        return NativeFunctions.nativeUnpublishScreenWithMediaStreamType(this.mNativeEngine, type.value);
    }

    @Override
    public boolean pushScreenFrame(VideoFrame frame) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, pushExternalVideoFrame failed.");
            return false;
        }
        if (frame == null) {
            LogUtil.i(TAG, "videoFrame is null, drop frame.");
            return false;
        }
        frame.retain();
        boolean ret = false;
        if (frame.getFrameType() == VideoFrameType.kVideoFrameTypeRawMemory) {
            ret = NativeFunctions.nativePushScreenByteRtcFrame(this.mNativeEngine, frame);
        } else if (frame.getFrameType() == VideoFrameType.kVideoFrameTypeGLTexture) {
            if (this.mScreenFrameConverter == null) {
                frame.release();
                return false;
            }
            org.webrtc.VideoFrame videoFrame = this.mScreenFrameConverter.convert2WebrtcI420Frame(frame);
            if (videoFrame == null) {
                LogUtil.e(TAG, "pushExternalVideoFrame failed because no converted webrtcVideoFrame is null");
                frame.release();
                return false;
            }
            ret = NativeFunctions.nativePushScreenFrame(this.mNativeEngine, videoFrame);
            videoFrame.release();
        }
        frame.release();
        return ret;
    }

    @Override
    public int startScreenSharing(Intent mediaProjectionPermissionResultData, ScreenSharingParameters parameters) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startScreenSharing failed.");
            return -1;
        }
        InternalScreenSharingParams internalScreenSharingParams = new InternalScreenSharingParams(parameters);
        return NativeFunctions.nativeStartScreenSharing(this.mNativeEngine, mediaProjectionPermissionResultData, internalScreenSharingParams);
    }

    @Override
    public int updateScreenSharingParameters(ScreenSharingParameters parameters) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, updateScreenSharingParameters failed.");
            return -1;
        }
        InternalScreenSharingParams internalScreenSharingParams = new InternalScreenSharingParams(parameters);
        return NativeFunctions.nativeUpdateScreenSharingParameters(this.mNativeEngine, internalScreenSharingParams);
    }

    @Override
    public int startScreenVideoCapture(Intent mediaProjectionResultData) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startScreenVideoCapture failed.");
            return -1;
        }
        return NativeFunctions.nativeStartScreenVideoCapture(this.mNativeEngine, mediaProjectionResultData);
    }

    @Override
    public int stopScreenSharing() {
        return this.stopScreenVideoCapture();
    }

    @Override
    public int stopScreenVideoCapture() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopScreenCapture failed.");
            return -1;
        }
        return NativeFunctions.nativeStopScreenVideoCapture(this.mNativeEngine);
    }

    @Override
    public void setOnDestroyCompletedCallback(Runnable callback) {
        this.mOnDestroyCompletedCallback = callback;
    }

    @Override
    public NetworkDetectionStartReturn startNetworkDetection(boolean uplink, int uplinkBandwidth, boolean downlink, int downlinkBandwidth) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendCustomMessage failed.");
            return NetworkDetectionStartReturn.values()[-1];
        }
        return NetworkDetectionStartReturn.values()[NativeFunctions.nativeStartNetworkProbe(this.mNativeEngine, uplink, uplinkBandwidth, downlink, downlinkBandwidth)];
    }

    @Override
    public void stopNetworkDetection() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendCustomMessage failed.");
        }
        NativeFunctions.nativeStopNetworkProbe(this.mNativeEngine);
    }

    @Override
    public long sendRoomMessage(String message) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendCustomMessage failed.");
            return -1L;
        }
        return NativeFunctions.nativeSendRoomMessage(this.mNativeEngine, message);
    }

    @Override
    public long sendRoomBinaryMessage(byte[] buffer) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendCustomMessage failed.");
            return -1L;
        }
        return NativeFunctions.nativeSendRoomBinaryMessage(this.mNativeEngine, buffer);
    }

    @Override
    public long sendUserMessage(@NonNull String uid, String message, MessageConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendMessage failed.");
            return -1L;
        }
        if (uid == null) {
            LogUtil.e(TAG, "sendMessage: uid is null send failed");
            return -2L;
        }
        return NativeFunctions.nativeSendUserMessage(this.mNativeEngine, uid, message, config.value());
    }

    @Override
    public long sendUserBinaryMessage(@NonNull String uid, byte[] buffer, MessageConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -1L;
        }
        if (uid == null) {
            LogUtil.e(TAG, "sendBinaryMessage: uid is null send failed");
            return -2L;
        }
        return NativeFunctions.nativeSendUserBinaryMessage(this.mNativeEngine, uid, buffer, config.value());
    }

    @Override
    public long login(String token, String uid) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -3L;
        }
        return NativeFunctions.nativeLogin(this.mNativeEngine, token, uid);
    }

    @Override
    public void logout() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return;
        }
        NativeFunctions.nativeLogout(this.mNativeEngine);
    }

    @Override
    public void updateLoginToken(String token) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return;
        }
        NativeFunctions.nativeUpdateLoginToken(this.mNativeEngine, token);
    }

    @Override
    public void setServerParams(String signature, String url) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return;
        }
        NativeFunctions.nativeSetServerParams(this.mNativeEngine, signature, url);
    }

    @Override
    public void getPeerOnlineStatus(String peer_user_id) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return;
        }
        NativeFunctions.nativeGetPeerOnlineStatus(this.mNativeEngine, peer_user_id);
    }

    @Override
    public long sendUserMessageOutsideRoom(String uid, String message, MessageConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -1L;
        }
        if (uid == null) {
            LogUtil.e(TAG, "sendUserMessageOutsideRoom: uid is null send failed");
            return -2L;
        }
        return NativeFunctions.nativeSendUserMessageOutsideRoom(this.mNativeEngine, uid, message, config.value());
    }

    @Override
    public long sendUserBinaryMessageOutsideRoom(String uid, byte[] buffer, MessageConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -1L;
        }
        if (uid == null) {
            LogUtil.e(TAG, "sendUserBinaryMessageOutsideRoom: uid is null send failed");
            return -2L;
        }
        return NativeFunctions.nativeSendUserBinaryMessageOutsideRoom(this.mNativeEngine, uid, buffer, config.value());
    }

    @Override
    public long sendServerMessage(String message) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -1L;
        }
        return NativeFunctions.nativeSendServerMessage(this.mNativeEngine, message);
    }

    @Override
    public long sendServerBinaryMessage(byte[] buffer) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -1L;
        }
        return NativeFunctions.nativeSendServerBinaryMessage(this.mNativeEngine, buffer);
    }

    @Override
    public int setMultiDeviceAVSync(String audioUserId) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setMultiDeviceAVSync failed.");
            return -1;
        }
        return NativeFunctions.nativeSetMultiDeviceAVSync(this.mNativeEngine, audioUserId);
    }

    @Override
    public void setAudioPlayoutMixStream(boolean enable, int sampleRate, int channelNum) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioPlayoutMixStream failed.");
            return;
        }
        NativeFunctions.nativeSetAudioPlayoutMixStream(this.mNativeEngine, enable, sampleRate, channelNum);
    }

    @Override
    public int getAudioMixingStreamCachedFrameNum() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getAudioMixingStreamCachedFrameNum failed.");
            return -1;
        }
        return NativeFunctions.nativeGetAudioMixingStreamCachedFrameNum(this.mNativeEngine);
    }

    @Override
    public boolean pushAudioMixingStreamData(byte[] audioFrame, int frameNum) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, pushAudioMixingStreamData failed.");
            return false;
        }
        return NativeFunctions.nativePushAudioMixingStreamData(this.mNativeEngine, audioFrame, frameNum);
    }

    @Override
    public void setRemoteAudioPlaybackVolume(@NonNull String uid, int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setRemoteAudioPlaybackVolume failed.");
            return;
        }
        if (uid == null) {
            LogUtil.e(TAG, "setRemoteAudioPlaybackVolume: uid is null adjust failed");
            return;
        }
        NativeFunctions.nativeSetRemoteAudioPlaybackVolume(this.mNativeEngine, uid, volume);
    }

    public static void setRtcHttpClient(RTCHttpClient client) {
        if (mLibraryLoaded) {
            nativeHttpClient = client;
            NativeFunctions.nativeSetUpperHttpClient(true);
        }
    }

    public EglBase getEGLContext() {
        if (this.mRootEglBase != null) {
            return this.mRootEglBase;
        }
        return null;
    }

    @CalledByNative
    public static void httpGetAsync(String url, int timeoutMillisecond, int callbackId, int clientId) {
        if (nativeHttpClient == null) {
            Log.d((String)"bytertc", (String)"native http client has not been init!");
            return;
        }
        RtcHttpCallbackImpl callback = new RtcHttpCallbackImpl();
        callback.setCallbackId(callbackId);
        callback.setClientId(clientId);
        nativeHttpClient.GetAsync(url, callback, timeoutMillisecond);
    }

    @CalledByNative
    public static void httpPostAsync(String url, String content, int timeoutMillisecond, int callbackId, int clientId) {
        if (nativeHttpClient == null) {
            Log.d((String)"bytertc", (String)"native http client has not been init!");
            return;
        }
        Log.d((String)"bytertc", (String)("http in java called, callback Id: " + callbackId));
        RtcHttpCallbackImpl callback = new RtcHttpCallbackImpl();
        callback.setCallbackId(callbackId);
        callback.setClientId(clientId);
        nativeHttpClient.PostAsync(url, content, callback, timeoutMillisecond);
    }

    @CalledByNative
    public static String getRtcPackageName() {
        if (mPackageName != null) {
            return mPackageName;
        }
        return "";
    }

    private static void loadSoFile() {
        if (mLibraryLoaded) {
            mRtcNativeLibraryListener.onLoadAlready(sSoLibraryName);
        } else {
            if (mRtcNativeLibraryLoader != null) {
                mLibraryLoaded = true;
                mLibraryLoaded &= mRtcNativeLibraryLoader.load("byteaudio");
                if (mLibraryLoaded &= mRtcNativeLibraryLoader.load(sSoLibraryName)) {
                    mRtcNativeLibraryListener.onLoadSuccess(sSoLibraryName);
                } else {
                    mRtcNativeLibraryListener.onLoadError(sSoLibraryName);
                }
                sRtcLoaderInfo.setLoaderClassName(mRtcNativeLibraryLoader.getClass().getSimpleName());
            } else {
                try {
                    System.loadLibrary("byteaudio");
                    System.loadLibrary(sSoLibraryName);
                    mLibraryLoaded = true;
                    mRtcNativeLibraryListener.onLoadSuccess(sSoLibraryName);
                    sRtcLoaderInfo.setLoaderClassName("System.loader");
                }
                catch (UnsatisfiedLinkError e) {
                    LogUtil.e(TAG, "Failed to load native library: volcenginertc", e);
                }
                mRtcNativeLibraryListener.onLoadError(sSoLibraryName);
            }
            sRtcLoaderInfo.setLoadResult(mLibraryLoaded);
            sRtcLoaderInfo.setLoadTimeStamp(System.currentTimeMillis());
            sRtcLoaderInfo.setSdkVersion(RTCEngine.getSdkVersion());
        }
        sRtcLoaderInfo.loadLibrary();
    }

    private void initEglContext(Object eglContext) {
        if (eglContext == null) {
            this.mRootEglBase = EglBase.create();
            this.mIsUseCustomEglEnv = false;
            return;
        }
        this.mRootEglBase = eglContext instanceof javax.microedition.khronos.egl.EGLContext ? EglBase.createEgl10((javax.microedition.khronos.egl.EGLContext)eglContext, EglBase.CONFIG_PLAIN) : (eglContext instanceof EGLContext ? EglBase.createEgl14((EGLContext)eglContext, EglBase.CONFIG_PLAIN) : (eglContext instanceof EglBase ? EglBase.create(((EglBase)eglContext).getEglBaseContext(), EglBase.CONFIG_PLAIN) : EglBase.create()));
        this.mIsUseCustomEglEnv = true;
    }

    @Override
    public int SetRtcMode(RtcMode mode) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetRtcMode failed.");
            return -1;
        }
        return NativeFunctions.nativeSetRtcMode(this.mNativeEngine, mode.value());
    }

    @Override
    public int SetAudioSendMode(RangeAudioMode rangeAudioMode) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetAudioSendMode failed.");
            return -1;
        }
        return NativeFunctions.nativeSetAudioSendMode(this.mNativeEngine, rangeAudioMode.value());
    }

    @Override
    public int SetAudioRecvMode(RangeAudioMode rangeAudioMode) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetAudioRecvMode failed.");
            return -1;
        }
        return NativeFunctions.nativeSetAudioRecvMode(this.mNativeEngine, rangeAudioMode.value());
    }

    @Override
    public int SetTeamId(String teamId) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetTeamId failed.");
            return -1;
        }
        return NativeFunctions.nativeSetTeamId(this.mNativeEngine, teamId);
    }

    @Override
    public int UpdateAudioRecvRange(int minRange, int maxRange) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, UpdateAudioRecvRange failed.");
            return -1;
        }
        return NativeFunctions.nativeUpdateAudioRecvRange(this.mNativeEngine, minRange, maxRange);
    }

    @Override
    public int UpdateSelfPosition(int x, int y, int z) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, UpdateSelfPosition failed.");
            return -1;
        }
        return NativeFunctions.nativeUpdateSelfPosition(this.mNativeEngine, x, y, z);
    }

    @Override
    public int EnableRangeAudio(boolean enable) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, EnableRangeAudio failed.");
            return -1;
        }
        return NativeFunctions.nativeEnableRangeAudio(this.mNativeEngine, enable);
    }

    @Override
    public int setPublishFallbackOption(PublishFallbackOption option) {
        LogUtil.d(TAG, "setPublishFallbackOption: option: " + (Object)((Object)option));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setPublishFallbackOption failed.");
            return -1;
        }
        NativeFunctions.nativeSetPublishFallbackOption(this.mNativeEngine, option.value());
        return 0;
    }

    @Override
    public int setSubscribeFallbackOption(SubscribeFallbackOptions option) {
        LogUtil.d(TAG, "setRemoteSubscribeFallbackOption: option: " + (Object)((Object)option));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setRemoteSubscribeFallbackOption failed.");
            return -1;
        }
        NativeFunctions.nativeSetRemoteSubscribeFallbackOption(this.mNativeEngine, option.value());
        return 0;
    }

    @Override
    public int setRemoteUserPriority(@NonNull String uid, RemoteUserPriority priority) {
        LogUtil.d(TAG, "setRemoteUserPriority: uid: " + uid + ", priority: " + (Object)((Object)priority));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setRemoteUserPriority failed.");
            return -1;
        }
        if (uid == null) {
            LogUtil.e(TAG, "setRemoteUserPriority: uid is null set failed");
            return -2;
        }
        NativeFunctions.nativeSetRemoteUserPriority(this.mNativeEngine, uid, priority.value());
        return 0;
    }

    public IMetadataObserver getMetadataObserver() {
        return (IMetadataObserver)this.mMetadataObserver.get();
    }

    public ILiveTranscodingObserver getLiveTranscodingObserver() {
        return this.mLiveTranscodingObserver;
    }

    @Override
    public void registerMetadataObserver(IMetadataObserver observer) {
        this.mMetadataObserver = new WeakReference<IMetadataObserver>(observer);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerMetadataObserver failed.");
            return;
        }
        if (observer == null) {
            NativeFunctions.nativeSetMetadataObserver(this.mNativeEngine, null);
        } else {
            NativeFunctions.nativeSetMetadataObserver(this.mNativeEngine, this.mRtcMetadataObserver);
        }
    }

    @Override
    public int sendSEIMessage(StreamIndex streamIndex, byte[] message, int repeatCount) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerMetadataObserver failed.");
            return -1;
        }
        return NativeFunctions.nativeSendSEIMessage(this.mNativeEngine, streamIndex.value(), message, repeatCount);
    }

    @Override
    public int setBusinessId(String businessId) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setBusinessId failed.");
            return -1;
        }
        return NativeFunctions.nativeSetBusinessId(this.mNativeEngine, businessId);
    }

    @Override
    public void setEncryptInfo(int aesType, String key) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setEncryptInfo failed.");
            return;
        }
        NativeFunctions.nativeSetEncryptInfo(this.mNativeEngine, aesType, key);
    }

    @Override
    public void setCustomizeEncryptHandler(RTCEncryptHandler handler) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setCustomizeEncryptHandler failed.");
            return;
        }
        NativeFunctions.nativeSetCustomizeEncryptHandler(this.mNativeEngine, handler);
    }

    @Override
    public int setVideoEffectColorFilter(String resFile) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectColorFilter failed.");
            return 1000;
        }
        return NativeFunctions.nativeSetVideoEffectColorFilter(this.mNativeEngine, resFile);
    }

    @Override
    public int setVideoEffectColorFilterIntensity(float intensity) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectColorFilterIntensity failed.");
            return 1000;
        }
        return NativeFunctions.nativeSetVideoEffectColorFilterIntensity(this.mNativeEngine, intensity);
    }

    @Override
    public int checkVideoEffectLicense(Context context, String licenseFile) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, checkVideoEffectLicense failed.");
            return -1;
        }
        return NativeFunctions.nativeCheckVideoEffectLicense(context, this.mNativeEngine, licenseFile);
    }

    @Override
    public int initVirtualBackground(Context context, String licenseFile, String modelFile) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, initVirtualBackground failed.");
            return -1;
        }
        return NativeFunctions.nativeInitVirtualBackground(context, this.mNativeEngine, licenseFile, modelFile);
    }

    @Override
    public int enableVirtualBackground(VirtualBackgroundSource source) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableVirtualBackground failed.");
            return -1;
        }
        if (source == null) {
            LogUtil.e(TAG, "virtualBackgroundSource is invalid.");
            return -1;
        }
        if (source.sourcePath == null) {
            source.sourcePath = "";
        }
        return NativeFunctions.nativeEnableVirtualBackground(this.mNativeEngine, source.sourceType.ordinal(), source.sourceColor, source.sourcePath);
    }

    @Override
    public int disableVirtualBackground() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, disableVirtualBackground failed.");
            return -1;
        }
        return NativeFunctions.nativeDisableVirtualBackground(this.mNativeEngine);
    }

    @Override
    public void setVideoEffectAlgoModelPath(String modelPath) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectAlgoModelPath failed.");
            return;
        }
        NativeFunctions.nativeSetVideoEffectAlgoModelPath(this.mNativeEngine, modelPath);
    }

    @Override
    public int setVideoEffectAlgoModelResourceFinder(long finder, long deleter) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectAlgoModelResourceFinder failed.");
            return 1000;
        }
        return NativeFunctions.nativeSetVideoEffectAlgoModelResourceFinder(this.mNativeEngine, finder, deleter);
    }

    @Override
    public int setVideoEffectExpressionDetect(VideoEffectExpressionConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectExpressionDetect failed.");
            return 1000;
        }
        InternalExpressDetectConfig internalConfig = new InternalExpressDetectConfig(config);
        return NativeFunctions.nativeSetVideoEffectExpressionDetect(this.mNativeEngine, internalConfig);
    }

    @Override
    public int enableVideoEffect(boolean enable) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableVideoEffect failed.");
            return 1000;
        }
        return NativeFunctions.nativeEnableVideoEffect(this.mNativeEngine, enable);
    }

    @Override
    public int setVideoEffectNodes(List<String> effectPath) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectPath failed.");
            return 1000;
        }
        String[] strArray = new String[effectPath.size()];
        effectPath.toArray(strArray);
        return NativeFunctions.nativeSetVideoEffectNodes(this.mNativeEngine, strArray);
    }

    @Override
    public int appendVideoEffectNodes(List<String> effectPath) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, appendVideoEffectNodes failed.");
            return 1000;
        }
        String[] strArray = new String[effectPath.size()];
        effectPath.toArray(strArray);
        return NativeFunctions.nativeAppendVideoEffectNodes(this.mNativeEngine, strArray);
    }

    @Override
    public int removeVideoEffectNodes(List<String> effectPath) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, removeVideoEffectNodes failed.");
            return 1000;
        }
        String[] strArray = new String[effectPath.size()];
        effectPath.toArray(strArray);
        return NativeFunctions.nativeRemoveVideoEffectNodes(this.mNativeEngine, strArray);
    }

    @Override
    public int updateVideoEffectNode(String effectNode, String key, float value) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, updateVideoEffect failed.");
            return 1000;
        }
        return NativeFunctions.nativeUpdateVideoEffectNode(this.mNativeEngine, effectNode, key, value);
    }

    @Override
    public int enableEffectBeauty(boolean enable) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableEffectBeauty failed.");
            return 1000;
        }
        return NativeFunctions.nativeEnableEffectBeauty(this.mNativeEngine, enable);
    }

    @Override
    public int setBeautyIntensity(EffectBeautyMode beautyMode, float intensity) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setBeautyIntensity failed.");
            return 1000;
        }
        return NativeFunctions.nativeSetBeautyIntensity(this.mNativeEngine, beautyMode.value(), intensity);
    }

    @Override
    public void setVideoOrientation(VideoOrientation orientation) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoOrientation failed.");
            return;
        }
        NativeFunctions.nativeSetVideoOrientation(this.mNativeEngine, orientation.value());
    }

    @Override
    public void startCloudRendering(String effectInfo) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startCloudRendering failed.");
            return;
        }
        String renderInfo = RTCEngineImpl.getCloudRenderingInfo("started", effectInfo);
        if (renderInfo == null) {
            return;
        }
        NativeFunctions.nativeUpdateCloudRending(this.mNativeEngine, renderInfo);
    }

    @Override
    public void updateCloudRendering(String effectInfo) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, updateCloudRendering failed.");
            return;
        }
        String renderInfo = RTCEngineImpl.getCloudRenderingInfo("changed", effectInfo);
        if (renderInfo == null) {
            return;
        }
        NativeFunctions.nativeUpdateCloudRending(this.mNativeEngine, renderInfo);
    }

    @Override
    public void stopCloudRendering() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopCloudRendering failed.");
            return;
        }
        String renderInfo = RTCEngineImpl.getCloudRenderingInfo("stopped", "");
        if (renderInfo == null) {
            return;
        }
        NativeFunctions.nativeUpdateCloudRending(this.mNativeEngine, renderInfo);
    }

    public static String getCloudRenderingInfo(String action, String effectInfo) {
        JSONObject renderJson = new JSONObject();
        try {
            renderJson.put("action", (Object)action);
            renderJson.put("externalService", (Object)"render");
            renderJson.put("renderMeta", (Object)effectInfo);
        }
        catch (Exception e) {
            LogUtil.e(TAG, "getCloudRenderingInfo catch exception , e : " + e.getMessage());
            return null;
        }
        return renderJson.toString();
    }

    public static IRTCAudioDeviceManagerEx.IRTCAudioDeviceEventHandler getAudioDeviceManagerEvent() {
        return (IRTCAudioDeviceManagerEx.IRTCAudioDeviceEventHandler)mAudioDeviceManagerEventHandler.get();
    }

    public static IRTCAudioDeviceManagerEx createAudioDeviceManager(IRTCAudioDeviceManagerEx.IRTCAudioDeviceEventHandler handler) {
        mAudioDeviceManagerEventHandler = new WeakReference<IRTCAudioDeviceManagerEx.IRTCAudioDeviceEventHandler>(handler);
        if (mAudioDeviceManager != null) {
            return mAudioDeviceManager;
        }
        mRTCAudioDeviceManagerEventHandler = new RTCAudioDeviceEventHandler();
        mAudioDeviceManager = new RTCAudioDeviceManagerEx(mRTCAudioDeviceManagerEventHandler);
        return mAudioDeviceManager;
    }

    @Override
    public void setRuntimeParameters(JSONObject params) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetRuntimeParameters failed.");
            return;
        }
        NativeFunctions.nativeSetRuntimeParameters(this.mNativeEngine, params == null ? "" : params.toString());
    }

    @Override
    public int feedback(List<ProblemFeedback> types, String problemDesc) {
        if (!mLibraryLoaded) {
            RTCEngineImpl.loadSoFile();
        }
        int[] typeArray = new int[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            typeArray[i] = types.get((int)i).value;
        }
        return NativeFunctions.nativeReportFeedback(this.mNativeEngine, typeArray, problemDesc);
    }

    public VideoSinkTask getVideoSinkTask() {
        return this.mVideoSinkTask;
    }

    @Override
    public void startASR(RTCASRConfig asrConfig, IRTCASREngineEventHandler handler) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startASR");
            return;
        }
        if (handler == null || asrConfig == null) {
            return;
        }
        String uid = asrConfig.userId == null ? "" : asrConfig.userId;
        String appId = asrConfig.appId == null ? "" : asrConfig.appId;
        String token = asrConfig.accessToken == null ? "" : asrConfig.accessToken;
        String secret = asrConfig.secretKey == null ? "" : asrConfig.secretKey;
        int authType = asrConfig.authorizationType.value();
        String cluster = asrConfig.cluster == null ? "" : asrConfig.cluster;
        this.mRTCASREngineEventHandler.setAsrEventHandler(handler);
        NativeFunctions.nativeStartASR(this.mNativeEngine, this.mRTCASREngineEventHandler, uid, appId, token, secret, authType, cluster);
    }

    @Override
    public void stopASR() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopASR");
            return;
        }
        NativeFunctions.nativeStopASR(this.mNativeEngine);
    }

    @Override
    public int startFileRecording(StreamIndex type, RecordingConfig config, RecordingType recordingType) {
        LogUtil.d(TAG, "startFileRecording");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startFileRecording failed.");
            return -1;
        }
        return NativeFunctions.nativeStartFileRecording(this.mNativeEngine, type.value(), config.dirPath, config.recordingFileType.value(), recordingType.value());
    }

    @Override
    public void stopFileRecording(StreamIndex type) {
        LogUtil.d(TAG, "stopFileRecording");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopFileRecording failed.");
            return;
        }
        NativeFunctions.nativeStopFileRecording(this.mNativeEngine, type.value());
    }

    @Override
    public IAudioMixingManager getAudioMixingManager() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getAudioMixingManager");
            return null;
        }
        if (this.mAudioMixingManager != null) {
            return this.mAudioMixingManager;
        }
        long nativeAudioMixingManager = NativeFunctions.nativeGetAudioMixingManager(this.mNativeEngine);
        if (nativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "getAudioMixingManager failed");
            return null;
        }
        this.mAudioMixingManager = new AudioMixingManager(nativeAudioMixingManager);
        return this.mAudioMixingManager;
    }

    @Override
    public void setScreenAudioSourceType(AudioSourceType sourceType) {
        LogUtil.d(TAG, "SetScreenAudioSourceType");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetScreenAudioSourceType failed.");
            return;
        }
        NativeFunctions.nativeSetScreenAudioSourceType(this.mNativeEngine, sourceType.value());
    }

    @Override
    public void setScreenAudioStreamIndex(StreamIndex index) {
        LogUtil.d(TAG, "SetScreenAudioStreamIndex");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetScreenAudioStreamIndex failed.");
            return;
        }
        NativeFunctions.nativeSetScreenAudioStreamIndex(this.mNativeEngine, index.value());
    }

    @Override
    public void startScreenAudioCapture() {
        LogUtil.d(TAG, "StartScreenAudioCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, StartScreenAudioCapture failed.");
            return;
        }
        NativeFunctions.nativeStartScreenAudioCapture(this.mNativeEngine);
    }

    @Override
    public void stopScreenAudioCapture() {
        LogUtil.d(TAG, "StopScreenAudioCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, StopScreenAudioCapture failed.");
            return;
        }
        NativeFunctions.nativeStopScreenAudioCapture(this.mNativeEngine);
    }

    @Override
    public void startScreenCapture(ScreenMediaType type, Intent mediaProjectionResultData) {
        LogUtil.d(TAG, "StartScreenAudioCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, StopScreenAudioCapture failed.");
            return;
        }
        NativeFunctions.nativeStartScreenCapture(this.mNativeEngine, type.value(), mediaProjectionResultData);
    }

    @Override
    public void updateScreenCapture(ScreenMediaType type) {
        LogUtil.d(TAG, "UpdateScreenCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, StopScreenAudioCapture failed.");
            return;
        }
        NativeFunctions.nativeUpdateScreenCapture(this.mNativeEngine, type.value());
    }

    @Override
    public void stopScreenCapture() {
        LogUtil.d(TAG, "StopScreenCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, StopScreenAudioCapture failed.");
            return;
        }
        NativeFunctions.nativeStopScreenCapture(this.mNativeEngine);
    }

    @Override
    public void setCaptureVolume(StreamIndex index, int volume) {
        LogUtil.d(TAG, "setCaptureVolume");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setCaptureVolume failed.");
            return;
        }
        NativeFunctions.nativeSetCaptureVolume(this.mNativeEngine, volume, index.value());
    }

    @Override
    public int pushScreenAudioFrame(AudioFrame audioFrame) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return -1;
        }
        int ret = NativeFunctions.nativePushScreenAudioFrame(this.mNativeEngine, audioFrame.buffer, audioFrame.samples, audioFrame.sampleRate.value(), audioFrame.channel.value());
        return ret;
    }

    public IExternalVideoEncoderEventHandler getExternalVideoEncoderEventHandler() {
        return (IExternalVideoEncoderEventHandler)this.mExternalVideoEncoderHandler.get();
    }

    @Override
    public void setExternalVideoEncoderEventHandler(IExternalVideoEncoderEventHandler encoder_handler) {
        this.mExternalVideoEncoderHandler = new WeakReference<IExternalVideoEncoderEventHandler>(encoder_handler);
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setExternalVideoEncoderEventHandler failed.");
            return;
        }
        if (encoder_handler == null) {
            NativeFunctions.nativeSetExternalVideoEncoderEventHandler(this.mNativeEngine, null);
        } else {
            NativeFunctions.nativeSetExternalVideoEncoderEventHandler(this.mNativeEngine, this.mRtcExVideoEncoderHandler);
        }
    }

    @Override
    public boolean pushExternalEncodedVideoFrame(StreamIndex index, int video_index, RTCEncodedVideoFrame video_stream) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, PushExternalEncodedVideoFrame failed.");
            return false;
        }
        return NativeFunctions.nativePushExternalEncodedVideoFrame(this.mNativeEngine, index.value(), video_index, video_stream.buffer, video_stream.timestampUs, video_stream.timestampDtsUs, video_stream.width, video_stream.height, video_stream.videoCodecType.value(), video_stream.videoPictureType.value(), video_stream.videoRotation.value());
    }

    @Override
    public void setVideoDecoderConfig(RemoteStreamKey key, VideoDecoderConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetVideoDecoderConfig failed.");
            return;
        }
        NativeFunctions.nativeSetVideoDecoderConfig(this.mNativeEngine, key.getRoomId(), key.getUserId(), key.getStreamIndex().value(), config.value());
    }

    @Override
    public void requestRemoteVideoKeyFrame(RemoteStreamKey stream_info) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, RequestRemoteVideoKeyFrame failed.");
            return;
        }
        NativeFunctions.nativeRequestRemoteVideoKeyFrame(this.mNativeEngine, stream_info.getRoomId(), stream_info.getUserId(), stream_info.getStreamIndex().value());
    }

    @Override
    public void setEarMonitorMode(EarMonitorMode mode) {
        LogUtil.d(TAG, "setEarMonitorMode");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setEarMonitorMode failed.");
            return;
        }
        NativeFunctions.nativeSetEarMonitorMode(this.mNativeEngine, mode.value());
    }

    @Override
    public void setEarMonitorVolume(int volume) {
        LogUtil.d(TAG, "setEarMonitorVolume");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setEarMonitorVolume failed.");
            return;
        }
        NativeFunctions.nativeSetEarMonitorVolume(this.mNativeEngine, volume);
    }

    @Override
    public void enableAudioPropertiesReport(AudioPropertiesConfig config) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, EnableAudioPropertiesReport failed.");
            return;
        }
        NativeFunctions.nativeEnableAudioPropertiesReport(this.mNativeEngine, config.interval, config.enable_spectrum, config.enable_vad, config.local_main_report_mode.value(), config.audio_report_mode.value());
    }

    @Override
    public int sendStreamSyncInfo(byte[] data, StreamSycnInfoConfig config) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, SendStreamSyncInfo failed.");
            return -1;
        }
        return NativeFunctions.nativeSendStreamSyncInfo(this.mNativeEngine, data, config.streamIndex.value(), config.repeatCount, 0);
    }

    @Override
    public int startPushPublicStream(String publicStreamId, PublicStreaming publicStreaming) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, startPushPublicStream failed.");
            return -1;
        }
        if (publicStreaming == null) {
            LogUtil.e(TAG, "startPushPublicStream failed for publicStreaming is null.");
            return -1;
        }
        this.mPublicStreaming = publicStreaming;
        this.mPublicStreaming.setRoomId(this.mRoom);
        this.mPublicStreaming.setAction("started");
        JSONObject jsonObject = this.mPublicStreaming.getPublicStreamMessage();
        if (jsonObject == null) {
            LogUtil.e(TAG, "public stream parameter is invalid, startPushPublicStream failed.");
            return -1;
        }
        String message = jsonObject.toString();
        LogUtil.d(TAG, "startPushPublicStream...public stream parameter: " + message);
        return NativeFunctions.nativeStartPushPublicStream(this.mNativeEngine, publicStreamId, message);
    }

    @Override
    public int stopPushPublicStream(String publicStreamId) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, stopPushPublicStream failed.");
            return -1;
        }
        if (this.mPublicStreaming == null) {
            LogUtil.e(TAG, "stopPushPublicStream failed for publicStreaming is null.");
            return -1;
        }
        this.mPublicStreaming.setAction("stopped");
        return NativeFunctions.nativeStopPushPublicStream(this.mNativeEngine, publicStreamId);
    }

    @Override
    public int updatePublicStreamParam(String publicStreamId, PublicStreaming publicStreaming) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, updatePublicStreamParam failed.");
            return -1;
        }
        if (publicStreaming == null) {
            LogUtil.e(TAG, "updatePublicStreamParam failed for publicStreaming is null.");
            return -1;
        }
        this.mPublicStreaming = publicStreaming;
        this.mPublicStreaming.setRoomId(this.mRoom);
        this.mPublicStreaming.setAction("layoutChanged");
        JSONObject jsonObject = this.mPublicStreaming.getPublicStreamMessage();
        if (jsonObject == null) {
            LogUtil.e(TAG, "public stream parameter is invalid, updatePublicStreamParam failed.");
            return -1;
        }
        String message = jsonObject.toString();
        LogUtil.d(TAG, "updatePublicStreamParam...public stream parameter: " + message);
        return NativeFunctions.nativeUpdatePublicStreamParam(this.mNativeEngine, publicStreamId, message);
    }

    @Override
    public int startPlayPublicStream(String publicStreamId) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, startPlayPublicStream failed.");
            return -1;
        }
        LogUtil.d(TAG, "startPlayPublicStream...public stream id: " + publicStreamId);
        return NativeFunctions.nativeStartPlayPublicStream(this.mNativeEngine, publicStreamId);
    }

    @Override
    public int stopPlayPublicStream(String publicStreamId) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, stopPlayPublicStream failed.");
            return -1;
        }
        LogUtil.d(TAG, "startPlayPublicStream...public stream id: " + publicStreamId);
        return NativeFunctions.nativeStopPlayPublicStream(this.mNativeEngine, publicStreamId);
    }

    @Override
    public int setPublicStreamVideoCanvas(String publicStreamId, VideoCanvas canvas) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, setPublicStreamVideoCanvas failed.");
            return -1;
        }
        LogUtil.d(TAG, "startPlayPublicStream...public stream id: " + publicStreamId);
        return NativeFunctions.nativeSetPublicStreamVideoCanvas(this.mNativeEngine, publicStreamId, canvas.renderView, canvas.renderMode);
    }

    @Override
    public void setPublicStreamVideoSink(String publicStreamId, IVideoSink videoSink, int requiredFormat) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, setPublicStreamVideoSink failed.");
            return;
        }
        LogUtil.d(TAG, "setPublicStreamVideoSink...public stream id: " + publicStreamId);
        VideoSinkAdapter sinkAdapter = null;
        if (videoSink != null) {
            sinkAdapter = new VideoSinkAdapter(videoSink);
        }
        NativeFunctions.nativeSetPublicStreamVideoSink(this.mNativeEngine, publicStreamId, sinkAdapter, requiredFormat);
    }

    @Override
    public boolean isCameraTorchSupported() {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return false;
        }
        return NativeFunctions.nativeIsSupportFlashLight(this.mNativeEngine);
    }

    @Override
    public boolean isCameraZoomSupported() {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return false;
        }
        return NativeFunctions.nativeIsCameraZoomSupported(this.mNativeEngine);
    }

    @Override
    public int setCameraZoomRatio(float zoom) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return -1;
        }
        return NativeFunctions.nativeSetCameraZoomRatio(this.mNativeEngine, zoom);
    }

    @Override
    public float getCameraZoomMaxRatio() {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return -1.0f;
        }
        return NativeFunctions.nativeGetCameraZoomMaxRatio(this.mNativeEngine);
    }

    @Override
    public int setCameraTorch(TorchState torch_state) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return -1;
        }
        boolean enalbed = false;
        if (torch_state == TorchState.TORCH_STATE_ON) {
            enalbed = true;
        }
        return NativeFunctions.nativeEnableCameraTorch(this.mNativeEngine, enalbed);
    }

    @Override
    public boolean isCameraFocusPositionSupported() {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            return false;
        }
        return NativeFunctions.nativeIsCameraFocusPositionSupported(this.mNativeEngine);
    }

    @Override
    public int setCameraFocusPosition(float x, float y) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            return -1;
        }
        return NativeFunctions.nativeSetCameraFocusPosition(this.mNativeEngine, x, y);
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            return false;
        }
        return NativeFunctions.nativeIsCameraExposurePositionSupported(this.mNativeEngine);
    }

    @Override
    public int setCameraExposurePosition(float x, float y) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            return -1;
        }
        return NativeFunctions.nativeSetCameraExposurePosition(this.mNativeEngine, x, y);
    }

    @Override
    public int setCameraExposureCompensation(float val) {
        if (this.engineInvalid() || this.mState == State.DESTORY) {
            return -1;
        }
        return NativeFunctions.nativeSetCameraExposureCompensation(this.mNativeEngine, val);
    }

    @Override
    public int startForwardStreamToRooms(List<ForwardStreamInfo> forwardStreamInfos) {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, startForwardStreamToRooms failed.");
            return -1;
        }
        if (forwardStreamInfos == null) {
            return -1;
        }
        LinkedList<InternalForwardStreamInfo> internalForwardStreamInfos = new LinkedList<InternalForwardStreamInfo>();
        for (ForwardStreamInfo forwardStreamInfo : forwardStreamInfos) {
            internalForwardStreamInfos.add(new InternalForwardStreamInfo(forwardStreamInfo));
        }
        return NativeFunctions.nativeStartForwardStreamToRooms(this.mNativeEngine, internalForwardStreamInfos);
    }

    @Override
    public int updateForwardStreamToRooms(List<ForwardStreamInfo> forwardStreamInfos) {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, updateForwardStreamToRooms failed.");
            return -1;
        }
        if (forwardStreamInfos == null) {
            return -1;
        }
        LinkedList<InternalForwardStreamInfo> internalForwardStreamInfos = new LinkedList<InternalForwardStreamInfo>();
        for (ForwardStreamInfo forwardStreamInfo : forwardStreamInfos) {
            internalForwardStreamInfos.add(new InternalForwardStreamInfo(forwardStreamInfo));
        }
        return NativeFunctions.nativeUpdateForwardStreamToRooms(this.mNativeEngine, internalForwardStreamInfos);
    }

    @Override
    public void stopForwardStreamToRooms() {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, stopForwardStreamToRooms failed.");
            return;
        }
        NativeFunctions.nativeStopForwardStreamToRooms(this.mNativeEngine);
    }

    @Override
    public void pauseForwardStreamToAllRooms() {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, pauseForwardStreamToAllRooms failed.");
            return;
        }
        NativeFunctions.nativePauseForwardStreamToAllRooms(this.mNativeEngine);
    }

    @Override
    public void resumeForwardStreamToAllRooms() {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, resumeForwardStreamToAllRooms failed.");
            return;
        }
        NativeFunctions.nativeResumeForwardStreamToAllRooms(this.mNativeEngine);
    }

    @Override
    public void muteAudioPlayback(MuteState muteState) {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, muteAudioPlayback failed.");
            return;
        }
        NativeFunctions.nativeMuteAudioPlayback(this.mNativeEngine, muteState.value());
    }

    @Override
    public void setVideoWatermark(StreamIndex streamIndex, String imagePath, RTCWatermarkConfig watermarkConfig) {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, muteAudioPlayback failed.");
            return;
        }
        float lx = 0.0f;
        float ly = 0.0f;
        float lw = 0.0f;
        float lh = 0.0f;
        float px = 0.0f;
        float py = 0.0f;
        float pw = 0.0f;
        float ph = 0.0f;
        if (watermarkConfig.positionInLandscapeMode != null) {
            lx = watermarkConfig.positionInLandscapeMode.x;
            ly = watermarkConfig.positionInLandscapeMode.y;
            lw = watermarkConfig.positionInLandscapeMode.width;
            lh = watermarkConfig.positionInLandscapeMode.height;
        }
        if (watermarkConfig.positionInPortraitMode != null) {
            px = watermarkConfig.positionInPortraitMode.x;
            py = watermarkConfig.positionInPortraitMode.y;
            pw = watermarkConfig.positionInPortraitMode.width;
            ph = watermarkConfig.positionInPortraitMode.height;
        }
        NativeFunctions.nativeSetVideoWatermark(this.mNativeEngine, streamIndex.value(), imagePath, watermarkConfig.visibleInPreview, lx, ly, lw, lh, px, py, pw, ph);
    }

    @Override
    public void clearVideoWatermark(StreamIndex streamIndex) {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, clearVideoWatermark failed.");
            return;
        }
        NativeFunctions.nativeClearVideoWatermark(this.mNativeEngine, streamIndex.value());
    }

    @Override
    public void startCloudProxy(List<CloudProxyInfo> cloudProxiesInfo) {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, startCloudProxy failed.");
            return;
        }
        if (cloudProxiesInfo == null) {
            return;
        }
        ArrayList<InternalCloudProxyInfo> internalCloudProxiesInfo = new ArrayList<InternalCloudProxyInfo>();
        for (CloudProxyInfo cloudProxyInfo : cloudProxiesInfo) {
            internalCloudProxiesInfo.add(new InternalCloudProxyInfo(cloudProxyInfo));
        }
        NativeFunctions.nativeStartCloudProxy(this.mNativeEngine, internalCloudProxiesInfo);
    }

    @Override
    public void stopCloudProxy() {
        if (this.mNativeEngine == -1L || this.mState == State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, stopCloudProxy failed.");
            return;
        }
        NativeFunctions.nativeStopCloudProxy(this.mNativeEngine);
    }

    @Override
    public int registerFaceDetectionObserver(IFaceDetectionObserver observer, int interval) {
        this.mFaceDetectionObserver = new WeakReference<IFaceDetectionObserver>(observer);
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, registerFaceDetectionObserver failed.");
            return -1;
        }
        if (observer == null) {
            NativeFunctions.nativeRegisterFaceDetectionObserver(this.mNativeEngine, null, interval);
        } else {
            NativeFunctions.nativeRegisterFaceDetectionObserver(this.mNativeEngine, this.mRTCFaceDetectionObserver, interval);
        }
        return 0;
    }

    public IFaceDetectionObserver getFaceDetectionObserver() {
        return (IFaceDetectionObserver)this.mFaceDetectionObserver.get();
    }

    @Override
    public int startEchoTest(EchoTestConfig config, int delayTime) {
        LogUtil.d(TAG, "startEchoTest");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startEchoTest failed.");
            return -4;
        }
        return NativeFunctions.nativeStartEchoTest(this.mNativeEngine, config, delayTime);
    }

    @Override
    public int stopEchoTest() {
        LogUtil.d(TAG, "stopEchoTest");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopEchoTest failed.");
            return -2;
        }
        return NativeFunctions.nativeStopEchoTest(this.mNativeEngine);
    }

    static {
        mLibraryLoaded = false;
        mRtcNativeLibraryListener = new RTCNativeLibraryListenerImpl();
        sRtcLoaderInfo = new RTCNativeLibraryLoaderInfo();
        nativeHttpClient = null;
        mRTCAudioDeviceManagerEventHandler = null;
        mAudioDeviceManager = null;
        mDeviceId = "";
        RTCEngineImpl.loadSoFile();
    }

    public static class RtcHttpCallbackImpl
    implements RTCHttpClient.RtcHttpCallback {
        private int clientId;
        private int callbackId;

        @Override
        public void run(int code, String data) {
            NativeFunctions.nativeHttpClientCallback(this.callbackId, this.clientId, code, data);
        }

        public int getCallbackId() {
            return this.callbackId;
        }

        public void setCallbackId(int callbackId) {
            this.callbackId = callbackId;
        }

        public void setClientId(int clientId) {
            this.clientId = clientId;
        }
    }

    static enum State {
        IDLE,
        IN_ROOM,
        DESTORY;

    }
}

