/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import android.os.Looper;
import android.util.Log;
import com.ss.bytertc.engine.GameRTCEngineImpl;
import com.ss.bytertc.engine.InternalGameAudioVolumeInfo;
import com.ss.bytertc.engine.handler.AppExecutors;
import com.ss.bytertc.engine.handler.IGameRTCEventHandler;
import com.ss.bytertc.engine.utils.LogUtil;
import java.lang.ref.WeakReference;
import org.webrtc.CalledByNative;

public class GameRTCEventHandler {
    private WeakReference<GameRTCEngineImpl> mGameRTCEngineImpl;
    private AppExecutors mExecutors = AppExecutors.getInstance();
    private static final String TAG = "GameRTCEventHandler";

    public GameRTCEventHandler(GameRTCEngineImpl gameRTCEngineImpl) {
        this.mGameRTCEngineImpl = new WeakReference<GameRTCEngineImpl>(gameRTCEngineImpl);
    }

    @CalledByNative
    void onRoomStateChanged(String roomId, String userId, int state, String extraInfo) {
        LogUtil.d(TAG, "onRoomStateChanged...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onRoomStateChanged(roomId, userId, this.ConvertIntToRoomStateCode(state), extraInfo);
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onRoomStateChanged(roomId, userId, this.ConvertIntToRoomStateCode(state), extraInfo));
                }
            } else {
                Log.w((String)TAG, (String)"onRoomStateChanged GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRoomStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    void onStreamStateChanged(String roomId, String userId, int state, String extraInfo) {
        LogUtil.d(TAG, "onStreamStateChanged...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onStreamStateChanged(roomId, userId, this.ConvertIntToStreamStateCode(state), extraInfo);
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onStreamStateChanged(roomId, userId, this.ConvertIntToStreamStateCode(state), extraInfo));
                }
            } else {
                Log.w((String)TAG, (String)"onStreamStateChanged GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onStreamStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLeaveRoom(String roomId) {
        LogUtil.d(TAG, "onLeaveRoom...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onLeaveRoom(roomId);
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onLeaveRoom(roomId));
                }
            } else {
                Log.w((String)TAG, (String)"onLeaveRoom GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onLeaveRoom callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioVolumeIndication(String roomId, InternalGameAudioVolumeInfo[] speakers, int totalVolume) {
        LogUtil.d(TAG, "onAudioVolumeIndication...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            IGameRTCEventHandler.AudioVolumeInfo[] speakersInfo = new IGameRTCEventHandler.AudioVolumeInfo[speakers.length];
            String[] speakerNames = new String[speakers.length];
            int[] speakerVolumes = new int[speakers.length];
            for (int index = 0; index < speakers.length; ++index) {
                speakersInfo[index] = new IGameRTCEventHandler.AudioVolumeInfo(speakers[index]);
                speakerNames[index] = speakers[index].userId;
                speakerVolumes[index] = speakers[index].volume;
            }
            if (handler != null) {
                IGameRTCEventHandler.AudioVolumeInfoArray infoArray = new IGameRTCEventHandler.AudioVolumeInfoArray(speakerNames, speakerVolumes);
                if (this.isMainThread()) {
                    handler.onAudioVolumeIndication(roomId, infoArray, totalVolume);
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onAudioVolumeIndication(roomId, infoArray, totalVolume));
                }
            } else {
                Log.w((String)TAG, (String)"onAudioVolumeIndication GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onAudioVolumeIndication callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onMicrophoneEnabled(String roomId, String userId, boolean enable) {
        LogUtil.d(TAG, "onMicrophoneEnabled...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onMicrophoneEnabled(roomId, userId, enable);
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onMicrophoneEnabled(roomId, userId, enable));
                }
            } else {
                Log.w((String)TAG, (String)"onMicrophoneEnabled GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onMicrophoneEnabled callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioSendEnabled(String roomId, String userId, boolean enable) {
        LogUtil.d(TAG, "onAudioSendEnabled...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onAudioSendEnabled(roomId, userId, enable);
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onAudioSendEnabled(roomId, userId, enable));
                }
            } else {
                Log.w((String)TAG, (String)"onAudioSendEnabled GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onAudioSendEnabled callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserJoined(String roomId, String userId) {
        LogUtil.d(TAG, "onUserJoined...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onUserJoined(roomId, userId);
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onUserJoined(roomId, userId));
                }
            } else {
                Log.w((String)TAG, (String)"onUserJoined GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserJoined callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserLeave(String roomId, String userId, int reason) {
        LogUtil.d(TAG, "onUserOffline...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onUserLeave(roomId, userId, this.ConvertIntToUserLeaveReasonType(reason));
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onUserLeave(roomId, userId, this.ConvertIntToUserLeaveReasonType(reason)));
                }
            } else {
                Log.w((String)TAG, (String)"onUserLeave GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserOffline callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onConnectionStateChanged(int state) {
        LogUtil.d(TAG, "onConnectionStateChanged...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onConnectionStateChanged(this.ConvertIntToConnectionState(state));
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onConnectionStateChanged(this.ConvertIntToConnectionState(state)));
                }
            } else {
                Log.w((String)TAG, (String)"onConnectionStateChanged GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onConnectionStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onNetworkQuality(String roomId, String userId, int txQuality, int rxQuality) {
        LogUtil.d(TAG, "onNetworkQuality...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onNetworkQuality(roomId, userId, this.ConvertIntToNetworkQuality(txQuality), this.ConvertIntToNetworkQuality(rxQuality));
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onNetworkQuality(roomId, userId, this.ConvertIntToNetworkQuality(txQuality), this.ConvertIntToNetworkQuality(rxQuality)));
                }
            } else {
                Log.w((String)TAG, (String)"onNetworkQuality GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onNetworkQuality callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSpeakerphoneEnabled(String roomId, String userId, boolean enable) {
        LogUtil.d(TAG, "onSpeakerphoneEnabled...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onSpeakerphoneEnabled(roomId, userId, enable);
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onSpeakerphoneEnabled(roomId, userId, enable));
                }
            } else {
                Log.w((String)TAG, (String)"onSpeakerphoneEnabled GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onSpeakerphoneEnabled callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLogReport(String logType, String logContent) {
    }

    @CalledByNative
    public void onEngineWarning(int warn) {
        LogUtil.d(TAG, "onEngineWarning...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onEngineWarning(this.ConvertIntToEngineWarnCode(warn));
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onEngineWarning(this.ConvertIntToEngineWarnCode(warn)));
                }
            } else {
                Log.w((String)TAG, (String)"onEngineWarning GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onEngineWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomWarning(String roomId, int warn) {
        LogUtil.d(TAG, "onRoomWarning...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onRoomWarning(roomId, this.ConvertIntToRoomWarnCode(warn));
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onRoomWarning(roomId, this.ConvertIntToRoomWarnCode(warn)));
                }
            } else {
                Log.w((String)TAG, (String)"onRoomWarning GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRoomWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomError(String roomId, int err) {
        LogUtil.d(TAG, "onRoomError...");
        try {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            if (handler != null) {
                if (this.isMainThread()) {
                    handler.onRoomError(roomId, this.ConvertIntToRoomErrorCode(err));
                } else {
                    this.mExecutors.mainThread().execute(() -> handler.onRoomError(roomId, this.ConvertIntToRoomErrorCode(err)));
                }
            } else {
                Log.w((String)TAG, (String)"onRoomError GameRTCEngineImpl.getGameRTCEventHandler() == null");
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRoomError callback catch exception.\n" + ex.getMessage());
        }
    }

    private boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    private IGameRTCEventHandler.RoomStateCode ConvertIntToRoomStateCode(int code) {
        switch (code) {
            case -1000: {
                return IGameRTCEventHandler.RoomStateCode.JOIN_ROOM_INVALID_TOKEN;
            }
            case -1001: {
                return IGameRTCEventHandler.RoomStateCode.JOIN_ROOM_ERROR;
            }
            case -2001: {
                return IGameRTCEventHandler.RoomStateCode.JOIN_ROOM_FAILED;
            }
            case -1004: {
                return IGameRTCEventHandler.RoomStateCode.JOIN_ROOM_DUPLICATE_LOGIN;
            }
        }
        return IGameRTCEventHandler.RoomStateCode.JOIN_ROOM_SUCCESS;
    }

    private IGameRTCEventHandler.StreamStateCode ConvertIntToStreamStateCode(int code) {
        switch (code) {
            case -1002: {
                return IGameRTCEventHandler.StreamStateCode.STREAM_STATE_NO_PUBLISH_PERMISSION;
            }
            case -1003: {
                return IGameRTCEventHandler.StreamStateCode.STREAM_STATE_NO_SUBSCRIBE_PERMISSION;
            }
            case -2002: {
                return IGameRTCEventHandler.StreamStateCode.STREAM_STATE_PUBLISH_STREAM_FAILED;
            }
            case -2003: {
                return IGameRTCEventHandler.StreamStateCode.STREAM_STATE_SUBSCRIBE_STREAM_FAILED_404;
            }
            case -2004: {
                return IGameRTCEventHandler.StreamStateCode.STREAM_STATE_SUBSCRIBE_STREAM_FAILED_5XX;
            }
            case -2007: {
                return IGameRTCEventHandler.StreamStateCode.STREAM_STATE_INVALID_EXPECT_MS_ADDR;
            }
        }
        return IGameRTCEventHandler.StreamStateCode.STREAM_STATE_INVALID;
    }

    private IGameRTCEventHandler.RoomErrorCode ConvertIntToRoomErrorCode(int code) {
        switch (code) {
            case -1002: {
                return IGameRTCEventHandler.RoomErrorCode.ROOM_ERROR_NO_PUBLISH_PERMISSION;
            }
            case -1003: {
                return IGameRTCEventHandler.RoomErrorCode.ROOM_ERROR_NO_SUBSCRIBE_PERMISSION;
            }
            case -1004: {
                return IGameRTCEventHandler.RoomErrorCode.ROOM_ERROR_DUPLICATE_LOGIN;
            }
        }
        return IGameRTCEventHandler.RoomErrorCode.ROOM_ERROR_INVALID;
    }

    private IGameRTCEventHandler.RoomWarnCode ConvertIntToRoomWarnCode(int code) {
        switch (code) {
            case -2002: {
                return IGameRTCEventHandler.RoomWarnCode.ROOM_WARN_PUBLISH_STREAM_FAILED;
            }
            case -2003: {
                return IGameRTCEventHandler.RoomWarnCode.ROOM_WARN_SUBSCRIBE_STREAM_FAILED_404;
            }
            case -2004: {
                return IGameRTCEventHandler.RoomWarnCode.ROOM_WARN_SUBSCRIBE_STREAM_FAILED_5XX;
            }
            case -2007: {
                return IGameRTCEventHandler.RoomWarnCode.ROOM_WARN_INVALID_EXPECT_MS_ADDR;
            }
        }
        return IGameRTCEventHandler.RoomWarnCode.ROOM_WARN_INVALID;
    }

    private IGameRTCEventHandler.EngineWarnCode ConvertIntToEngineWarnCode(int code) {
        switch (code) {
            case -5002: {
                return IGameRTCEventHandler.EngineWarnCode.ENGINE_WARN_NO_MICROPHONE_PERMISSION;
            }
            case -5003: {
                return IGameRTCEventHandler.EngineWarnCode.ENGINE_WARN_ADM_RECORDING_START_FAIL;
            }
            case -5004: {
                return IGameRTCEventHandler.EngineWarnCode.ENGINE_WARN_ADM_PLAYOUT_START_FAIL;
            }
            case -5005: {
                return IGameRTCEventHandler.EngineWarnCode.ENGINE_WARN_ADM_NO_RECORDING_DEVICE;
            }
            case -5006: {
                return IGameRTCEventHandler.EngineWarnCode.ENGINE_WARN_ADM_NO_PLAYOUT_DEVICE;
            }
        }
        return IGameRTCEventHandler.EngineWarnCode.ENGINE_WARN_INVALID;
    }

    private IGameRTCEventHandler.NetworkQuality ConvertIntToNetworkQuality(int quality) {
        switch (quality) {
            case 0: {
                return IGameRTCEventHandler.NetworkQuality.QUALITY_UNKNOWN;
            }
            case 1: {
                return IGameRTCEventHandler.NetworkQuality.QUALITY_EXCELLENT;
            }
            case 2: {
                return IGameRTCEventHandler.NetworkQuality.QUALITY_GOOD;
            }
            case 3: {
                return IGameRTCEventHandler.NetworkQuality.QUALITY_POOR;
            }
            case 4: {
                return IGameRTCEventHandler.NetworkQuality.QUALITY_BAD;
            }
            case 5: {
                return IGameRTCEventHandler.NetworkQuality.QUALITY_VBAD;
            }
        }
        return IGameRTCEventHandler.NetworkQuality.QUALITY_INVALID;
    }

    private IGameRTCEventHandler.UserLeaveReasonType ConvertIntToUserLeaveReasonType(int reason) {
        switch (reason) {
            case 0: {
                return IGameRTCEventHandler.UserLeaveReasonType.QUIT;
            }
            case 1: {
                return IGameRTCEventHandler.UserLeaveReasonType.DROPPED;
            }
        }
        return IGameRTCEventHandler.UserLeaveReasonType.INVALID;
    }

    private IGameRTCEventHandler.ConnectionState ConvertIntToConnectionState(int state) {
        switch (state) {
            case 0: {
                return IGameRTCEventHandler.ConnectionState.DISCONNECTED;
            }
            case 1: {
                return IGameRTCEventHandler.ConnectionState.CONNECTING;
            }
            case 2: {
                return IGameRTCEventHandler.ConnectionState.CONNECTED;
            }
            case 3: {
                return IGameRTCEventHandler.ConnectionState.RECONNECTING;
            }
            case 4: {
                return IGameRTCEventHandler.ConnectionState.RECONNECTED;
            }
            case 5: {
                return IGameRTCEventHandler.ConnectionState.LOST;
            }
            case 6: {
                return IGameRTCEventHandler.ConnectionState.FAILED;
            }
        }
        return IGameRTCEventHandler.ConnectionState.INVALID;
    }
}

