/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.InternalGameAudioVolumeInfo;
import com.ss.bytertc.engine.utils.LogUtil;
import org.json.JSONObject;

public interface IGameRTCEventHandler {
    public void onRoomStateChanged(String var1, String var2, RoomStateCode var3, String var4);

    public void onStreamStateChanged(String var1, String var2, StreamStateCode var3, String var4);

    public void onLeaveRoom(String var1);

    public void onUserJoined(String var1, String var2);

    public void onUserLeave(String var1, String var2, UserLeaveReasonType var3);

    public void onMicrophoneEnabled(String var1, String var2, boolean var3);

    public void onAudioSendEnabled(String var1, String var2, boolean var3);

    public void onSpeakerphoneEnabled(String var1, String var2, boolean var3);

    public void onAudioVolumeIndication(String var1, AudioVolumeInfoArray var2, int var3);

    public void onConnectionStateChanged(ConnectionState var1);

    public void onNetworkQuality(String var1, String var2, NetworkQuality var3, NetworkQuality var4);

    public void onLogReport(String var1, JSONObject var2);

    public void onEngineWarning(EngineWarnCode var1);

    public void onRoomWarning(String var1, RoomWarnCode var2);

    public void onRoomError(String var1, RoomErrorCode var2);

    public void onLoggerMessage(LogUtil.LogLevel var1, String var2, Throwable var3);

    public static enum NetworkQuality {
        QUALITY_INVALID(-1),
        QUALITY_UNKNOWN(0),
        QUALITY_EXCELLENT(1),
        QUALITY_GOOD(2),
        QUALITY_POOR(3),
        QUALITY_BAD(4),
        QUALITY_VBAD(5);

        private int value = 0;

        private NetworkQuality(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum UserLeaveReasonType {
        INVALID(-1),
        QUIT(0),
        DROPPED(1);

        private int value = 0;

        private UserLeaveReasonType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum ConnectionState {
        INVALID(-1),
        DISCONNECTED(0),
        CONNECTING(1),
        CONNECTED(2),
        RECONNECTING(3),
        RECONNECTED(4),
        LOST(5),
        FAILED(6);

        private int value = 0;

        private ConnectionState(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum EngineWarnCode {
        ENGINE_WARN_INVALID(-1),
        ENGINE_WARN_NO_MICROPHONE_PERMISSION(-5002),
        ENGINE_WARN_ADM_RECORDING_START_FAIL(-5003),
        ENGINE_WARN_ADM_PLAYOUT_START_FAIL(-5004),
        ENGINE_WARN_ADM_NO_RECORDING_DEVICE(-5005),
        ENGINE_WARN_ADM_NO_PLAYOUT_DEVICE(-5006);

        private int value = 0;

        private EngineWarnCode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum RoomWarnCode {
        ROOM_WARN_INVALID(-1),
        ROOM_WARN_PUBLISH_STREAM_FAILED(-2002),
        ROOM_WARN_SUBSCRIBE_STREAM_FAILED_404(-2003),
        ROOM_WARN_SUBSCRIBE_STREAM_FAILED_5XX(-2004),
        ROOM_WARN_INVALID_EXPECT_MS_ADDR(-2007);

        private int value = 0;

        private RoomWarnCode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum RoomErrorCode {
        ROOM_ERROR_INVALID(-1),
        ROOM_ERROR_NO_PUBLISH_PERMISSION(-1002),
        ROOM_ERROR_NO_SUBSCRIBE_PERMISSION(-1003),
        ROOM_ERROR_DUPLICATE_LOGIN(-1004);

        private int value = 0;

        private RoomErrorCode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum StreamStateCode {
        STREAM_STATE_INVALID(-1),
        STREAM_STATE_NO_PUBLISH_PERMISSION(-1002),
        STREAM_STATE_NO_SUBSCRIBE_PERMISSION(-1003),
        STREAM_STATE_PUBLISH_STREAM_FAILED(-2002),
        STREAM_STATE_SUBSCRIBE_STREAM_FAILED_404(-2003),
        STREAM_STATE_SUBSCRIBE_STREAM_FAILED_5XX(-2004),
        STREAM_STATE_INVALID_EXPECT_MS_ADDR(-2007);

        private int value = 0;

        private StreamStateCode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum RoomStateCode {
        JOIN_ROOM_SUCCESS(0),
        JOIN_ROOM_INVALID_TOKEN(-1000),
        JOIN_ROOM_ERROR(-1001),
        JOIN_ROOM_FAILED(-2001),
        JOIN_ROOM_DUPLICATE_LOGIN(-1004);

        private int value = 0;

        private RoomStateCode(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static class AudioVolumeInfoArray {
        public String[] userNames;
        public int[] volumes;

        public AudioVolumeInfoArray(String[] userNames, int[] volumes) {
            this.userNames = userNames;
            this.volumes = volumes;
        }

        public String[] getUserNames() {
            return this.userNames;
        }

        public int[] getVolumes() {
            return this.volumes;
        }
    }

    public static class AudioVolumeInfo {
        public String userId;
        public int volume;

        public AudioVolumeInfo(String userId, int volume) {
            this.userId = userId;
            this.volume = volume;
        }

        public AudioVolumeInfo(InternalGameAudioVolumeInfo internalInfo) {
            this.userId = internalInfo.userId;
            this.volume = internalInfo.volume;
        }
    }
}

