/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import android.support.annotation.NonNull;
import com.bytedance.realx.base.CalledByNative;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.ktv.IKTVPlayerEventHandler;
import com.ss.bytertc.ktv.data.PlayState;

public class KTVPlayEventHandler
extends IKTVPlayerEventHandler {
    private static final String TAG = "KTVPlayEventHandler";
    private final IKTVPlayerEventHandler mHandler;

    public KTVPlayEventHandler(IKTVPlayerEventHandler handler) {
        this.mHandler = handler;
    }

    @Override
    @CalledByNative
    public void onPlayProgress(@NonNull String musicId, long progress) {
        LogUtil.d(TAG, "onPlayProgress...musicId: " + musicId + ",progress:" + progress);
        try {
            if (this.mHandler != null) {
                this.mHandler.onPlayProgress(musicId, progress);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPlayProgress callback catch exception.\n" + ex.getMessage());
        }
    }

    @Override
    @CalledByNative
    public void onPlayStateChange(int errorCode, @NonNull String musicId, @NonNull PlayState playState) {
        LogUtil.d(TAG, "onPlayStateChange...musicId: " + musicId + ",playState:" + playState.toString());
        try {
            if (this.mHandler != null) {
                this.mHandler.onPlayStateChange(errorCode, musicId, playState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPlayStateChange callback catch exception.\n" + ex.getMessage());
        }
    }
}

