/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.handler.IRTCEncryptionHandler;
import com.ss.bytertc.engine.utils.LogUtil;
import org.webrtc.CalledByNative;

public class RTCEncryptHandler {
    private static final String TAG = "RtcEngineEncryptHandler";
    private IRTCEncryptionHandler mCustomizeEncryptHandler;

    public RTCEncryptHandler(IRTCEncryptionHandler customizeEncryptHandler) {
        this.mCustomizeEncryptHandler = customizeEncryptHandler;
    }

    @CalledByNative
    public byte[] onEncryptData(byte[] data) {
        LogUtil.d(TAG, "onEncryptData...");
        byte[] result = null;
        try {
            if (this.mCustomizeEncryptHandler != null) {
                result = this.mCustomizeEncryptHandler.onEncryptData(data);
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onEncryptData callback catch exception.\n" + ex.getMessage());
        }
        return result;
    }

    @CalledByNative
    public byte[] onDecryptData(byte[] data) {
        LogUtil.d(TAG, "onDecryptData...");
        byte[] result = null;
        try {
            if (this.mCustomizeEncryptHandler != null) {
                result = this.mCustomizeEncryptHandler.onDecryptData(data);
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onDecryptData callback catch exception.\n" + ex.getMessage());
        }
        return result;
    }
}

