/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.data.VideoCodecType;
import com.ss.bytertc.engine.data.VideoPictureType;
import com.ss.bytertc.engine.data.VideoRotation;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.mediaio.ILocalEncodedVideoFrameObserver;
import com.ss.bytertc.engine.mediaio.RTCEncodedVideoFrame;
import java.lang.ref.WeakReference;
import org.webrtc.CalledByNative;
import org.webrtc.VideoStream;

public class RTCLocalEncodedVideoFrameObserver {
    private static final String TAG = "RTCLocalEncodedVideoFrameObserver";
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;

    public RTCLocalEncodedVideoFrameObserver(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public RTCLocalEncodedVideoFrameObserver(RTCVideoImpl rtcVideoImpl) {
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
    }

    @CalledByNative
    void onLocalEncodedVideoFrame(int streamIndex, VideoStream videoStream, long timestampUs, long timestampDtsUs, int videoCodecType, int videoPictureType, int videoRotation) {
        RTCVideoImpl strongVideo;
        ILocalEncodedVideoFrameObserver encodedVideoFrameObserver;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (encodedVideoFrameObserver = strongEngine.getEncodedVideoFrameObserver()) != null) {
            encodedVideoFrameObserver.onLocalEncodedVideoFrame(StreamIndex.fromId(streamIndex), new RTCEncodedVideoFrame(videoStream.getBuffer().getData(), timestampUs, timestampDtsUs, videoStream.getWidth(), videoStream.getHeight(), VideoCodecType.fromId(videoCodecType), VideoPictureType.fromId(videoPictureType), VideoRotation.fromId(videoRotation)));
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (encodedVideoFrameObserver = strongVideo.getEncodedVideoFrameObserver()) != null) {
            encodedVideoFrameObserver.onLocalEncodedVideoFrame(StreamIndex.fromId(streamIndex), new RTCEncodedVideoFrame(videoStream.getBuffer().getData(), timestampUs, timestampDtsUs, videoStream.getWidth(), videoStream.getHeight(), VideoCodecType.fromId(videoCodecType), VideoPictureType.fromId(videoPictureType), VideoRotation.fromId(videoRotation)));
        }
    }
}

