/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import android.graphics.Matrix;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.engine.utils.TextureBufferImpl;
import com.ss.bytertc.engine.utils.TextureHelper;
import com.ss.bytertc.engine.video.IVideoProcessor;
import com.ss.bytertc.engine.video.MultiVideoFrameWrapper;
import com.ss.bytertc.engine.video.VideoFrame;
import com.ss.bytertc.engine.video.impl.WebrtcWrapperVideoFrame;
import java.lang.ref.WeakReference;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.NV12Buffer;
import org.webrtc.NV21Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;

public class RTCVideoProcessor {
    private static final String TAG = "RTCVideoProcessor";
    private EngineType engineType = EngineType.NONE;
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;
    private IVideoProcessor mCustomVideoPreprocessor;
    private TextureHelperRef mTxtHelperRef = null;
    private boolean mNeedRecreateTextureHelper = false;
    VideoPixelFormat mRequiredFormat = VideoPixelFormat.kVideoPixelFormatUnknown;
    private EglBase14 mEglbase = null;
    private EglBase14.Context mSharedContext = null;
    private final Handler mHandler;

    public RTCVideoProcessor(RTCEngineImpl rtcEngineImpl) {
        this.engineType = EngineType.BYTERTCENGINE;
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mHandler = new Handler(thread.getLooper());
    }

    public RTCVideoProcessor(RTCVideoImpl rtcVideoImpl) {
        this.engineType = EngineType.BYTERTCVIDEO;
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mHandler = new Handler(thread.getLooper());
    }

    public void dispose() {
        ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, () -> this.releaseEGL());
        this.mHandler.getLooper().quit();
        if (this.mTxtHelperRef != null) {
            this.mTxtHelperRef.release();
        }
    }

    public IVideoProcessor getCustomVideoPreprocessor() {
        return this.mCustomVideoPreprocessor;
    }

    public int registerLocalVideoProcessor(IVideoProcessor processor, VideoPixelFormat format) {
        if (!RTCVideoProcessor.check_require_format(format)) {
            LogUtil.e(TAG, "custom video preprocessor setRequiredFormat failed.");
            return -1;
        }
        ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, () -> {
            IVideoProcessor old_processor = this.getCustomVideoPreprocessor();
            if (old_processor != null && this.mEglbase != null) {
                old_processor.onGLEnvRelease();
            }
            this.mRequiredFormat = format;
            this.mCustomVideoPreprocessor = processor;
        });
        return 0;
    }

    @CalledByNative
    MultiVideoFrameWrapper processVideoFrame(org.webrtc.VideoFrame frame) {
        RTCEngineImpl strongEngine = null;
        RTCVideoImpl strongVideo = null;
        if (this.mRtcEngineImpl != null) {
            strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
        }
        if (this.mRtcVideoImpl != null) {
            strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get();
        }
        if (strongEngine == null && this.engineType == EngineType.BYTERTCENGINE || strongVideo == null && this.engineType == EngineType.BYTERTCVIDEO) {
            LogUtil.e(TAG, "engine is invalid, processVideoFrame failed.");
            return null;
        }
        IVideoProcessor videoProcessor = this.getCustomVideoPreprocessor();
        if (videoProcessor == null) {
            LogUtil.e(TAG, "custom video preprocessor is invalid, processVideoFrame failed.");
            return null;
        }
        VideoPixelFormat src_format = RTCVideoProcessor.get_frame_format(frame);
        org.webrtc.VideoFrame src_frame = frame;
        ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, () -> this.updateEGLEnv(frame));
        if (this.mRequiredFormat == VideoPixelFormat.kVideoPixelFormatUnknown) {
            if (!RTCVideoProcessor.check_src_format(src_format)) {
                VideoFrame.I420Buffer i420Buffer = frame.getBuffer().toI420();
                if (i420Buffer == null) {
                    LogUtil.e(TAG, "fail to convert frame to i420");
                    return null;
                }
                src_frame = new org.webrtc.VideoFrame((VideoFrame.Buffer)i420Buffer, frame.getRotation(), frame.getTimestampNs(), frame.getFlipState());
            }
        } else if (this.mRequiredFormat != src_format) {
            switch (this.mRequiredFormat) {
                case kVideoPixelFormatTexture2D: {
                    src_frame = this.toTexture2DFrame(src_format, frame);
                    if (src_frame != null) break;
                    return null;
                }
                default: {
                    LogUtil.e(TAG, "src format should be TEXTURE_2D.");
                    return null;
                }
            }
        }
        MultiVideoFrameWrapper processed_frame = this.processVideoFrameInternal(videoProcessor, src_frame);
        if (src_frame != frame) {
            src_frame.release();
        }
        return processed_frame;
    }

    MultiVideoFrameWrapper processVideoFrameInternal(IVideoProcessor videoProcessor, org.webrtc.VideoFrame frame) {
        VideoFrame processed_frame = null;
        try {
            processed_frame = ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, () -> {
                WebrtcWrapperVideoFrame src_frame = new WebrtcWrapperVideoFrame(frame, EGL14.eglGetCurrentContext());
                VideoFrame ret_frame = null;
                try {
                    ret_frame = videoProcessor.processVideoFrame(src_frame);
                }
                catch (Exception e) {
                    LogUtil.e(TAG, " failed to exec user's processVideoFrame callback", e);
                }
                if (ret_frame == null) {
                    LogUtil.e(TAG, "return frame if null.");
                }
                if (ret_frame.getFrameType() == VideoFrameType.kVideoFrameTypeGLTexture) {
                    GLES20.glFinish();
                }
                if (src_frame != ret_frame) {
                    src_frame.release();
                }
                return ret_frame;
            });
            if (processed_frame == null) {
                LogUtil.e(TAG, "custom video process return null, processVideoFrameInternal failed.");
                return null;
            }
            if (processed_frame.getFrameType() == VideoFrameType.kVideoFrameTypeGLTexture) {
                org.webrtc.VideoFrame dst_frame = this.byteTextureFrame2WebrtcTextureFrame(processed_frame);
                return new MultiVideoFrameWrapper(dst_frame);
            }
            if (processed_frame.getFrameType() == VideoFrameType.kVideoFrameTypeRawMemory) {
                return new MultiVideoFrameWrapper(processed_frame);
            }
            LogUtil.e(TAG, "custom video process processed_frame type unknown, processVideoFrameInternal failed.");
            return null;
        }
        catch (RuntimeException e) {
            LogUtil.e(TAG, " failed to do custom video process", e);
            if (processed_frame != null) {
                processed_frame.release();
            }
            return null;
        }
    }

    org.webrtc.VideoFrame byteTextureFrame2WebrtcTextureFrame(VideoFrame frame) {
        org.webrtc.VideoFrame dst_frame = null;
        if (frame.getFrameType() != VideoFrameType.kVideoFrameTypeGLTexture) {
            return null;
        }
        this.updateTextureHelper(frame.getWidth(), frame.getHeight());
        if (this.mTxtHelperRef == null) {
            LogUtil.e(TAG, "texture helper is invalid, ToVideoFrame failed.");
            return null;
        }
        if (frame.hasReleaseCallback()) {
            VideoFrame.TextureBuffer.Type type = VideoFrame.TextureBuffer.Type.RGB;
            Matrix matrix = frame.getTextureMatrix() != null ? RendererCommon.convertMatrixToAndroidGraphicsMatrix(frame.getTextureMatrix()) : new Matrix();
            this.mTxtHelperRef.retain();
            TextureHelperRef tempTexHelperRef = this.mTxtHelperRef;
            TextureBufferImpl buffer = new TextureBufferImpl(frame.getWidth(), frame.getHeight(), type, frame.getTextureID(), matrix, this.mTxtHelperRef.mTextureHelper, () -> {
                frame.release();
                tempTexHelperRef.release();
            });
            buffer.setEglBaseContext(this.mTxtHelperRef.mTextureHelper.getEglBaseContext());
            dst_frame = new org.webrtc.VideoFrame(buffer, frame.getRotation().value(), frame.getTimeStampUs());
        } else {
            int targetTextureId = this.mTxtHelperRef.mTextureHelper.dequeueTexture();
            if (targetTextureId == 0) {
                LogUtil.e(TAG, "failed to get a texture, ToVideoFrame failed.");
                return null;
            }
            try {
                int pixelFormat = 10;
                if (frame.getPixelFormat() == VideoPixelFormat.kVideoPixelFormatTextureOES) {
                    pixelFormat = 11;
                }
                this.mTxtHelperRef.mTextureHelper.drawTexture(pixelFormat, frame.getTextureID(), targetTextureId);
            }
            catch (RuntimeException e) {
                LogUtil.e(TAG, "failed to draw to target texture, ToVideoFrame failed.");
                this.mTxtHelperRef.mTextureHelper.queueTexture(targetTextureId);
                return null;
            }
            VideoFrame.TextureBuffer.Type type = VideoFrame.TextureBuffer.Type.RGB;
            Matrix matrix = frame.getTextureMatrix() != null ? RendererCommon.convertMatrixToAndroidGraphicsMatrix(frame.getTextureMatrix()) : new Matrix();
            this.mTxtHelperRef.retain();
            TextureHelperRef tempTexHelperRef = this.mTxtHelperRef;
            TextureBufferImpl buffer = new TextureBufferImpl(frame.getWidth(), frame.getHeight(), type, targetTextureId, matrix, this.mTxtHelperRef.mTextureHelper, () -> {
                this.mTxtHelperRef.mTextureHelper.queueTexture(targetTextureId);
                tempTexHelperRef.release();
            });
            buffer.setEglBaseContext(this.mTxtHelperRef.mTextureHelper.getEglBaseContext());
            frame.release();
            dst_frame = new org.webrtc.VideoFrame(buffer, frame.getRotation().value(), frame.getTimeStampUs());
        }
        return dst_frame;
    }

    org.webrtc.VideoFrame toTexture2DFrame(VideoPixelFormat src_format, org.webrtc.VideoFrame src_frame) {
        if (src_format == VideoPixelFormat.kVideoPixelFormatTexture2D) {
            src_frame.retain();
            return src_frame;
        }
        VideoFrame.Buffer src_buffer = src_frame.getBuffer();
        this.updateTextureHelper(src_buffer.getWidth(), src_buffer.getHeight());
        if (this.mTxtHelperRef == null) {
            LogUtil.e(TAG, "texture helper is invalid, toTexture2DFrame failed.");
            return null;
        }
        int targetTextureId = this.mTxtHelperRef.mTextureHelper.dequeueTexture();
        if (targetTextureId == 0) {
            LogUtil.e(TAG, "failed to get a texture, toTexture2DFrame failed.");
            return null;
        }
        Matrix matrix = null;
        try {
            switch (src_format) {
                case kVideoPixelFormatTextureOES: {
                    VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)src_buffer;
                    matrix = textureBuffer.getTransformMatrix();
                    this.mTxtHelperRef.mTextureHelper.drawTexture(11, textureBuffer.getTextureId(), targetTextureId);
                    break;
                }
                case kVideoPixelFormatI420: {
                    VideoFrame.I420Buffer i420Buffer = (VideoFrame.I420Buffer)src_buffer;
                    this.mTxtHelperRef.mTextureHelper.yuvToTexture(i420Buffer, targetTextureId);
                    break;
                }
                default: {
                    VideoFrame.I420Buffer i420Buffer = src_buffer.toI420();
                    if (i420Buffer == null) {
                        LogUtil.e(TAG, "fail to convert frame to i420");
                        return null;
                    }
                    this.mTxtHelperRef.mTextureHelper.yuvToTexture(i420Buffer, targetTextureId);
                    i420Buffer.release();
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            LogUtil.e(TAG, "failed to draw, toTexture2DFrame failed.");
            return null;
        }
        if (matrix == null) {
            matrix = new Matrix();
        }
        this.mTxtHelperRef.retain();
        TextureHelperRef tempTexHelperRef = this.mTxtHelperRef;
        TextureBufferImpl tmpBuffer2D = new TextureBufferImpl(src_buffer.getWidth(), src_buffer.getHeight(), VideoFrame.TextureBuffer.Type.RGB, targetTextureId, matrix, this.mTxtHelperRef.mTextureHelper, () -> {
            this.mTxtHelperRef.mTextureHelper.queueTexture(targetTextureId);
            tempTexHelperRef.release();
        });
        tmpBuffer2D.setEglBaseContext(this.mTxtHelperRef.mTextureHelper.getEglBaseContext());
        return new org.webrtc.VideoFrame((VideoFrame.Buffer)tmpBuffer2D, src_frame.getRotation(), src_frame.getTimestampNs(), src_frame.getFlipState());
    }

    void updateTextureHelper(int width, int height) {
        RTCEngineImpl strongEngine = null;
        RTCVideoImpl strongVideo = null;
        if (this.mRtcEngineImpl != null) {
            strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
        }
        if (this.mRtcVideoImpl != null) {
            strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get();
        }
        if (strongEngine == null && this.engineType == EngineType.BYTERTCENGINE || strongVideo == null && this.engineType == EngineType.BYTERTCVIDEO) {
            return;
        }
        if ((this.mTxtHelperRef == null || this.mNeedRecreateTextureHelper || this.mTxtHelperRef.mTextureHelper.getWidth() != width || this.mTxtHelperRef.mTextureHelper.getHeight() != height) && this.mEglbase != null) {
            if (this.mTxtHelperRef != null) {
                this.mTxtHelperRef.release();
            }
            this.mTxtHelperRef = TextureHelperRef.create(width, height, this.mEglbase);
            this.mNeedRecreateTextureHelper = false;
        }
    }

    void updateEGLEnv(org.webrtc.VideoFrame inputFrame) {
        if (inputFrame == null) {
            return;
        }
        RTCEngineImpl strongEngine = null;
        RTCVideoImpl strongVideo = null;
        if (this.mRtcEngineImpl != null) {
            strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
        }
        if (this.mRtcVideoImpl != null) {
            strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get();
        }
        if (strongEngine == null && this.engineType == EngineType.BYTERTCENGINE || strongVideo == null && this.engineType == EngineType.BYTERTCVIDEO) {
            LogUtil.e(TAG, "engine is invalid, initEGL failed.");
            throw new RuntimeException("engine is invalid, initEGL failed.");
        }
        int[] CONFIG_PIXEL_BUFFER = new int[]{12352, 4, 12339, 1, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 8, 12326, 8, 12344};
        VideoFrame.Buffer originVideoFrameBuffer = inputFrame.getBuffer();
        boolean isTextureBuffer = originVideoFrameBuffer instanceof VideoFrame.TextureBuffer;
        boolean isEglEnvChanged = false;
        if (isTextureBuffer) {
            VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)originVideoFrameBuffer;
            long nativeSharedContext = 0L;
            EGLContext eglContext = textureBuffer.getEglContext();
            EglBase14.Context newSharedContext = new EglBase14.Context(eglContext);
            if (this.mSharedContext != null) {
                nativeSharedContext = this.mSharedContext.getNativeEglContext();
            }
            if (newSharedContext.getNativeEglContext() != nativeSharedContext) {
                isEglEnvChanged = true;
                this.mSharedContext = newSharedContext;
            }
        }
        if (this.mEglbase == null) {
            isEglEnvChanged = true;
        }
        IVideoProcessor processor = this.getCustomVideoPreprocessor();
        if (!isEglEnvChanged) {
            return;
        }
        try {
            if (this.mEglbase != null) {
                if (processor != null) {
                    processor.onGLEnvRelease();
                }
                this.mEglbase.release();
                this.mEglbase = null;
            }
            this.mEglbase = new EglBase14(this.mSharedContext, CONFIG_PIXEL_BUFFER);
            this.mEglbase.createDummyPbufferSurface();
            this.mEglbase.makeCurrent();
            this.mNeedRecreateTextureHelper = true;
            if (processor != null) {
                processor.onGLEnvInitiated();
            }
        }
        catch (RuntimeException e) {
            this.mEglbase.release();
            this.mEglbase = null;
            LogUtil.e(TAG, " failed to create mEglbase", e);
        }
    }

    void releaseEGL() {
        if (this.mEglbase == null) {
            return;
        }
        IVideoProcessor old_processor = this.getCustomVideoPreprocessor();
        if (old_processor != null) {
            old_processor.onGLEnvRelease();
        }
        this.mEglbase.makeCurrent();
        this.mEglbase.release();
        this.mEglbase = null;
    }

    static VideoPixelFormat get_frame_format(org.webrtc.VideoFrame frame) {
        VideoPixelFormat src_format = VideoPixelFormat.kVideoPixelFormatUnknown;
        if (frame.getBuffer() instanceof VideoFrame.TextureBuffer) {
            VideoFrame.TextureBuffer buffer = (VideoFrame.TextureBuffer)frame.getBuffer();
            src_format = buffer.getType() == VideoFrame.TextureBuffer.Type.OES ? VideoPixelFormat.kVideoPixelFormatTextureOES : VideoPixelFormat.kVideoPixelFormatTexture2D;
        } else if (frame.getBuffer() instanceof NV21Buffer) {
            src_format = VideoPixelFormat.kVideoPixelFormatNV21;
        } else if (frame.getBuffer() instanceof NV12Buffer) {
            src_format = VideoPixelFormat.kVideoPixelFormatNV21;
        } else if (frame.getBuffer() instanceof VideoFrame.I420Buffer) {
            src_format = VideoPixelFormat.kVideoPixelFormatI420;
        }
        return src_format;
    }

    static boolean check_require_format(VideoPixelFormat format) {
        return format == VideoPixelFormat.kVideoPixelFormatUnknown || format == VideoPixelFormat.kVideoPixelFormatI420 || format == VideoPixelFormat.kVideoPixelFormatTexture2D;
    }

    static boolean check_src_format(VideoPixelFormat format) {
        return format == VideoPixelFormat.kVideoPixelFormatTextureOES || format == VideoPixelFormat.kVideoPixelFormatTexture2D || format == VideoPixelFormat.kVideoPixelFormatI420;
    }

    static class TextureHelperRef {
        TextureHelper mTextureHelper = null;
        private int refCount;

        static TextureHelperRef create(int width, int height, EglBase eglbase) {
            TextureHelper t = TextureHelper.create("RTCVideoProcessorTextureHelper", eglbase.getEglBaseContext(), width, height);
            if (t == null) {
                return null;
            }
            return new TextureHelperRef(t);
        }

        TextureHelperRef(TextureHelper textureHelper) {
            this.mTextureHelper = textureHelper;
            this.refCount = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void retain() {
            TextureHelperRef textureHelperRef = this;
            synchronized (textureHelperRef) {
                ++this.refCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            TextureHelperRef textureHelperRef = this;
            synchronized (textureHelperRef) {
                if (--this.refCount == 0 && this.mTextureHelper != null) {
                    this.mTextureHelper.dispose();
                    this.mTextureHelper = null;
                }
            }
        }
    }

    static enum EngineType {
        BYTERTCENGINE,
        BYTERTCVIDEO,
        NONE;

    }
}

