/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.publicstream;

import com.ss.bytertc.engine.utils.LogUtil;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicStreaming {
    private static final String TAG = "PublicStreaming";
    private String action = "";
    private VideoConfig video;
    private AudioConfig audio;
    private Layout layout;
    private String roomId;
    public static final String ACTION_START = "started";
    public static final String ACTION_CHANGED = "layoutChanged";
    public static final String ACTION_STOPPED = "stopped";

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setVideo(VideoConfig video) {
        this.video = video;
    }

    public void setAudio(AudioConfig audio) {
        this.audio = audio;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public VideoConfig getVideo() {
        return this.video;
    }

    public AudioConfig getAudio() {
        return this.audio;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public JSONObject getPublicStreamMessage() {
        JSONObject videoConfigJson = new JSONObject();
        JSONObject audioConfigJson = new JSONObject();
        JSONObject layoutJson = new JSONObject();
        JSONObject canvasJson = new JSONObject();
        JSONArray regionsJson = new JSONArray();
        JSONObject publicStreamMeta = new JSONObject();
        JSONObject publicStreamJson = new JSONObject();
        try {
            videoConfigJson.put("fps", this.video.fps);
            videoConfigJson.put("bitrate", this.video.bitRate);
            videoConfigJson.put("width", this.video.width);
            videoConfigJson.put("height", this.video.height);
            audioConfigJson.put("bitrate", this.audio.bitRate);
            audioConfigJson.put("sampleRate", this.audio.sampleRate);
            audioConfigJson.put("channels", this.audio.channels);
            canvasJson.put("bgColor", (Object)this.layout.backgroundColor);
            canvasJson.put("bgImage", (Object)this.layout.backgroundImage);
            if (this.layout.regions != null) {
                for (Layout.Region region : this.layout.regions) {
                    JSONObject regionJson = new JSONObject();
                    JSONObject cropJson = new JSONObject();
                    regionJson.put("userId", (Object)region.userId);
                    regionJson.put("roomId", (Object)region.roomId);
                    regionJson.put("alternateImage", (Object)region.alternateImage);
                    regionJson.put("x", region.x);
                    regionJson.put("y", region.y);
                    regionJson.put("w", region.w);
                    regionJson.put("h", region.h);
                    regionJson.put("zorder", region.zorder);
                    regionJson.put("alpha", region.alpha);
                    regionJson.put("streamType", region.streamType);
                    regionJson.put("mediaType", region.mediaType);
                    regionJson.put("renderMode", region.renderMode);
                    cropJson.put("x", region.sourceCrop.LocationX);
                    cropJson.put("y", region.sourceCrop.LocationY);
                    cropJson.put("w", region.sourceCrop.WidthProportion);
                    cropJson.put("h", region.sourceCrop.HeightProportion);
                    regionJson.put("sourceCrop", (Object)cropJson);
                    regionsJson.put((Object)regionJson);
                }
            }
            layoutJson.put("canvas", (Object)canvasJson);
            layoutJson.put("regions", (Object)regionsJson);
            layoutJson.put("layoutMode", this.layout.layoutMode);
            layoutJson.put("interpolationMode", this.layout.interpolationMode);
            publicStreamMeta.put("video", (Object)videoConfigJson);
            publicStreamMeta.put("audio", (Object)audioConfigJson);
            publicStreamMeta.put("layout", (Object)layoutJson);
            publicStreamJson.put("type", (Object)"publicstream");
            publicStreamJson.put("roomId", (Object)this.roomId);
            publicStreamJson.put("action", (Object)this.action);
            publicStreamJson.put("publicStreamMeta", (Object)publicStreamMeta);
        }
        catch (JSONException e) {
            LogUtil.w(TAG, "get json message happen exception", e);
            return null;
        }
        return publicStreamJson;
    }

    public static PublicStreaming getDefualtPublicStreaming() {
        VideoConfig videoConfig = new VideoConfig();
        videoConfig.setFps(30).setKBitRate(500).setHeight(640).setWidth(360);
        AudioConfig audioConfig = new AudioConfig();
        audioConfig.setSampleRate(44100).setChannels(1).setKBitRate(16);
        Layout.Builder layoutBuilder = new Layout.Builder();
        layoutBuilder.backgroundColor("#000000").backgroundImage("");
        PublicStreaming publicStream = new PublicStreaming();
        publicStream.setAudio(audioConfig);
        publicStream.setVideo(videoConfig);
        publicStream.setLayout(layoutBuilder.build());
        return publicStream;
    }

    public static class Layout {
        private Region[] regions;
        private int interpolationMode;
        private int layoutMode;
        private String backgroundImage;
        private String backgroundColor;

        public Region[] getRegions() {
            return this.regions;
        }

        public void setRegions(Region[] regions) {
            this.regions = regions;
        }

        public int getInterpolationMode() {
            return this.interpolationMode;
        }

        public void setInterpolationMode(int interMode) {
            this.interpolationMode = interMode;
        }

        public int getLayoutMode() {
            return this.layoutMode;
        }

        public void setLayoutMode(int layoutMode) {
            this.layoutMode = layoutMode;
        }

        public String getBackgroundImage() {
            return this.backgroundImage;
        }

        public void setBackgroundImage(String bgImage) {
            this.backgroundImage = bgImage;
        }

        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public String toString() {
            JSONObject layoutJson = new JSONObject();
            JSONArray regionsJson = new JSONArray();
            JSONObject canvasJson = new JSONObject();
            try {
                if (this.regions != null) {
                    for (Region region : this.regions) {
                        JSONObject regionJson = new JSONObject();
                        JSONObject cropJson = new JSONObject();
                        regionJson.put("userId", (Object)region.userId);
                        regionJson.put("roomId", (Object)region.roomId);
                        regionJson.put("alternateImage", (Object)region.alternateImage);
                        regionJson.put("x", region.x);
                        regionJson.put("y", region.y);
                        regionJson.put("w", region.w);
                        regionJson.put("h", region.h);
                        regionJson.put("zorder", region.zorder);
                        regionJson.put("alpha", region.alpha);
                        regionJson.put("streamType", region.streamType);
                        regionJson.put("mediaType", region.mediaType);
                        regionJson.put("renderMode", region.renderMode);
                        cropJson.put("x", region.sourceCrop.LocationX);
                        cropJson.put("y", region.sourceCrop.LocationY);
                        cropJson.put("w", region.sourceCrop.WidthProportion);
                        cropJson.put("h", region.sourceCrop.HeightProportion);
                        regionJson.put("sourceCrop", (Object)cropJson);
                        regionsJson.put((Object)regionJson);
                    }
                }
                layoutJson.put("regions", (Object)regionsJson);
                canvasJson.put("bgColor", (Object)this.backgroundColor);
                canvasJson.put("bgImage", (Object)this.backgroundImage);
                layoutJson.put("canvas", (Object)canvasJson);
                layoutJson.put("layoutMode", this.layoutMode);
            }
            catch (JSONException e) {
                LogUtil.w(PublicStreaming.TAG, "create layout json message happens exception", e);
                return null;
            }
            return layoutJson.toString();
        }

        static /* synthetic */ Region[] access$002(Layout x0, Region[] x1) {
            x0.regions = x1;
            return x1;
        }

        public static class Region {
            private String userId;
            private String roomId;
            private String alternateImage;
            private double x;
            private double y;
            private double w;
            private double h;
            private int zorder;
            private double alpha;
            private int streamType;
            private int mediaType;
            private int renderMode;
            private SourceCrop sourceCrop = new SourceCrop();

            public Region userId(String uid) {
                this.userId = uid;
                return this;
            }

            public Region roomId(String roomId) {
                this.roomId = roomId;
                return this;
            }

            public Region zorder(int zorder) {
                this.zorder = zorder;
                return this;
            }

            public Region alpha(double alpha) {
                this.alpha = alpha;
                return this;
            }

            public Region mediaType(int mediaType) {
                this.mediaType = mediaType;
                return this;
            }

            public Region streamType(int streamType) {
                this.streamType = streamType;
                return this;
            }

            public Region renderMode(int renderMode) {
                this.renderMode = renderMode;
                return this;
            }

            public Region position(double x, double y) {
                this.x = x;
                this.y = y;
                return this;
            }

            public Region size(double width, double height) {
                this.w = width;
                this.h = height;
                return this;
            }

            public Region sourceCropPosition(double x, double y) {
                this.sourceCrop.LocationX = x;
                this.sourceCrop.LocationY = y;
                return this;
            }

            public Region sourceCropSize(double width, double height) {
                this.sourceCrop.WidthProportion = width;
                this.sourceCrop.HeightProportion = height;
                return this;
            }
        }

        public static class Builder {
            private ArrayList<Region> regions;
            private int interpolationMode = 0;
            private int layoutMode = 2;
            private String backgroundImage = "";
            private String backgroundColor = "#000000";

            public Builder addRegoin(Region region) {
                if (this.regions == null) {
                    this.regions = new ArrayList();
                }
                this.regions.add(region);
                return this;
            }

            public Builder interpolationMode(int mode) {
                this.interpolationMode = mode;
                return this;
            }

            public Builder layoutMode(int mode) {
                this.layoutMode = mode;
                return this;
            }

            public Builder backgroundImage(String bgImage) {
                this.backgroundImage = bgImage;
                return this;
            }

            public Builder backgroundColor(String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Layout build() {
                Layout layout = new Layout();
                if (this.regions != null) {
                    Layout.access$002(layout, this.regions.toArray(new Region[this.regions.size()]));
                }
                layout.interpolationMode = this.interpolationMode;
                layout.layoutMode = this.layoutMode;
                layout.backgroundImage = this.backgroundImage;
                layout.backgroundColor = this.backgroundColor;
                return layout;
            }
        }
    }

    public static class SourceCrop {
        private double LocationX;
        private double LocationY;
        private double WidthProportion;
        private double HeightProportion;

        public SourceCrop setLocationX(double x) {
            this.LocationX = x;
            return this;
        }

        public SourceCrop setLocationY(double y) {
            this.LocationY = y;
            return this;
        }

        public SourceCrop setWidthProportion(double w) {
            this.WidthProportion = w;
            return this;
        }

        public SourceCrop setHeightProportion(double h) {
            this.HeightProportion = h;
            return this;
        }
    }

    public static class AudioConfig {
        private int bitRate = 16000;
        private int sampleRate = 44100;
        private int channels = 1;

        public AudioConfig setKBitRate(int kBitRate) {
            this.bitRate = kBitRate * 1000;
            return this;
        }

        public AudioConfig setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public AudioConfig setChannels(int channels) {
            this.channels = channels;
            return this;
        }
    }

    public static class VideoConfig {
        private int fps = 30;
        private int bitRate = 500000;
        private int width = 360;
        private int height = 640;

        public VideoConfig setFps(int fps) {
            this.fps = fps;
            return this;
        }

        public VideoConfig setKBitRate(int kBitRate) {
            this.bitRate = kBitRate * 1000;
            return this;
        }

        public VideoConfig setWidth(int width) {
            this.width = width;
            return this;
        }

        public VideoConfig setHeight(int height) {
            this.height = height;
            return this;
        }
    }
}

