/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.opengl.EGLContext;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import com.ss.bytertc.engine.utils.LogUtil;
import java.nio.FloatBuffer;
import java.util.concurrent.Callable;
import org.webrtc.EglBase;
import org.webrtc.GlShader;
import org.webrtc.GlTextureFrameBuffer;
import org.webrtc.GlUtil;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;

public class GLHepler {
    private final String TAG = "GLHepler";
    private GlShader mGlShader;
    private EglBase mEglBase;
    private Handler handler;
    private boolean mBInit = false;
    private GlTextureFrameBuffer textureFrameBuffer;
    private int frameBufferId = 0;
    private final String mVertorShader = "attribute vec4 vPosition;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\n\nvoid main(){gl_Position = vPosition;\ntextureCoordinate = inputTextureCoordinate;\n}\n";
    private final String mFragmentShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 textureCoordinate;\nuniform samplerExternalOES s_texture;\nvoid main() {  gl_FragColor = texture2D( s_texture, textureCoordinate );\n}";
    private static final FloatBuffer DEVICE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer TEXTURE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private VideoFrame.TextureBuffer.Type shaderTextureType;
    private GlShader shader;
    private boolean released = false;

    public static GLHepler create(final String threadName, final EGLContext eglContext) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<GLHepler>(){

            @Override
            public GLHepler call() {
                try {
                    return new GLHepler(eglContext, handler);
                }
                catch (RuntimeException var2) {
                    LogUtil.e("TextureHelper", threadName + " create failure", var2);
                    return null;
                }
            }
        });
    }

    private GLHepler(EGLContext eglContext, Handler handler) {
        this.handler = handler;
        this.mEglBase = EglBase.createEgl14(eglContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.mEglBase.createDummyPbufferSurface();
            this.mEglBase.makeCurrent();
        }
        catch (RuntimeException var4) {
            this.mEglBase.release();
            handler.getLooper().quit();
            throw var4;
        }
        GlTextureFrameBuffer textureFrameBuffer = new GlTextureFrameBuffer(6408);
        int[] frameBuffers = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
        this.frameBufferId = frameBuffers[0];
        this.threadChecker.detachThread();
    }

    private void initShader(VideoFrame.TextureBuffer.Type textureType) {
        if (this.shader != null) {
            this.shader.release();
        }
        if (this.mBInit) {
            return;
        }
        this.mBInit = true;
        this.shaderTextureType = textureType;
        this.shader = new GlShader("attribute vec4 vPosition;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\n\nvoid main(){gl_Position = vPosition;\ntextureCoordinate = inputTextureCoordinate;\n}\n", "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 textureCoordinate;\nuniform samplerExternalOES s_texture;\nvoid main() {  gl_FragColor = texture2D( s_texture, textureCoordinate );\n}");
        this.shader.useProgram();
        GLES20.glUniform1i((int)this.shader.getUniformLocation("s_texture"), (int)0);
        GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        this.shader.setVertexAttribArray("vPosition", 2, DEVICE_RECTANGLE);
        this.shader.setVertexAttribArray("inputTextureCoordinate", 2, TEXTURE_RECTANGLE);
    }

    public void deliverToTexture2D(int width, int height, int srcTextureId, int dstTextureId, float[] transformMatrix) {
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> {
            long mill = System.currentTimeMillis();
            this.threadChecker.checkIsOnValidThread();
            if (this.released) {
                throw new IllegalStateException("YuvConverter.convert called on released object");
            }
            if (!this.mBInit) {
                this.initShader(VideoFrame.TextureBuffer.Type.OES);
                this.shader.useProgram();
                GLES20.glBindFramebuffer((int)36160, (int)this.frameBufferId);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)dstTextureId, (int)0);
            }
            this.shader.useProgram();
            GLES20.glBindFramebuffer((int)36160, (int)this.frameBufferId);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)dstTextureId, (int)0);
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)36197, (int)srcTextureId);
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GLES20.glBindTexture((int)36197, (int)0);
            LogUtil.i("opnngl ToTexture2D", "usetime:" + (System.currentTimeMillis() - mill));
        });
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.released = true;
        if (this.shader != null) {
            this.shader.release();
        }
        this.textureFrameBuffer.release();
    }
}

