/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.GLES20;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;

@RequiresApi(api=17)
public class GLUtils {
    private static int[] defaultEGLConfAttr = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12344};
    private static int[] ctxAttr = new int[]{12440, 2, 12344};

    public static EGLDisplay getEglDisplay() {
        EGLDisplay eglDisplay = EGL14.eglGetDisplay((int)0);
        if (eglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("Unable to get EGL14 display: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)eglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            throw new RuntimeException("Unable to initialize EGL14: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        return eglDisplay;
    }

    public static EGLConfig getEglConfig(EGLDisplay eglDisplay) {
        return GLUtils.getEglConfig(eglDisplay, defaultEGLConfAttr);
    }

    public static EGLConfig getEglConfig(EGLDisplay eglDisplay, int[] configAttributes) {
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)eglDisplay, (int[])configAttributes, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0)) {
            throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        if (numConfigs[0] <= 0) {
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        EGLConfig eglConfig = configs[0];
        if (eglConfig == null) {
            throw new RuntimeException("eglChooseConfig returned null");
        }
        return eglConfig;
    }

    @Nullable
    public static EGLContext createEglContext(EGLDisplay eglDisplay, EGLConfig eglConfig, EGLContext context) {
        EGLContext eglContext = EGL14.eglCreateContext((EGLDisplay)eglDisplay, (EGLConfig)eglConfig, (EGLContext)context, (int[])ctxAttr, (int)0);
        return eglContext;
    }

    public static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }
}

