/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.Nullable;
import com.ss.bytertc.engine.utils.LogUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.microedition.khronos.egl.EGLContext;
import org.webrtc.EglBase;
import org.webrtc.GlRectDrawer;
import org.webrtc.GlUtil;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;
import org.webrtc.YuvHelper;

public class TextureHelper {
    private static final String TAG = "TextureHelper";
    public static final int FORMAT_TEXTURE_2D = 10;
    public static final int FORMAT_TEXTURE_OES = 11;
    private static final int TEXTURE_MAX_COUNT = 4;
    private final Handler mHandler;
    private final EglBase mEglBase;
    private boolean mIsQuitting;
    private boolean mIsRelease;
    private boolean mIsTextureInUse;
    private YuvUploader mYuvUploader;
    private YuvConverter mYuvConverter;
    private GlRectDrawer mTextureDrawer;
    private int mFrameBufferId;
    private int mWidth;
    private int mHeight;
    private int mTextureCnt = 0;
    private List<Integer> mTextureFreeQueue = new LinkedList<Integer>();
    private List<Integer> mTextureUsedQueue = new LinkedList<Integer>();
    private static float[] TEX_MATRIX = new float[16];
    private static float[] YUV_TEX_MATRIX = new float[16];

    public static TextureHelper create(String threadName, EGLContext sharedContext, int width, int height) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, () -> {
            try {
                return new TextureHelper(sharedContext, handler, width, height);
            }
            catch (RuntimeException var2) {
                LogUtil.e(TAG, threadName + " create failure", var2);
                return null;
            }
        });
    }

    public static TextureHelper create(String threadName, android.opengl.EGLContext sharedContext, int width, int height) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, () -> {
            try {
                return new TextureHelper(sharedContext, handler, width, height);
            }
            catch (RuntimeException var2) {
                LogUtil.e(TAG, threadName + " create failure", var2);
                return null;
            }
        });
    }

    public static TextureHelper create(String threadName, EglBase.Context sharedContext, int width, int height) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, () -> {
            try {
                return new TextureHelper(sharedContext, handler, width, height);
            }
            catch (RuntimeException var2) {
                LogUtil.e(TAG, threadName + " create failure", var2);
                return null;
            }
        });
    }

    private TextureHelper(Object context, Handler handler, int width, int height) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("TextureHelper must be created on the handler thread");
        }
        this.mWidth = width;
        this.mHeight = height;
        this.mHandler = handler;
        Matrix.setIdentityM((float[])TEX_MATRIX, (int)0);
        Matrix.setIdentityM((float[])YUV_TEX_MATRIX, (int)0);
        Matrix.translateM((float[])YUV_TEX_MATRIX, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
        Matrix.scaleM((float[])YUV_TEX_MATRIX, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
        Matrix.translateM((float[])YUV_TEX_MATRIX, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        if (context instanceof EGLContext) {
            this.mEglBase = EglBase.createEgl10((EGLContext)context, EglBase.CONFIG_PIXEL_BUFFER);
        } else if (context instanceof android.opengl.EGLContext) {
            this.mEglBase = EglBase.createEgl14((android.opengl.EGLContext)context, EglBase.CONFIG_PIXEL_BUFFER);
        } else if (context instanceof EglBase.Context) {
            this.mEglBase = EglBase.create((EglBase.Context)context);
        } else {
            throw new RuntimeException("unknown shareContext:" + context);
        }
        try {
            this.mEglBase.createPbufferSurface(this.mWidth, this.mHeight);
            this.mEglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.mEglBase.release();
            handler.getLooper().quit();
            throw e;
        }
        int[] frameBuffers = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
        this.mFrameBufferId = frameBuffers[0];
        this.mTextureDrawer = new GlRectDrawer();
        this.mYuvUploader = new YuvUploader();
        GlUtil.checkNoGLES2Error("TextureHelper construct");
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void drawTexture(final int textureType, final int srcTextureId, final int targetTextureId) {
        ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, new Runnable(){

            @Override
            public void run() {
                if (TextureHelper.this.mTextureDrawer == null) {
                    TextureHelper.this.mTextureDrawer = new GlRectDrawer();
                }
                GlUtil.checkNoGLES2Error("TextureHelper construct");
                GLES20.glBindFramebuffer((int)36160, (int)TextureHelper.this.mFrameBufferId);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)targetTextureId, (int)0);
                switch (textureType) {
                    case 10: {
                        TextureHelper.this.mTextureDrawer.drawRgb(srcTextureId, TEX_MATRIX, TextureHelper.this.mWidth, TextureHelper.this.mHeight, 0, 0, TextureHelper.this.mWidth, TextureHelper.this.mHeight);
                        break;
                    }
                    case 11: {
                        TextureHelper.this.mTextureDrawer.drawOes(srcTextureId, TEX_MATRIX, TextureHelper.this.mWidth, TextureHelper.this.mHeight, 0, 0, TextureHelper.this.mWidth, TextureHelper.this.mHeight);
                        break;
                    }
                    default: {
                        LogUtil.e(TextureHelper.TAG, "draw texture type error");
                    }
                }
                GLES20.glBindTexture((int)3553, (int)0);
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GLES20.glFinish();
                GlUtil.checkNoGLES2Error("TextureHelper drawTexture");
            }
        });
    }

    public void yuvToTexture(final VideoFrame.I420Buffer i420Buffer, final int targetTextureId) {
        ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, new Runnable(){

            @Override
            public void run() {
                if (TextureHelper.this.mTextureDrawer == null || TextureHelper.this.mYuvUploader == null) {
                    throw new IllegalStateException("mTextureDrawer and mYuvUploader can not null.");
                }
                GlUtil.checkNoGLES2Error("TextureHelper construct");
                GLES20.glBindFramebuffer((int)36160, (int)TextureHelper.this.mFrameBufferId);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)targetTextureId, (int)0);
                TextureHelper.this.mYuvUploader.uploadFromBuffer(i420Buffer);
                TextureHelper.this.mTextureDrawer.drawYuv(TextureHelper.this.mYuvUploader.getYuvTextures(), YUV_TEX_MATRIX, TextureHelper.this.mWidth, TextureHelper.this.mHeight, 0, 0, TextureHelper.this.mWidth, TextureHelper.this.mHeight);
                GLES20.glBindTexture((int)3553, (int)0);
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GLES20.glFinish();
                GlUtil.checkNoGLES2Error("TextureHelper drawTexture");
            }
        });
    }

    public synchronized VideoFrame.I420Buffer textureToYuv(final VideoFrame.TextureBuffer textureBuffer) {
        final VideoFrame.I420Buffer[] result = new VideoFrame.I420Buffer[1];
        ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, new Runnable(){

            @Override
            public void run() {
                TextureHelper.this.mIsTextureInUse = true;
                if (TextureHelper.this.mYuvConverter == null) {
                    TextureHelper.this.mYuvConverter = new YuvConverter();
                }
                if (TextureHelper.this.mTextureDrawer == null) {
                    TextureHelper.this.mTextureDrawer = new GlRectDrawer();
                }
                result[0] = TextureHelper.this.mYuvConverter.convert(textureBuffer);
                TextureHelper.this.mIsTextureInUse = false;
                if (TextureHelper.this.mIsQuitting) {
                    TextureHelper.this.release();
                }
            }
        });
        return result[0];
    }

    public int dequeueTexture() {
        int[] textureId = new int[1];
        ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, () -> {
            if (this.mTextureFreeQueue != null) {
                if (this.mTextureFreeQueue.size() == 0) {
                    textureId[0] = this.generateTexture(3553, this.mWidth, this.mHeight);
                    if (textureId[0] > 0) {
                        this.mTextureUsedQueue.add(textureId[0]);
                    }
                } else {
                    textureId[0] = this.mTextureFreeQueue.get(0);
                    this.mTextureFreeQueue.remove(0);
                    this.mTextureUsedQueue.add(textureId[0]);
                }
            }
        });
        return textureId[0];
    }

    public void queueTexture(int textureId) {
        this.mHandler.post(() -> {
            if (this.mTextureUsedQueue != null && this.mTextureUsedQueue.contains(textureId)) {
                this.mTextureUsedQueue.remove(new Integer(textureId));
                if (this.mTextureFreeQueue != null) {
                    this.mTextureFreeQueue.add(textureId);
                }
            }
        });
    }

    public void releaseTextureID(int textureID) {
        if (textureID <= 0 || this.mIsQuitting || this.mIsRelease) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, () -> GLES20.glDeleteTextures((int)1, (int[])new int[]{textureID}, (int)0));
    }

    private int generateTexture(int type, int width, int height) {
        if (this.mTextureCnt == 4) {
            return 0;
        }
        return ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, () -> {
            int textureId = GlUtil.generateTexture(type);
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)textureId);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
            GLES20.glBindTexture((int)3553, (int)0);
            int error = GLES20.glGetError();
            if (error != 0) {
                return 0;
            }
            ++this.mTextureCnt;
            return textureId;
        });
    }

    private void release() {
        if (this.mHandler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (!this.mIsTextureInUse && this.mIsQuitting) {
            this.mIsRelease = true;
            if (this.mYuvConverter != null) {
                this.mYuvConverter.release();
            }
            if (this.mYuvUploader != null) {
                this.mYuvUploader.release();
            }
            if (this.mTextureFreeQueue != null && this.mTextureFreeQueue.size() > 0) {
                for (Integer textureId : this.mTextureFreeQueue) {
                    GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
                }
            }
            this.mTextureFreeQueue.clear();
            if (this.mTextureUsedQueue != null && this.mTextureUsedQueue.size() > 0) {
                for (Integer textureId : this.mTextureUsedQueue) {
                    GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
                }
            }
        } else {
            throw new IllegalStateException("Unexpected release.");
        }
        this.mTextureUsedQueue.clear();
        GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.mFrameBufferId}, (int)0);
        this.mFrameBufferId = 0;
        this.mEglBase.release();
        this.mHandler.getLooper().quit();
    }

    public synchronized void dispose() {
        LogUtil.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, () -> {
            this.mIsQuitting = true;
            if (!this.mIsTextureInUse) {
                this.release();
            }
        });
    }

    public EglBase.Context getEglBaseContext() {
        if (this.mEglBase != null) {
            return this.mEglBase.getEglBaseContext();
        }
        return null;
    }

    public long getNativeEglContext() {
        if (this.mEglBase != null) {
            return this.mEglBase.getEglBaseContext().getNativeEglContext();
        }
        return 0L;
    }

    public void post(Runnable run) {
        if (this.mHandler != null) {
            this.mHandler.post(run);
        }
    }

    static class YuvUploader {
        @Nullable
        private ByteBuffer copyBuffer;
        @Nullable
        private int[] yuvTextures;

        YuvUploader() {
        }

        @Nullable
        public int[] uploadYuvData(int width, int height, int[] strides, ByteBuffer[] planes) {
            int i;
            int[] planeWidths = new int[]{width, width / 2, width / 2};
            int[] planeHeights = new int[]{height, height / 2, height / 2};
            int copyCapacityNeeded = 0;
            for (i = 0; i < 3; ++i) {
                if (strides[i] <= planeWidths[i]) continue;
                copyCapacityNeeded = Math.max(copyCapacityNeeded, planeWidths[i] * planeHeights[i]);
            }
            if (copyCapacityNeeded > 0 && (this.copyBuffer == null || this.copyBuffer.capacity() < copyCapacityNeeded)) {
                this.copyBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (i = 0; i < 3; ++i) {
                    this.yuvTextures[i] = GlUtil.generateTexture(3553);
                }
            }
            for (i = 0; i < 3; ++i) {
                ByteBuffer packedByteBuffer;
                GLES20.glPixelStorei((int)3317, (int)1);
                GLES20.glActiveTexture((int)(33984 + i));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[i]);
                if (strides[i] == planeWidths[i]) {
                    packedByteBuffer = planes[i];
                } else {
                    YuvHelper.copyPlane(planes[i], strides[i], this.copyBuffer, planeWidths[i], planeWidths[i], planeHeights[i]);
                    packedByteBuffer = this.copyBuffer;
                }
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)planeWidths[i], (int)planeHeights[i], (int)0, (int)6409, (int)5121, (Buffer)packedByteBuffer);
            }
            return this.yuvTextures;
        }

        @Nullable
        public int[] uploadFromBuffer(VideoFrame.I420Buffer buffer) {
            int[] strides = new int[]{buffer.getStrideY(), buffer.getStrideU(), buffer.getStrideV()};
            ByteBuffer[] planes = new ByteBuffer[]{buffer.getDataY(), buffer.getDataU(), buffer.getDataV()};
            return this.uploadYuvData(buffer.getWidth(), buffer.getHeight(), strides, planes);
        }

        @Nullable
        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            this.copyBuffer = null;
            if (this.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])this.yuvTextures, (int)0);
                this.yuvTextures = null;
            }
        }
    }
}

