/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.video;

import android.util.SparseArray;
import com.ss.bytertc.engine.VideoStreamDescription;
import com.ss.bytertc.engine.data.RTCData;
import com.ss.bytertc.engine.video.VideoPreset;

public class VideoProfile {
    private static SparseArray<VideoPreset> sVideoProfileMap = new SparseArray();

    public static VideoPreset getVideoVideoPresetById(int profileId) {
        VideoPreset videoPreset = (VideoPreset)sVideoProfileMap.get(profileId);
        if (videoPreset == null) {
            videoPreset = (VideoPreset)sVideoProfileMap.get(33);
        }
        return videoPreset;
    }

    public static VideoPreset getVideoVideoPreset() {
        int maxWidth = 0;
        int maxHeight = 0;
        int maxFps = 0;
        int maxBw = 0;
        for (VideoStreamDescription description : RTCData.instance().getVideoStreamDescriptions()) {
            if ((Integer)description.videoSize.first > maxWidth) {
                maxWidth = (Integer)description.videoSize.first;
            }
            if ((Integer)description.videoSize.second > maxHeight) {
                maxHeight = (Integer)description.videoSize.second;
            }
            if (description.frameRate > maxFps) {
                maxFps = description.frameRate;
            }
            if (description.maxKbps <= maxBw) continue;
            maxBw = description.maxKbps;
        }
        return new VideoPreset(maxWidth, maxHeight, maxFps, maxBw);
    }

    public static void addVideoVideoPreset(int profileId, VideoPreset videoPreset) {
        sVideoProfileMap.put(profileId, (Object)videoPreset);
    }

    public static SparseArray<VideoPreset> getsVideoProfileMap() {
        return sVideoProfileMap;
    }

    static {
        sVideoProfileMap.put(0, (Object)new VideoPreset(160, 120, 15, 65));
        sVideoProfileMap.put(2, (Object)new VideoPreset(120, 120, 15, 50));
        sVideoProfileMap.put(10, (Object)new VideoPreset(320, 180, 15, 140));
        sVideoProfileMap.put(12, (Object)new VideoPreset(180, 180, 15, 100));
        sVideoProfileMap.put(13, (Object)new VideoPreset(240, 180, 15, 120));
        sVideoProfileMap.put(14, (Object)new VideoPreset(240, 180, 15, 240));
        sVideoProfileMap.put(20, (Object)new VideoPreset(320, 240, 15, 200));
        sVideoProfileMap.put(21, (Object)new VideoPreset(320, 240, 15, 360));
        sVideoProfileMap.put(22, (Object)new VideoPreset(240, 240, 15, 140));
        sVideoProfileMap.put(23, (Object)new VideoPreset(424, 240, 15, 220));
        sVideoProfileMap.put(30, (Object)new VideoPreset(640, 360, 15, 600));
        sVideoProfileMap.put(32, (Object)new VideoPreset(360, 360, 15, 260));
        sVideoProfileMap.put(33, (Object)new VideoPreset(640, 360, 30, 600));
        sVideoProfileMap.put(34, (Object)new VideoPreset(640, 360, 15, 800));
        sVideoProfileMap.put(35, (Object)new VideoPreset(360, 360, 30, 400));
        sVideoProfileMap.put(36, (Object)new VideoPreset(480, 360, 15, 320));
        sVideoProfileMap.put(37, (Object)new VideoPreset(480, 360, 30, 490));
        sVideoProfileMap.put(40, (Object)new VideoPreset(640, 480, 15, 500));
        sVideoProfileMap.put(42, (Object)new VideoPreset(480, 480, 15, 400));
        sVideoProfileMap.put(43, (Object)new VideoPreset(640, 480, 30, 750));
        sVideoProfileMap.put(45, (Object)new VideoPreset(480, 480, 30, 600));
        sVideoProfileMap.put(46, (Object)new VideoPreset(848, 480, 15, 1200));
        sVideoProfileMap.put(47, (Object)new VideoPreset(848, 480, 30, 800));
        sVideoProfileMap.put(48, (Object)new VideoPreset(848, 480, 30, 930));
        sVideoProfileMap.put(50, (Object)new VideoPreset(1280, 720, 15, 1130));
        sVideoProfileMap.put(52, (Object)new VideoPreset(1280, 720, 30, 1710));
        sVideoProfileMap.put(54, (Object)new VideoPreset(960, 720, 15, 910));
        sVideoProfileMap.put(55, (Object)new VideoPreset(960, 720, 30, 1380));
    }
}

