/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.video;

import android.graphics.Matrix;
import android.opengl.EGLContext;
import com.ss.bytertc.engine.video.ITextureBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.FilterType;
import org.webrtc.RendererCommon;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;

public class WebrtcTextureBufferWrapper
implements ITextureBuffer,
VideoFrame.TextureBuffer {
    TextureBufferImpl webrtcTextureBuffer;

    public WebrtcTextureBufferWrapper(TextureBufferImpl webrtcTextureBuffer) {
        this.webrtcTextureBuffer = webrtcTextureBuffer;
    }

    @Override
    public int getTypeGlTarget() {
        if (this.webrtcTextureBuffer == null) {
            return 0;
        }
        return this.webrtcTextureBuffer.getType().getGlTarget();
    }

    @Override
    @CalledByNative
    public int getTextureId() {
        if (this.webrtcTextureBuffer == null) {
            return 0;
        }
        return this.webrtcTextureBuffer.getTextureId();
    }

    @Override
    public Matrix getTransformMatrix() {
        if (this.webrtcTextureBuffer == null) {
            return new Matrix();
        }
        return this.webrtcTextureBuffer.getTransformMatrix();
    }

    @Override
    @CalledByNative
    public float[] nativeGetTransFormMatrix() {
        if (this.webrtcTextureBuffer == null) {
            return new float[]{0.0f};
        }
        return RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.webrtcTextureBuffer.getTransformMatrix());
    }

    @Override
    public EGLContext getEglContext() {
        if (this.webrtcTextureBuffer == null) {
            return null;
        }
        return this.webrtcTextureBuffer.getEglContext();
    }

    @Override
    public long getNativeEglContext() {
        if (this.webrtcTextureBuffer == null) {
            return 0L;
        }
        return this.webrtcTextureBuffer.getNativeEglContext();
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        if (this.webrtcTextureBuffer == null) {
            return VideoFrame.TextureBuffer.Type.OES;
        }
        return this.webrtcTextureBuffer.getType();
    }

    @Override
    public int getWidth() {
        if (this.webrtcTextureBuffer == null) {
            return 0;
        }
        return this.webrtcTextureBuffer.getWidth();
    }

    @Override
    public int getHeight() {
        if (this.webrtcTextureBuffer == null) {
            return 0;
        }
        return this.webrtcTextureBuffer.getHeight();
    }

    @Override
    public FilterType getScaleFilter() {
        return FilterType.Origin;
    }

    @Override
    public int getUnscaledWidth() {
        if (this.webrtcTextureBuffer == null) {
            return 0;
        }
        return this.webrtcTextureBuffer.getUnscaledWidth();
    }

    @Override
    public int getUnscaledHeight() {
        if (this.webrtcTextureBuffer == null) {
            return 0;
        }
        return this.webrtcTextureBuffer.getUnscaledHeight();
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        if (this.webrtcTextureBuffer == null) {
            return null;
        }
        return this.webrtcTextureBuffer.toI420();
    }

    @Override
    public void retain() {
        if (this.webrtcTextureBuffer == null) {
            return;
        }
        this.webrtcTextureBuffer.retain();
    }

    @Override
    public void release() {
        if (this.webrtcTextureBuffer == null) {
            return;
        }
        this.webrtcTextureBuffer.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScaleWithFilter(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int scaleFilter) {
        if (this.webrtcTextureBuffer == null) {
            return null;
        }
        return this.webrtcTextureBuffer.cropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight);
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        if (this.webrtcTextureBuffer == null) {
            return null;
        }
        return this.webrtcTextureBuffer.cropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight);
    }

    @Override
    public VideoFrame.Buffer scaleAndFill(int dstWidth, int dstHeight, int offsetX, int offsetY) {
        if (this.webrtcTextureBuffer == null) {
            return null;
        }
        return this.webrtcTextureBuffer.scaleAndFill(dstWidth, dstHeight, offsetX, offsetY);
    }
}

