/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.video.builder;

import com.ss.bytertc.engine.data.ColorSpace;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.data.VideoRotation;
import com.ss.bytertc.engine.video.VideoFrame;
import com.ss.bytertc.engine.video.impl.DirectBufferVideoFrame;
import java.nio.ByteBuffer;

public class CpuBufferVideoFrameBuilder {
    private final DirectBufferVideoFrame frame;

    public CpuBufferVideoFrameBuilder(VideoPixelFormat pixelFormat) {
        this.frame = new DirectBufferVideoFrame(pixelFormat);
    }

    public CpuBufferVideoFrameBuilder setTimeStampUs(long timeStampUs) {
        this.frame.setTimeStampUs(timeStampUs);
        return this;
    }

    public CpuBufferVideoFrameBuilder setWidth(int width) {
        this.frame.setWidth(width);
        return this;
    }

    public CpuBufferVideoFrameBuilder setHeight(int height) {
        this.frame.setHeight(height);
        return this;
    }

    public CpuBufferVideoFrameBuilder setRotation(VideoRotation rotation) {
        this.frame.setRotation(rotation);
        return this;
    }

    public CpuBufferVideoFrameBuilder setColorSpace(ColorSpace colorSpace) {
        this.frame.setColorSpace(colorSpace);
        return this;
    }

    public CpuBufferVideoFrameBuilder setPlaneData(int planeIndex, ByteBuffer buffer) {
        this.frame.setPlaneData(planeIndex, buffer);
        return this;
    }

    public CpuBufferVideoFrameBuilder setPlaneStride(int planeIndex, int stride) {
        this.frame.setPlaneStride(planeIndex, stride);
        return this;
    }

    public CpuBufferVideoFrameBuilder setExternalDataInfo(ByteBuffer externalDataInfo) {
        this.frame.setExternalDataInfo(externalDataInfo);
        return this;
    }

    public CpuBufferVideoFrameBuilder setSupplementaryInfo(ByteBuffer supplementaryInfo) {
        this.frame.setSupplementaryInfo(supplementaryInfo);
        return this;
    }

    public CpuBufferVideoFrameBuilder setReleaseCallback(Runnable releaseCallback) {
        this.frame.setReleaseCallback(releaseCallback);
        return this;
    }

    public VideoFrame build() {
        return this.frame;
    }
}

