/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import android.os.Build;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.webrtc.GlShader;
import org.webrtc.GlUtil;

public class GlClearWorkaround {
    private static final String DEFAULT_VERTEX_SHADER_STRING = "#ifdef GL_ES\nprecision mediump float;\n#endif\nuniform float u_clear_depth;\nattribute vec4 a_position;\nvoid main(void) {\n  gl_Position = vec4(a_position.x, a_position.y, u_clear_depth, 1.0);\n}\n";
    private static final String DEFAULT_FRAGMENT_SHADER_STRING = "#ifdef GL_ES\nprecision mediump float;\n#endif\nuniform vec4 u_clear_color;\nvoid main(void) {\n  gl_FragColor = u_clear_color;\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUFFER = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private GlShader currentShader;
    private boolean mHasInit = false;

    public synchronized void init() {
        this.mHasInit = true;
    }

    public synchronized void release() {
        this.mHasInit = false;
        if (this.currentShader != null) {
            this.currentShader.release();
            this.currentShader = null;
        }
    }

    public synchronized void clear(int width, int height, int mask, float clear_color_red, float clear_color_green, float clear_color_blue, float clear_color_alpha, float clear_depth_value, int clear_stencil_value) {
        if (!this.mHasInit) {
            return;
        }
        if (this.currentShader == null) {
            this.prepareShader();
        }
        this.currentShader.useProgram();
        GLES20.glUniform1f((int)this.currentShader.getUniformLocation("u_clear_depth"), (float)clear_depth_value);
        GLES20.glUniform4f((int)this.currentShader.getUniformLocation("u_clear_color"), (float)clear_color_red, (float)clear_color_green, (float)clear_color_blue, (float)clear_color_alpha);
        if ((mask & 0x4000) == 0) {
            GLES20.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
        GlUtil.checkNoGLES2Error("before depth test");
        if ((mask & 0x100) != 0) {
            GLES20.glEnable((int)2929);
            GLES20.glDepthFunc((int)519);
        } else {
            GLES20.glDisable((int)2929);
            GLES20.glDepthFunc((int)512);
        }
        GlUtil.checkNoGLES2Error("before stencil test");
        if ((mask & 0x400) != 0) {
            GLES20.glEnable((int)2960);
            GLES20.glStencilFunc((int)519, (int)clear_stencil_value, (int)255);
            GLES20.glStencilOp((int)7680, (int)7680, (int)7681);
        } else {
            GLES20.glDisable((int)2960);
            GLES20.glStencilOp((int)7680, (int)7680, (int)7680);
            GLES20.glStencilMask((int)0);
        }
        GlUtil.checkNoGLES2Error("before clear workaround");
        GLES20.glDisable((int)2884);
        GLES20.glDisable((int)3042);
        GLES20.glDisable((int)32823);
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.checkNoGLES2Error("after clear workaround");
    }

    private void prepareShader() {
        GlShader shader;
        this.currentShader = shader = this.createShader();
        shader.useProgram();
        GlUtil.checkNoGLES2Error("Create shader");
        int inPosLocation = shader.getAttribLocation("a_position");
        GLES20.glEnableVertexAttribArray((int)inPosLocation);
        GLES20.glVertexAttribPointer((int)inPosLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_BUFFER);
        GlUtil.checkNoGLES2Error("Prepare shader");
    }

    private GlShader createShader() {
        return new GlShader(DEFAULT_VERTEX_SHADER_STRING, DEFAULT_FRAGMENT_SHADER_STRING);
    }

    public static WORKAROUND_STATUS isNeedWorkaround() {
        if (Build.VERSION.SDK_INT < 23) {
            return WORKAROUND_STATUS.kStatusEnable;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return WORKAROUND_STATUS.kStatusDisable;
        }
        String glVendor = GLES20.glGetString((int)7936);
        if ((glVendor = glVendor.toLowerCase()).contains("mali") || glVendor.contains("arm")) {
            return WORKAROUND_STATUS.kStatusEnable;
        }
        return WORKAROUND_STATUS.kStatusDisable;
    }

    public static enum WORKAROUND_STATUS {
        kStatusUnknown,
        kStatusEnable,
        kStatusDisable;

    }
}

