/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import android.support.annotation.Nullable;
import android.util.Log;
import com.bytedance.realx.base.RXLogging;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.webrtc.FilterType;
import org.webrtc.GlShader;
import org.webrtc.GlUtil;
import org.webrtc.RendererCommon;

public class GlGenericDrawer
implements RendererCommon.GlDrawer {
    private static final String INPUT_VERTEX_COORDINATE_NAME = "in_pos";
    private static final String INPUT_TEXTURE_COORDINATE_NAME = "in_tc";
    private static final String TEXTURE_MATRIX_NAME = "tex_mat";
    private static final String TAR_TEX_SIZE_NAME = "tar_tex_size";
    private static final String ORI_TEX_SIZE_NAME = "ori_tex_size";
    private static final String DEFAULT_VERTEX_SHADER_STRING = "varying vec2 tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\nuniform mat4 tex_mat;\nvoid main() {\n  gl_Position = in_pos;\n  tc = (tex_mat * in_tc).xy;\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUFFER = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEXTURE_BUFFER = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private final String genericFragmentSource;
    private final String vertexShader;
    private final ShaderCallbacks shaderCallbacks;
    @Nullable
    private ShaderType currentShaderType;
    @Nullable
    private GlShader currentShader;
    private int inPosLocation;
    private int inTcLocation;
    private int texMatrixLocation;
    private int tarTexSizeLocation;
    private int oriTexSizeLocation;
    @Nullable
    private FilterType currentScaleFilter;

    static String createFragmentShaderString(String genericFragmentSource, ShaderType shaderType, FilterType scaleFilter) {
        StringBuilder stringBuilder = new StringBuilder();
        if (shaderType == ShaderType.OES) {
            stringBuilder.append("#extension GL_OES_EGL_image_external : require\n");
        }
        stringBuilder.append("precision mediump float;\n");
        stringBuilder.append("varying vec2 tc;\n");
        if (scaleFilter == FilterType.Bilinear) {
            stringBuilder.append("uniform vec2 tar_tex_size;\n");
            stringBuilder.append("uniform vec2 ori_tex_size;\n");
        } else if (scaleFilter == FilterType.Bicubic) {
            stringBuilder.append("uniform vec2 tar_tex_size;\n");
            stringBuilder.append("uniform vec2 ori_tex_size;\n");
        }
        if (shaderType == ShaderType.YUV) {
            stringBuilder.append("uniform sampler2D y_tex;\n");
            stringBuilder.append("uniform sampler2D u_tex;\n");
            stringBuilder.append("uniform sampler2D v_tex;\n");
            if (scaleFilter == FilterType.Bilinear) {
                stringBuilder.append("float bilinearTextureSample(sampler2D tex, vec2 p) {\n");
                stringBuilder.append("        vec2 c_onePixel =  vec2(1.0 / ori_tex_size.y - tar_tex_size.x + tar_tex_size.x, 1.0 / ori_tex_size.y);\n");
                stringBuilder.append("    vec2 frac = vec2(0.5, 0.5);\n");
                stringBuilder.append("    float C11 = texture2D(tex, p - c_onePixel).r;\n");
                stringBuilder.append("    float C21 = texture2D(tex, p + vec2( c_onePixel.x , -c_onePixel.y)).r;\n");
                stringBuilder.append("    float C12 = texture2D(tex, p + vec2( -c_onePixel.x , c_onePixel.y)).r;\n");
                stringBuilder.append("    float C22 = texture2D(tex, p + c_onePixel).r;\n");
                stringBuilder.append("    float x1 = mix(C11, C21, frac.x);\n");
                stringBuilder.append("    float x2 = mix(C12, C22, frac.x);\n");
                stringBuilder.append("    return mix(x1, x2, frac.y);\n");
                stringBuilder.append("}\n");
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                stringBuilder.append("  float y = bilinearTextureSample(y_tex, p) * 1.16438;\n");
                stringBuilder.append("  float u = bilinearTextureSample(u_tex, p);\n");
                stringBuilder.append("  float v = bilinearTextureSample(v_tex, p);\n");
                stringBuilder.append("  return vec4(y + 1.59603 * v - 0.874202,\n");
                stringBuilder.append("    y - 0.391762 * u - 0.812968 * v + 0.531668,\n");
                stringBuilder.append("    y + 2.01723 * u - 1.08563, 1);\n");
                stringBuilder.append("}\n");
            } else if (scaleFilter == FilterType.Bicubic) {
                stringBuilder.append("vec3 cubic_hermite (vec3 A, vec3 B, vec3 C, vec3 D, float t) {\n");
                stringBuilder.append("\t  float t2 = t*t;\n");
                stringBuilder.append("    float t3 = t*t*t;\n");
                stringBuilder.append("    vec3 a = -A/2.0 + (3.0*B)/2.0 - (3.0*C)/2.0 + D/2.0;\n");
                stringBuilder.append("    vec3 b = A - (5.0*B)/2.0 + 2.0*C - D / 2.0;\n");
                stringBuilder.append("    vec3 c = -A/2.0 + C/2.0;\n");
                stringBuilder.append("   \tvec3 d = B;\n");
                stringBuilder.append("    return a*t3 + b*t2 + c*t + d;\n");
                stringBuilder.append("}\n");
                stringBuilder.append("vec4 bicubic_sample (sampler2D tex, , vec2 P) {\n");
                stringBuilder.append("    float c_onePixel_x = 1.0 / ori_tex_size.x - tar_tex_size.x + tar_tex_size.x;\n");
                stringBuilder.append("    float c_onePixel_y = 1.0 / ori_tex_size.y;\n");
                stringBuilder.append("    float c_twoPixels_x = 2.0 / ori_tex_size.x;\n");
                stringBuilder.append("    float c_twoPixels_y = 2.0 / ori_tex_size.y;\n");
                stringBuilder.append("    vec2 pixel = vec2(P.x * ori_tex_size.x, P.y * ori_tex_size.y) + 0.5;\n");
                stringBuilder.append("    vec2 frac = fract(pixel);\n");
                stringBuilder.append("    pixel = floor(pixel);\n");
                stringBuilder.append("    pixel = vec2(pixel.x / ori_tex_size.x, pixel.y / ori_tex_size.y) - vec2(c_onePixel_x, c_onePixel_y) / 2.0;\n");
                stringBuilder.append("    vec3 C00 = texture2D(tex, pixel + vec2(-c_onePixel_x ,-c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C10 = texture2D(tex, pixel + vec2( 0.0        ,-c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C20 = texture2D(tex, pixel + vec2( c_onePixel_x ,-c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C30 = texture2D(tex, pixel + vec2( c_twoPixels_x,-c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C01 = texture2D(tex, pixel + vec2(-c_onePixel_x , 0.0)).rgb;\n");
                stringBuilder.append("    vec3 C11 = texture2D(tex, pixel + vec2( 0.0        , 0.0)).rgb;\n");
                stringBuilder.append("    vec3 C21 = texture2D(tex, pixel + vec2( c_onePixel_x , 0.0)).rgb;\n");
                stringBuilder.append("    vec3 C31 = texture2D(tex, pixel + vec2( c_twoPixels_x, 0.0)).rgb;\n");
                stringBuilder.append("    vec3 C02 = texture2D(tex, pixel + vec2(-c_onePixel_x , c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C12 = texture2D(tex, pixel + vec2( 0.0        , c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C22 = texture2D(tex, pixel + vec2( c_onePixel_x , c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C32 = texture2D(tex, pixel + vec2( c_twoPixels_x, c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C03 = texture2D(tex, pixel + vec2(-c_onePixel_x , c_twoPixels_y)).rgb;\n");
                stringBuilder.append("    vec3 C13 = texture2D(tex, pixel + vec2( 0.0        , c_twoPixels_y)).rgb;\n");
                stringBuilder.append("    vec3 C23 = texture2D(tex, pixel + vec2( c_onePixel_x , c_twoPixels_y)).rgb;\n");
                stringBuilder.append("    vec3 C33 = texture2D(tex, pixel + vec2( c_twoPixels_x, c_twoPixels_y)).rgb;  \n");
                stringBuilder.append("    vec3 CP0X = cubic_hermite(C00, C10, C20, C30, frac.x);\n");
                stringBuilder.append("    vec3 CP1X = cubic_hermite(C01, C11, C21, C31, frac.x);\n");
                stringBuilder.append("    vec3 CP2X = cubic_hermite(C02, C12, C22, C32, frac.x);\n");
                stringBuilder.append("    vec3 CP3X = cubic_hermite(C03, C13, C23, C33, frac.x);\n");
                stringBuilder.append("    return vec4(cubic_hermite(CP0X, CP1X, CP2X, CP3X, frac.y), 1.0);");
                stringBuilder.append("}\n");
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                stringBuilder.append("  float y = bicubic_sample(y_tex, p) * 1.16438;\n");
                stringBuilder.append("  float u = bicubic_sample(u_tex, p);\n");
                stringBuilder.append("  float v = bicubic_sample(v_tex, p);\n");
                stringBuilder.append("  return vec4(y + 1.59603 * v - 0.874202,\n");
                stringBuilder.append("    y - 0.391762 * u - 0.812968 * v + 0.531668,\n");
                stringBuilder.append("    y + 2.01723 * u - 1.08563, 1);\n");
                stringBuilder.append("}\n");
            } else {
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                stringBuilder.append("  float y = texture2D(y_tex, p).r * 1.16438;\n");
                stringBuilder.append("  float u = texture2D(u_tex, p).r;\n");
                stringBuilder.append("  float v = texture2D(v_tex, p).r;\n");
                stringBuilder.append("  return vec4(y + 1.59603 * v - 0.874202,\n");
                stringBuilder.append("    y - 0.391762 * u - 0.812968 * v + 0.531668,\n");
                stringBuilder.append("    y + 2.01723 * u - 1.08563, 1);\n");
                stringBuilder.append("}\n");
            }
            stringBuilder.append(genericFragmentSource);
        } else {
            String samplerName = shaderType == ShaderType.OES ? "samplerExternalOES" : "sampler2D";
            stringBuilder.append("uniform ").append(samplerName).append(" tex;\n");
            if (scaleFilter == FilterType.Bilinear) {
                stringBuilder.append("vec4 sample(vec2 p) {\n");
                stringBuilder.append("    vec2 c_onePixel =  vec2(1.0 / ori_tex_size.y - tar_tex_size.x + tar_tex_size.x, 1.0 / ori_tex_size.y);\n");
                stringBuilder.append("    vec2 frac = vec2(0.5, 0.5);\n");
                stringBuilder.append("    vec3 C11 = texture2D(tex, p - c_onePixel).rgb;\n");
                stringBuilder.append("    vec3 C21 = texture2D(tex, p + vec2( c_onePixel.x , -c_onePixel.y)).rgb;\n");
                stringBuilder.append("    vec3 C12 = texture2D(tex, p + vec2( -c_onePixel.x , c_onePixel.y)).rgb;\n");
                stringBuilder.append("    vec3 C22 = texture2D(tex, p + c_onePixel).rgb;\n");
                stringBuilder.append("    vec3 x1 = mix(C11, C21, frac.x);\n");
                stringBuilder.append("    vec3 x2 = mix(C12, C22, frac.x);\n");
                stringBuilder.append("    return vec4(mix(x1, x2, frac.y), 1);\n");
                stringBuilder.append("}\n");
                stringBuilder.append(genericFragmentSource);
            } else if (scaleFilter == FilterType.Bicubic) {
                stringBuilder.append("vec3 cubic_hermite (vec3 A, vec3 B, vec3 C, vec3 D, float t) {\n");
                stringBuilder.append("\t  float t2 = t*t;\n");
                stringBuilder.append("    float t3 = t*t*t;\n");
                stringBuilder.append("    vec3 a = -A/2.0 + (3.0*B)/2.0 - (3.0*C)/2.0 + D/2.0;\n");
                stringBuilder.append("    vec3 b = A - (5.0*B)/2.0 + 2.0*C - D / 2.0;\n");
                stringBuilder.append("    vec3 c = -A/2.0 + C/2.0;\n");
                stringBuilder.append("   \tvec3 d = B;\n");
                stringBuilder.append("    return a*t3 + b*t2 + c*t + d;\n");
                stringBuilder.append("}\n");
                stringBuilder.append("vec4 sample (vec2 P) {\n");
                stringBuilder.append("    float c_onePixel_x = 1.0 / ori_tex_size.x - tar_tex_size.x + tar_tex_size.x;\n");
                stringBuilder.append("    float c_onePixel_y = 1.0 / ori_tex_size.y;\n");
                stringBuilder.append("    float c_twoPixels_x = 2.0 / ori_tex_size.x;\n");
                stringBuilder.append("    float c_twoPixels_y = 2.0 / ori_tex_size.y;\n");
                stringBuilder.append("    vec2 pixel = vec2(P.x * ori_tex_size.x, P.y * ori_tex_size.y) + 0.5;\n");
                stringBuilder.append("    vec2 frac = fract(pixel);\n");
                stringBuilder.append("    pixel = floor(pixel);\n");
                stringBuilder.append("    pixel = vec2(pixel.x / ori_tex_size.x, pixel.y / ori_tex_size.y) - vec2(c_onePixel_x, c_onePixel_y) / 2.0;\n");
                stringBuilder.append("    vec3 C00 = texture2D(tex, pixel + vec2(-c_onePixel_x ,-c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C10 = texture2D(tex, pixel + vec2( 0.0        ,-c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C20 = texture2D(tex, pixel + vec2( c_onePixel_x ,-c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C30 = texture2D(tex, pixel + vec2( c_twoPixels_x,-c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C01 = texture2D(tex, pixel + vec2(-c_onePixel_x , 0.0)).rgb;\n");
                stringBuilder.append("    vec3 C11 = texture2D(tex, pixel + vec2( 0.0        , 0.0)).rgb;\n");
                stringBuilder.append("    vec3 C21 = texture2D(tex, pixel + vec2( c_onePixel_x , 0.0)).rgb;\n");
                stringBuilder.append("    vec3 C31 = texture2D(tex, pixel + vec2( c_twoPixels_x, 0.0)).rgb;\n");
                stringBuilder.append("    vec3 C02 = texture2D(tex, pixel + vec2(-c_onePixel_x , c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C12 = texture2D(tex, pixel + vec2( 0.0        , c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C22 = texture2D(tex, pixel + vec2( c_onePixel_x , c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C32 = texture2D(tex, pixel + vec2( c_twoPixels_x, c_onePixel_y)).rgb;\n");
                stringBuilder.append("    vec3 C03 = texture2D(tex, pixel + vec2(-c_onePixel_x , c_twoPixels_y)).rgb;\n");
                stringBuilder.append("    vec3 C13 = texture2D(tex, pixel + vec2( 0.0        , c_twoPixels_y)).rgb;\n");
                stringBuilder.append("    vec3 C23 = texture2D(tex, pixel + vec2( c_onePixel_x , c_twoPixels_y)).rgb;\n");
                stringBuilder.append("    vec3 C33 = texture2D(tex, pixel + vec2( c_twoPixels_x, c_twoPixels_y)).rgb;  \n");
                stringBuilder.append("    vec3 CP0X = cubic_hermite(C00, C10, C20, C30, frac.x);\n");
                stringBuilder.append("    vec3 CP1X = cubic_hermite(C01, C11, C21, C31, frac.x);\n");
                stringBuilder.append("    vec3 CP2X = cubic_hermite(C02, C12, C22, C32, frac.x);\n");
                stringBuilder.append("    vec3 CP3X = cubic_hermite(C03, C13, C23, C33, frac.x);\n");
                stringBuilder.append("    return vec4(cubic_hermite(CP0X, CP1X, CP2X, CP3X, frac.y), 1.0);");
                stringBuilder.append("}\n");
                stringBuilder.append(genericFragmentSource);
            } else {
                stringBuilder.append(genericFragmentSource.replace("sample(", "texture2D(tex, "));
            }
        }
        return stringBuilder.toString();
    }

    public GlGenericDrawer(String genericFragmentSource, ShaderCallbacks shaderCallbacks) {
        this(DEFAULT_VERTEX_SHADER_STRING, genericFragmentSource, shaderCallbacks);
    }

    public GlGenericDrawer(String vertexShader, String genericFragmentSource, ShaderCallbacks shaderCallbacks) {
        this.vertexShader = vertexShader;
        this.genericFragmentSource = genericFragmentSource;
        this.shaderCallbacks = shaderCallbacks;
    }

    GlShader createShader(ShaderType shaderType, FilterType scaleFilter) {
        return new GlShader(this.vertexShader, GlGenericDrawer.createFragmentShaderString(this.genericFragmentSource, shaderType, scaleFilter));
    }

    @Override
    public void drawOes(int oesTextureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.drawOes(oesTextureId, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, FilterType.Origin, 0, 0);
    }

    @Override
    public void drawRgb(int textureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.drawRgb(textureId, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, FilterType.Origin, 0, 0);
    }

    @Override
    public void drawYuv(int[] yuvTextures, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.drawYuv(yuvTextures, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, FilterType.Origin, 0, 0);
    }

    @Override
    public void drawOes(int oesTextureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, FilterType scaleFilter, int unscaleWidth, int unscaleHeight) {
        this.prepareShader(ShaderType.OES, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, scaleFilter, unscaleWidth, unscaleHeight);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)oesTextureId);
        int error = GLES20.glGetError();
        if (error != 0) {
            Log.e((String)"GlGenericDrawer", (String)("drawOes glBindTexture error: " + error));
            RXLogging.e("GlGenericDrawer", "drawOes glBindTexture error: " + error);
            return;
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)36197, (int)0);
        GlUtil.checkNoGLES2Error("drawOes done");
    }

    @Override
    public void drawRgb(int textureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, FilterType scaleFilter, int unscaleWidth, int unscaleHeight) {
        this.prepareShader(ShaderType.RGB, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, scaleFilter, unscaleWidth, unscaleHeight);
        GlUtil.checkNoGLES2Error("after prepare shader");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        int error = GLES20.glGetError();
        if (error != 0) {
            Log.e((String)"GlGenericDrawer", (String)("drawRgb glBindTexture error: " + error));
            RXLogging.e("GlGenericDrawer", "drawRgb glBindTexture error: " + error);
            return;
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)3553, (int)0);
        GlUtil.checkNoGLES2Error("drawRgb done");
    }

    @Override
    public void drawYuv(int[] yuvTextures, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, FilterType scaleFilter, int unscaleWidth, int unscaleHeight) {
        this.prepareShader(ShaderType.YUV, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, scaleFilter, unscaleWidth, unscaleHeight);
        for (int i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)yuvTextures[i]);
        }
        int error = GLES20.glGetError();
        if (error != 0) {
            Log.e((String)"GlGenericDrawer", (String)("drawYuv glBindTexture error: " + error));
            RXLogging.e("GlGenericDrawer", "drawYuv glBindTexture error: " + error);
            return;
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        for (int i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)0);
        }
        GlUtil.checkNoGLES2Error("drawYuv done");
    }

    private void prepareShader(ShaderType shaderType, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight, FilterType scaleFilter, int unscaleWidth, int unscaleHeight) {
        GlShader shader;
        if (null == scaleFilter || 0 == unscaleWidth || 0 == unscaleHeight) {
            scaleFilter = FilterType.Origin;
            unscaleWidth = 0;
            unscaleHeight = 0;
        }
        if (shaderType.equals((Object)this.currentShaderType) && scaleFilter.equals((Object)this.currentScaleFilter)) {
            shader = this.currentShader;
        } else {
            this.currentShaderType = shaderType;
            if (this.currentShader != null) {
                this.currentShader.release();
            }
            this.currentShader = shader = this.createShader(shaderType, scaleFilter);
            this.currentScaleFilter = scaleFilter;
            shader.useProgram();
            if (shaderType == ShaderType.YUV) {
                GLES20.glUniform1i((int)shader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)shader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)shader.getUniformLocation("v_tex"), (int)2);
            } else {
                GLES20.glUniform1i((int)shader.getUniformLocation("tex"), (int)0);
            }
            GlUtil.checkNoGLES2Error("Create shader");
            this.shaderCallbacks.onNewShader(shader);
            this.texMatrixLocation = shader.getUniformLocation(TEXTURE_MATRIX_NAME);
            if (scaleFilter != FilterType.Origin) {
                this.tarTexSizeLocation = shader.getUniformLocation(TAR_TEX_SIZE_NAME);
                this.oriTexSizeLocation = shader.getUniformLocation(ORI_TEX_SIZE_NAME);
            }
            this.inPosLocation = shader.getAttribLocation(INPUT_VERTEX_COORDINATE_NAME);
            this.inTcLocation = shader.getAttribLocation(INPUT_TEXTURE_COORDINATE_NAME);
        }
        GlUtil.checkNoGLES2Error("before useProgram ");
        shader.useProgram();
        GLES20.glEnableVertexAttribArray((int)this.inPosLocation);
        GLES20.glVertexAttribPointer((int)this.inPosLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_BUFFER);
        GLES20.glEnableVertexAttribArray((int)this.inTcLocation);
        GLES20.glVertexAttribPointer((int)this.inTcLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_TEXTURE_BUFFER);
        GLES20.glUniformMatrix4fv((int)this.texMatrixLocation, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        if (scaleFilter != FilterType.Origin && unscaleWidth > 0 && unscaleWidth > 0) {
            GLES20.glUniform2f((int)this.tarTexSizeLocation, (float)frameWidth, (float)frameHeight);
            GLES20.glUniform2f((int)this.oriTexSizeLocation, (float)unscaleWidth, (float)unscaleHeight);
        }
        this.shaderCallbacks.onPrepareShader(shader, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight);
        GlUtil.checkNoGLES2Error("Prepare shader");
    }

    @Override
    public void release() {
        if (this.currentShader != null) {
            this.currentShader.release();
            this.currentShader = null;
            this.currentShaderType = null;
        }
    }

    public static interface ShaderCallbacks {
        public void onNewShader(GlShader var1);

        public void onPrepareShader(GlShader var1, float[] var2, int var3, int var4, int var5, int var6);
    }

    public static enum ShaderType {
        OES,
        RGB,
        YUV;

    }
}

