/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.webrtc.JavaI420Buffer;
import org.webrtc.RefCountDelegate;
import org.webrtc.VideoFrame;

public class NV12Buffer
implements VideoFrame.NV12Buffer {
    private final int width;
    private final int height;
    private final int stride;
    private final int sliceHeight;
    private final ByteBuffer buffer;
    private final RefCountDelegate refCountDelegate;
    private final ByteBuffer dataY;
    private final ByteBuffer dataUV;
    private final int strideY;
    private final int strideUV;

    public NV12Buffer(int width, int height, int stride, int sliceHeight, ByteBuffer buffer, @Nullable Runnable releaseCallback) {
        this.width = width;
        this.height = height;
        this.stride = stride;
        this.sliceHeight = sliceHeight;
        this.buffer = buffer;
        this.strideY = stride;
        this.strideUV = stride;
        int yPos = 0;
        int uvPos = yPos + stride * height;
        int halfHeight = (height + 1) / 2;
        buffer.position(yPos);
        buffer.limit(uvPos);
        this.dataY = buffer.slice();
        buffer.position(uvPos);
        buffer.limit(uvPos + halfHeight * this.strideUV);
        this.dataUV = buffer.slice();
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    @Override
    public int getBufferType() {
        return 1;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)this.cropAndScale(0, 0, this.width, this.height, this.width, this.height);
    }

    @Override
    public VideoFrame.NV12Buffer toNV12() {
        this.retain();
        return this;
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(scaleWidth, scaleHeight);
        if (newBuffer == null) {
            return null;
        }
        NV12Buffer.nativeCropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight, this.buffer, this.width, this.height, this.stride, this.sliceHeight, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataU(), newBuffer.getStrideU(), newBuffer.getDataV(), newBuffer.getStrideV());
        return newBuffer;
    }

    @Override
    public VideoFrame.Buffer scaleAndFill(int dstWidth, int dstHeight, int offsetX, int offsetY) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(dstWidth, dstHeight);
        if (newBuffer == null) {
            return null;
        }
        return newBuffer;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataUV() {
        return this.dataUV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideUV() {
        return this.strideUV;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, ByteBuffer var6, int var7, int var8, int var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14, ByteBuffer var15, int var16);
}

