/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.RXVideoCodecProfile;
import org.webrtc.RXVideoCodecStandard;

public class RXVideoCodecDesc {
    public final RXVideoCodecStandard standard;
    public final RXVideoCodecProfile profile;

    @CalledByNative
    public RXVideoCodecDesc(int standard_value, int profile_value) {
        this.standard = RXVideoCodecStandard.fromValue(standard_value);
        this.profile = RXVideoCodecProfile.fromValue(profile_value);
    }

    public RXVideoCodecDesc(RXVideoCodecStandard standard, RXVideoCodecProfile profile) {
        this.standard = standard;
        this.profile = profile;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RXVideoCodecDesc)) {
            return false;
        }
        RXVideoCodecDesc otherInfo = (RXVideoCodecDesc)obj;
        return this.standard == otherInfo.standard && this.profile == otherInfo.profile;
    }

    @CalledByNative
    String getName() {
        return this.standard.mimeType();
    }

    @CalledByNative
    int GetStandardInt() {
        return this.standard.toInt();
    }

    @CalledByNative
    int GetProfileInt() {
        return this.profile.toInt();
    }

    RXVideoCodecProfile getProfile() {
        return this.profile;
    }

    RXVideoCodecStandard getStandard() {
        return this.standard;
    }
}

