/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import com.bytedance.realx.base.RXLogging;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.webrtc.CameraSession;
import org.webrtc.CapturerObserver;
import org.webrtc.ContextUtils;
import org.webrtc.EglBase;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

public class ScreenCaptureAndroidManager
implements VideoCapturer,
VideoSink {
    private static final String TAG = "ScreenCapture";
    private static final int DISPLAY_FLAGS = 11;
    private static final int VIRTUAL_DISPLAY_DPI = 400;
    public static final int DEFAULT_MIN_FRAME_RATE = 4;
    private Intent mediaProjectionPermissionResultData;
    private MediaProjection.Callback mediaProjectionCallback;
    private Map<Integer, CountDownLatch> mLocks;
    private int width;
    private int height;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private CapturerObserver capturerObserver;
    private long numCapturedFrames;
    @Nullable
    private MediaProjection mediaProjection;
    private boolean isDisposed;
    @Nullable
    private MediaProjectionManager mediaProjectionManager;
    private Display mDisplay;
    private DeviceOrientation mCurrentOrientation;
    private Map<Integer, VideoFrame> mVideoFrames = new HashMap<Integer, VideoFrame>();
    private int mFrameIndex = 0;
    private boolean isSurfaceDispose;
    private Context mContext;

    public static ScreenCaptureAndroidManager INSTANCE() {
        return HOLDER.INSTANCE;
    }

    private ScreenCaptureAndroidManager() {
        this.mLocks = new HashMap<Integer, CountDownLatch>();
    }

    public void setData(Intent mediaProjectionPermissionResultData, MediaProjection.Callback mediaProjectionCallback) {
        this.isDisposed = false;
        this.mediaProjectionPermissionResultData = mediaProjectionPermissionResultData;
        this.mediaProjectionCallback = mediaProjectionCallback;
    }

    private void checkNotDisposed() {
        if (this.isDisposed) {
            throw new RuntimeException("capturer is disposed.");
        }
    }

    public void addLock(int hashCode, CountDownLatch latch) {
        this.mLocks.put(hashCode, latch);
    }

    @Nullable
    public MediaProjection getMediaProjection() {
        return this.mediaProjection;
    }

    @Override
    public synchronized void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        this.checkNotDisposed();
        if (capturerObserver == null) {
            throw new RuntimeException("capturerObserver not set.");
        }
        this.capturerObserver = capturerObserver;
        if (surfaceTextureHelper == null) {
            throw new RuntimeException("surfaceTextureHelper not set.");
        }
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.isSurfaceDispose = false;
        this.mContext = applicationContext;
        this.mediaProjectionManager = (MediaProjectionManager)applicationContext.getSystemService("media_projection");
        WindowManager windowManager = (WindowManager)applicationContext.getSystemService("window");
        this.mDisplay = windowManager.getDefaultDisplay();
    }

    public synchronized void initialize(EglBase.Context sharedContext, Context applicationContext, CapturerObserver capturerObserver) {
        this.checkNotDisposed();
        if (capturerObserver == null) {
            throw new RuntimeException("capturerObserver not set.");
        }
        this.capturerObserver = capturerObserver;
        this.surfaceTextureHelper = SurfaceTextureHelper.create("RXLocalCapturer", sharedContext);
        this.isSurfaceDispose = true;
        if (this.surfaceTextureHelper == null) {
            throw new RuntimeException("surfaceTextureHelper is null.");
        }
        this.mContext = applicationContext;
        this.mediaProjectionManager = (MediaProjectionManager)applicationContext.getSystemService("media_projection");
        WindowManager windowManager = (WindowManager)applicationContext.getSystemService("window");
        this.mDisplay = windowManager.getDefaultDisplay();
    }

    @Override
    public synchronized void startCapture(int width, int height, int ignoredFramerate, int min_framerate) {
        this.checkNotDisposed();
        RXLogging.w(TAG, String.format("[ScreenCapture] call |startCapture|,  width=%d, height=%d", width, height));
        if (width > 0 && height > 0) {
            this.width = width;
            this.height = height;
        } else {
            this.width = this.mDisplay.getWidth();
            this.height = this.mDisplay.getHeight();
        }
        this.width = (this.width + 7) / 8 * 8;
        this.height = (this.height + 7) / 8 * 8;
        this.maybeDoRotation();
        this.mediaProjection = this.mediaProjectionManager.getMediaProjection(-1, this.mediaProjectionPermissionResultData);
        if (this.mediaProjection == null) {
            return;
        }
        this.mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
        this.createVirtualDisplay();
        this.capturerObserver.onCapturerStarted(true);
        this.surfaceTextureHelper.setMinFps(min_framerate > 0 ? min_framerate : 4);
        this.surfaceTextureHelper.startListening(this);
    }

    public synchronized void startCapture(int width, int height, int ignoredFramerate, int min_framerate, MediaProjection projection) {
        this.checkNotDisposed();
        RXLogging.w(TAG, String.format("[ScreenCapture] call |startCapture|,  width=%d, height=%d", width, height));
        if (width > 0 && height > 0) {
            this.width = width;
            this.height = height;
        } else {
            this.width = this.mDisplay.getWidth();
            this.height = this.mDisplay.getHeight();
        }
        this.width = (this.width + 7) / 8 * 8;
        this.height = (this.height + 7) / 8 * 8;
        this.maybeDoRotation();
        this.mediaProjection = projection;
        if (this.mediaProjection == null) {
            return;
        }
        this.mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
        this.createVirtualDisplay();
        this.capturerObserver.onCapturerStarted(true);
        this.surfaceTextureHelper.setMinFps(min_framerate > 0 ? min_framerate : 4);
        this.surfaceTextureHelper.startListening(this);
    }

    @Override
    public synchronized void startCapture(int width, int height, int ignoredFramerate) {
        this.startCapture(width, height, ignoredFramerate, 4);
    }

    public synchronized void stopCapture(final int hashCode) {
        this.checkNotDisposed();
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                CountDownLatch latch = (CountDownLatch)ScreenCaptureAndroidManager.this.mLocks.remove(hashCode);
                if (latch != null) {
                    latch.countDown();
                    Log.i((String)"ScreenCaptureAndroid", (String)"stopCapture countDown finish");
                }
                ScreenCaptureAndroidManager.this.surfaceTextureHelper.stopListening();
                ScreenCaptureAndroidManager.this.capturerObserver.onCapturerStopped();
                if (ScreenCaptureAndroidManager.this.virtualDisplay != null) {
                    ScreenCaptureAndroidManager.this.virtualDisplay.release();
                    ScreenCaptureAndroidManager.this.virtualDisplay = null;
                }
                if (ScreenCaptureAndroidManager.this.mediaProjection != null) {
                    ScreenCaptureAndroidManager.this.mediaProjection.unregisterCallback(ScreenCaptureAndroidManager.this.mediaProjectionCallback);
                    ScreenCaptureAndroidManager.this.mediaProjection = null;
                }
            }
        });
    }

    @Override
    public synchronized void stopCapture() {
        this.checkNotDisposed();
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                ScreenCaptureAndroidManager.this.surfaceTextureHelper.stopListening();
                ScreenCaptureAndroidManager.this.capturerObserver.onCapturerStopped();
                if (ScreenCaptureAndroidManager.this.virtualDisplay != null) {
                    ScreenCaptureAndroidManager.this.virtualDisplay.release();
                    ScreenCaptureAndroidManager.this.virtualDisplay = null;
                }
                if (ScreenCaptureAndroidManager.this.mediaProjection != null) {
                    ScreenCaptureAndroidManager.this.mediaProjection.unregisterCallback(ScreenCaptureAndroidManager.this.mediaProjectionCallback);
                    ScreenCaptureAndroidManager.this.mediaProjection.stop();
                    ScreenCaptureAndroidManager.this.mediaProjection = null;
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
        if (this.isSurfaceDispose && this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
    }

    @Override
    public synchronized void changeCaptureFormat(int width, int height, int ignoredFramerate) {
        this.checkNotDisposed();
        if (width > 0 && height > 0) {
            this.width = width;
            this.height = height;
        } else {
            this.width = this.mDisplay.getWidth();
            this.height = this.mDisplay.getHeight();
        }
        this.width = (this.width + 7) / 8 * 8;
        this.height = (this.height + 7) / 8 * 8;
        if (this.virtualDisplay == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                ScreenCaptureAndroidManager.this.virtualDisplay.release();
                ScreenCaptureAndroidManager.this.createVirtualDisplay();
            }
        });
    }

    @Override
    public boolean isCameraTorchSupported() {
        return false;
    }

    @Override
    public void turnOnFlashLight() {
    }

    @Override
    public void turnOffFlashLight() {
    }

    @Override
    public boolean isCameraZoomSupported() {
        return false;
    }

    @Override
    public int setCameraZoomRatio(float zoom_val) {
        return 0;
    }

    @Override
    public float getCameraZoomMaxRatio() {
        return 1.0f;
    }

    @Override
    public int enableFollowGravity(boolean enable) {
        return -1;
    }

    @Override
    public int getDeviceOrientation() {
        return CameraSession.getDeviceUIOrientation(ContextUtils.getApplicationContext());
    }

    private void createVirtualDisplay() {
        this.surfaceTextureHelper.setTextureSize(this.width, this.height);
        try {
            RXLogging.w(TAG, String.format("[ScreenCapture] call |createVirtualDisplay|,  width=%d, height=%d", this.width, this.height));
            this.virtualDisplay = this.mediaProjection.createVirtualDisplay("RTCScreenCapture", this.width, this.height, 400, 11, new Surface(this.surfaceTextureHelper.getSurfaceTexture()), null, null);
        }
        catch (SecurityException e) {
            this.virtualDisplay = null;
            Log.i((String)"ScreenCaptureAndroid", (String)"Invalid media projection, no permission");
        }
    }

    @Override
    public void onFrame(VideoFrame frame) {
        if (this.maybeDoRotation()) {
            if (this.virtualDisplay != null) {
                this.virtualDisplay.release();
            }
            this.createVirtualDisplay();
            return;
        }
        ++this.numCapturedFrames;
        this.capturerObserver.onFrameCaptured(frame);
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    public long getNumCapturedFrames() {
        return this.numCapturedFrames;
    }

    public int addFrame(VideoFrame frame) {
        int index = this.mFrameIndex++;
        this.mVideoFrames.put(index, frame);
        return index;
    }

    public VideoFrame removeFrame(int index) {
        if (this.mVideoFrames.containsKey(index)) {
            return this.mVideoFrames.remove(index);
        }
        return null;
    }

    private int getDeviceRotation() {
        switch (this.mDisplay.getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        assert (false);
        return 0;
    }

    private DeviceOrientation getDeviceOrientation(int rotation) {
        switch (rotation) {
            case 0: 
            case 180: {
                return DeviceOrientation.PORTRAIT;
            }
            case 90: 
            case 270: {
                return DeviceOrientation.LANDSCAPE;
            }
        }
        assert (false);
        return DeviceOrientation.LANDSCAPE;
    }

    private DeviceOrientation getDisplayOrientation() {
        if (this.mContext.getResources().getConfiguration().orientation == 1) {
            return DeviceOrientation.PORTRAIT;
        }
        return DeviceOrientation.LANDSCAPE;
    }

    private boolean maybeDoRotation() {
        int rotation = this.getDeviceRotation();
        DeviceOrientation orientation1 = this.getDeviceOrientation(rotation);
        DeviceOrientation orientation = this.getDisplayOrientation();
        if (orientation == this.mCurrentOrientation) {
            return false;
        }
        RXLogging.w(TAG, String.format("[ScreenCapture] call |maybeDoRotation| and orientation != mCurrentOrientation, rotation:%d, orientation:%s, orientation1:%s", rotation, orientation.toString(), orientation1.toString()));
        this.mCurrentOrientation = orientation;
        this.rotateCaptureOrientation(orientation);
        return true;
    }

    private void rotateCaptureOrientation(DeviceOrientation orientation) {
        if (orientation == DeviceOrientation.LANDSCAPE && this.width < this.height || orientation == DeviceOrientation.PORTRAIT && this.height < this.width) {
            RXLogging.w(TAG, String.format("[ScreenCapture] call |rotateCaptureOrientation| before(orientation:%s, width:%d, height:%d)", orientation.toString(), this.width, this.height));
            this.height = this.width;
            this.width += this.height - this.height;
            RXLogging.w(TAG, String.format("[ScreenCapture] call |rotateCaptureOrientation| after(orientation:%s, width:%d, height:%d)", orientation.toString(), this.width, this.height));
        }
    }

    private static final class HOLDER {
        private static final ScreenCaptureAndroidManager INSTANCE = new ScreenCaptureAndroidManager();

        private HOLDER() {
        }
    }

    public static enum DeviceOrientation {
        PORTRAIT,
        LANDSCAPE;

    }
}

