/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.view.Surface;
import org.webrtc.CalledByNative;
import org.webrtc.EncodedImage;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoFrame;

public interface VideoDecoder {
    @CalledByNative
    default public long createNativeVideoDecoder() {
        return 0L;
    }

    @CalledByNative
    public VideoCodecStatus initDecode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus decode(EncodedImage var1);

    @CalledByNative
    public boolean getPrefersLateDecoding();

    @CalledByNative
    public String getImplementationName();

    @CalledByNative
    public void setExternalSurface(Surface var1);

    @CalledByNative
    public void disableExternalSurface();

    public static interface Callback {
        public void onDecodedFrame(VideoFrame var1);

        public void onDecoderInited(long var1);

        public void onMediaCodecStatus(VideoCodecStatus var1, String var2);
    }

    public static class DecodeInfo {
        public final boolean isMissingFrames;
        public final long renderTimeMs;

        public DecodeInfo(boolean isMissingFrames, long renderTimeMs) {
            this.isMissingFrames = isMissingFrames;
            this.renderTimeMs = renderTimeMs;
        }
    }

    public static class Settings {
        public final int numberOfCores;
        public final int width;
        public final int height;
        public final boolean outputByDts;
        public final boolean enableSmoothOutput;
        public final boolean enableYUVOutput;
        public final boolean latencyInsensitiveMode;

        @CalledByNative(value="Settings")
        public Settings(int numberOfCores, int width, int height, boolean outputByDts, boolean enableSmoothOutput, boolean enableYUVOutput, boolean latencyInsensitiveMode) {
            this.numberOfCores = numberOfCores;
            this.width = width;
            this.height = height;
            this.outputByDts = outputByDts;
            this.enableSmoothOutput = enableSmoothOutput;
            this.enableYUVOutput = enableYUVOutput;
            this.latencyInsensitiveMode = latencyInsensitiveMode;
        }
    }
}

