/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import com.bytedance.realx.base.RXLogging;
import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.JavaI420Buffer;
import org.webrtc.JniCommon;
import org.webrtc.VideoFrame;

public class WrappedNativeNV12Buffer
implements VideoFrame.NV12Buffer {
    private static final String TAG = "WrappedNativeNV12Buffer";
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final int strideY;
    private final ByteBuffer dataUV;
    private final int strideUV;
    private final long nativeBuffer;

    @CalledByNative
    WrappedNativeNV12Buffer(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataUV, int strideUV, long nativeBuffer) {
        this.width = width;
        this.height = height;
        this.dataY = dataY;
        this.strideY = strideY;
        this.dataUV = dataUV;
        this.strideUV = strideUV;
        this.nativeBuffer = nativeBuffer;
        this.retain();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataUV() {
        return this.dataUV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideUV() {
        return this.strideUV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(this.width, this.height);
        if (newBuffer == null) {
            return null;
        }
        WrappedNativeNV12Buffer.nativeNV12ToI420(this.dataY, this.strideY, this.dataUV, this.strideUV, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataU(), newBuffer.getStrideU(), newBuffer.getDataV(), newBuffer.getStrideV(), this.width, this.height);
        return newBuffer;
    }

    @Override
    public VideoFrame.NV12Buffer toNV12() {
        this.retain();
        return this;
    }

    @Override
    public void retain() {
        JniCommon.nativeAddRef(this.nativeBuffer);
    }

    @Override
    public void release() {
        JniCommon.nativeReleaseRef(this.nativeBuffer);
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        RXLogging.e(TAG, "cropAndScale has not been implemented, default return null");
        return null;
    }

    @Override
    public VideoFrame.Buffer scaleAndFill(int dstWidth, int dstHeight, int offsetX, int offsetY) {
        RXLogging.e(TAG, "scaleAndFill has not been implemented, default return null");
        return null;
    }

    private static native void nativeNV12ToI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, ByteBuffer var8, int var9, int var10, int var11);
}

