/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae;

import com.bytedance.bae.ByteAudioOutputStream;
import com.bytedance.bae.ByteAudioSinkInterface;
import com.bytedance.bae.ByteAudioStreamBuffer;
import com.bytedance.bae.ByteAudioStreamFormat;
import com.bytedance.bae.base.CalledByNative;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteAudioOutputSinkProxy {
    private ByteBuffer pullDirectBuffer;
    private ByteAudioStreamBuffer pullStreamBuffer = null;
    private long nativeSinkPtr = 0L;
    private ByteAudioSinkInterface.ByteAudioOutputSink sink = null;
    private ByteAudioOutputStream stream = null;

    public ByteAudioOutputSinkProxy(ByteAudioSinkInterface.ByteAudioOutputSink sink, ByteAudioOutputStream stream) {
        this.sink = sink;
        this.stream = stream;
        this.pullDirectBuffer = ByteBuffer.allocateDirect(15360);
        this.pullDirectBuffer.order(ByteOrder.nativeOrder());
        int type = 0;
        ByteAudioStreamFormat format = new ByteAudioStreamFormat(0, 0, type, 0);
        this.pullStreamBuffer = new ByteAudioStreamBuffer(this.pullDirectBuffer, 0, format, 0);
    }

    public void releaseProxySink() {
        this.sink = null;
        this.stream = null;
        this.pullStreamBuffer = null;
    }

    public void setNativeSink(long nativeSinkPtr) {
        this.nativeSinkPtr = nativeSinkPtr;
    }

    @CalledByNative
    public int onPullAudioBufferToStream(long currentNativeStreamPtr) {
        int res = -1;
        if (this.sink != null) {
            this.pullDirectBuffer.clear();
            res = this.sink.onPullAudioBufferToStream(this.stream, this.pullStreamBuffer);
            this.pullDirectBuffer.flip();
        }
        return res;
    }

    @CalledByNative
    public ByteBuffer getDirectBuffer() {
        return this.pullDirectBuffer;
    }

    @CalledByNative
    public ByteAudioStreamBuffer getStreamBuffer() {
        return this.pullStreamBuffer;
    }
}

