/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.codec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.support.annotation.Nullable;
import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.base.CalledByNative;
import java.nio.ByteBuffer;

public class MediaCodecAACEncoder {
    private static final String TAG = "MediaCodecAACEncoder";
    private static final int MAX_WAITING_TIME = 300;
    private String mMimeType = "audio/mp4a-latm";
    private MediaCodec mAACEncoder = null;
    private int mSampleRate = 44100;
    private int mChannels = 1;
    private int mProfile = 2;
    private int mBitrate = 64000;
    @Nullable
    private byte[] mEncodedData;
    private int mFrameSize = 1024;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private MediaCodec.BufferInfo mBufferInfo;

    @CalledByNative
    MediaCodecAACEncoder() {
        BaeLogging.e(TAG, "MediaCodecAAC Encoder Created");
    }

    @CalledByNative
    public boolean openEncoder() {
        try {
            this.mAACEncoder = MediaCodec.createEncoderByType((String)this.mMimeType);
            BaeLogging.e(TAG, "open AAC encoder success");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mAACEncoder = null;
            BaeLogging.e(TAG, "Open AAC encoder failed");
            return false;
        }
        return this.mAACEncoder != null;
    }

    @CalledByNative
    public void closeEncoder() {
        try {
            if (this.mAACEncoder != null) {
                this.mAACEncoder.stop();
                this.mAACEncoder.release();
                this.mAACEncoder = null;
                BaeLogging.e(TAG, "close AAC encoder success");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "close AAC encoder failed");
        }
    }

    @CalledByNative
    public void setProfileValue(String profile) {
        if (profile.equals("he_aac")) {
            this.mProfile = 5;
            this.mFrameSize = 2048;
        } else if (profile.equals("he_aac_v2")) {
            this.mProfile = 29;
            this.mFrameSize = 2048;
        } else {
            this.mProfile = 2;
            this.mFrameSize = 1024;
        }
    }

    @CalledByNative
    public int getFrameSize() {
        return this.mFrameSize;
    }

    @CalledByNative
    public void setSampeRateValue(int sr) {
        this.mSampleRate = sr;
    }

    @CalledByNative
    public void setChannelsValue(int ch) {
        this.mChannels = ch;
    }

    @CalledByNative
    public void setBitRateValue(int bitrate) {
        this.mBitrate = bitrate;
    }

    @CalledByNative
    @Nullable
    public byte[] getEncodedData() {
        return this.mEncodedData;
    }

    @CalledByNative
    public boolean configAndStartEncoder() {
        try {
            MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)this.mMimeType, (int)this.mSampleRate, (int)this.mChannels);
            mediaFormat.setInteger("bitrate", this.mBitrate);
            mediaFormat.setInteger("aac-profile", this.mProfile);
            mediaFormat.setInteger("profile", this.mProfile);
            mediaFormat.setInteger("max-input-size", this.mChannels * this.mFrameSize * 100);
            this.mAACEncoder.configure(mediaFormat, null, null, 1);
            this.mAACEncoder.start();
            this.mBufferInfo = new MediaCodec.BufferInfo();
            BaeLogging.e(TAG, "config AAC encoder success");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "Config and Start Encoder Error");
            return false;
        }
        return true;
    }

    @CalledByNative
    public boolean setBitrate(int bitrate) {
        try {
            if (null == this.mAACEncoder) {
                return false;
            }
            this.mAACEncoder.stop();
            MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)this.mMimeType, (int)this.mSampleRate, (int)this.mChannels);
            mediaFormat.setInteger("bitrate", bitrate);
            mediaFormat.setInteger("aac-profile", this.mProfile);
            this.mAACEncoder.configure(mediaFormat, null, null, 1);
            this.mAACEncoder.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "Config and Start Encoder Error");
            return false;
        }
        this.mBitrate = bitrate;
        return true;
    }

    @CalledByNative
    public boolean encodeProcess(byte[] data) {
        try {
            if (null == this.mAACEncoder) {
                return false;
            }
            this.mEncodedData = null;
            int inputIndex = this.mAACEncoder.dequeueInputBuffer(300L);
            if (inputIndex >= 0) {
                ByteBuffer in_buf;
                if (Build.VERSION.SDK_INT >= 21) {
                    in_buf = this.mAACEncoder.getInputBuffer(inputIndex);
                } else {
                    this.mInputBuffers = this.mAACEncoder.getInputBuffers();
                    in_buf = this.mInputBuffers[inputIndex];
                    in_buf.limit(data.length);
                }
                in_buf.clear();
                in_buf.put(data);
                this.mAACEncoder.queueInputBuffer(inputIndex, 0, data.length, 0L, 0);
            }
            int outputIndex = this.mAACEncoder.dequeueOutputBuffer(this.mBufferInfo, 0L);
            int bytePacketSize = this.mBufferInfo.size;
            if (bytePacketSize <= 0 || outputIndex < 0) {
                return true;
            }
            ByteBuffer buf = null;
            if (Build.VERSION.SDK_INT >= 21) {
                buf = this.mAACEncoder.getOutputBuffer(outputIndex);
            } else {
                this.mOutputBuffers = this.mAACEncoder.getOutputBuffers();
                buf = this.mOutputBuffers[outputIndex];
                buf.limit(this.mBufferInfo.size);
            }
            this.mEncodedData = new byte[bytePacketSize];
            buf.get(this.mEncodedData, this.mBufferInfo.offset, bytePacketSize);
            buf.clear();
            this.mAACEncoder.releaseOutputBuffer(outputIndex, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "AAC Encoder Encode failed");
            return false;
        }
        return true;
    }
}

