/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.router;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.ContextCompat;
import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.router.AudioRouteController;
import com.bytedance.bae.router.AudioRouteUtil;
import com.bytedance.bae.router.IAudioRouteCallback;
import java.util.HashMap;

public class AudioRouteDeviceManager
extends BroadcastReceiver {
    private static final String TAG = "AudioRouteDeviceManager";
    private static final String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    private static final String ACTION_USB_DEVICE_DETACHED = "android.hardware.usb.action.USB_DEVICE_DETACHED";
    private static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    private static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED";
    private static final String ACTION_SCO_AUDIO_STATE_UPDATED = "android.media.ACTION_SCO_AUDIO_STATE_UPDATED";
    private static final String ACTION_HEADSET_PLUG = "android.intent.action.HEADSET_PLUG";
    private IntentFilter mIntentFilter;
    private volatile boolean registered = false;
    private IAudioRouteCallback mCallback;
    private BluetoothAdapter mBluetoothAdapter;
    private int mInitDeviceState = 0;
    private int mBluetoothScoConnectCheckTimes;
    private static final int BLUETOOTH_SCO_CONNECT_CHECK_MAX_RETRY_TIMES = 3;
    private static final int BLUETOOTH_SCO_CONNECT_CHECK_TIME_GAP = 5000;
    private static final int BLUETOOTH_SCO_DISCONNECT_CHECK_TIME_GAP = 6000;
    private Handler mHandler;
    private boolean mBluetoothPermission = false;
    private MyBluetoothDevice mBluetoothDevice;
    private UsbDevice mUsbHeadsetDevice;
    private String mWiredHeadsetDevice;
    @RoutingDeviceType
    private int currentRouting = -1;

    public AudioRouteDeviceManager(IAudioRouteCallback callback) {
        this.mCallback = callback;
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction(ACTION_CONNECTION_STATE_CHANGED);
        this.mIntentFilter.addAction(ACTION_STATE_CHANGED);
        this.mIntentFilter.addAction(ACTION_HEADSET_PLUG);
        this.mIntentFilter.addAction(ACTION_USB_DEVICE_ATTACHED);
        this.mIntentFilter.addAction(ACTION_USB_DEVICE_DETACHED);
        this.mIntentFilter.addAction(ACTION_SCO_AUDIO_STATE_UPDATED);
    }

    @SuppressLint(value={"WrongConstant"})
    private boolean checkPermission() {
        Context context = AudioRouteUtil.getContext();
        if (context == null) {
            return false;
        }
        int osVersion = Build.VERSION.SDK_INT;
        int targetVersion = context.getApplicationInfo().targetSdkVersion;
        if (osVersion >= 31 && targetVersion >= 31) {
            if (0 != context.checkCallingOrSelfPermission("android.permission.BLUETOOTH_CONNECT")) {
                BaeLogging.e(TAG, "permission android.permission.BLUETOOTH_CONNECT not be granted. osVersion:" + osVersion + " targetVersion:" + targetVersion);
                return false;
            }
            BaeLogging.i(TAG, "permission android.permission.BLUETOOTH_CONNECT granted. osVersion:" + osVersion + " targetVersion:" + targetVersion);
            return true;
        }
        if (0 != context.checkCallingOrSelfPermission("android.permission.BLUETOOTH")) {
            BaeLogging.e(TAG, "permission android.permission.BLUETOOTH not be granted. osVersion:" + osVersion + " targetVersion:" + targetVersion);
            return false;
        }
        BaeLogging.i(TAG, "permission android.permission.BLUETOOTH granted. osVersion:" + osVersion + " targetVersion:" + targetVersion);
        return true;
    }

    private boolean initBluetooth() {
        boolean connected;
        if (!this.checkPermission()) {
            return false;
        }
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: getDefaultAdapter is null");
            return false;
        }
        boolean bl = connected = 2 == this.mBluetoothAdapter.getProfileConnectionState(1);
        if (connected) {
            this.mBluetoothDevice = new MyBluetoothDevice("bluetooth-headset[init]");
        }
        return connected;
    }

    private boolean hasAudioForUsbDevice(UsbDevice device) {
        if (device == null) {
            return false;
        }
        for (int i = 0; i < device.getConfigurationCount(); ++i) {
            UsbConfiguration configuration = device.getConfiguration(i);
            if (configuration == null) continue;
            for (int j = 0; j < configuration.getInterfaceCount(); ++j) {
                UsbInterface usbInterface = configuration.getInterface(j);
                if (usbInterface == null || usbInterface.getInterfaceClass() != 1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean initUsbHeadset() {
        try {
            Context context = AudioRouteUtil.getContext();
            if (context == null) {
                return false;
            }
            UsbManager usbManager = (UsbManager)context.getSystemService("usb");
            HashMap deviceMap = usbManager.getDeviceList();
            for (String name : deviceMap.keySet()) {
                UsbDevice device = (UsbDevice)deviceMap.get(name);
                if (!this.hasAudioForUsbDevice(device)) continue;
                this.mUsbHeadsetDevice = device;
                BaeLogging.e(TAG, "AudioRouteDeviceManager: initUsbHeadset finished.");
                return true;
            }
        }
        catch (Throwable e) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: initUsbHeadset failed.", e);
        }
        return false;
    }

    private boolean initHeadset() {
        return false;
    }

    private void initHandler() {
        Looper looper = Looper.myLooper();
        if (looper != null || (looper = Looper.getMainLooper()) != null) {
            this.mHandler = new Handler(looper);
            this.mHandler.removeCallbacks(this::bluetoothScoConnectionCheck);
            BaeLogging.e(TAG, "AudioRouteDeviceManager: initHandler success");
        } else {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: initHandler failed");
        }
    }

    public int getDeviceState() {
        return this.mInitDeviceState;
    }

    public int init() {
        this.initHandler();
        boolean wiredHeadsetConnected = this.initHeadset();
        boolean usbHeadsetConnected = this.initUsbHeadset();
        boolean bleConnected = this.initBluetooth();
        if (wiredHeadsetConnected) {
            this.mInitDeviceState += 4;
        }
        if (usbHeadsetConnected) {
            this.mInitDeviceState += 16;
        }
        if (bleConnected) {
            this.mInitDeviceState += 8;
        }
        if (this.registerReceiver() != 0) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: registerReceiver failed.");
            this.release();
            return -2;
        }
        return 0;
    }

    private int registerReceiver() {
        Context context = AudioRouteUtil.getContext();
        if (context == null) {
            return -1;
        }
        if (this.registered) {
            return 0;
        }
        this.registered = true;
        context.registerReceiver((BroadcastReceiver)this, this.mIntentFilter);
        return 0;
    }

    private int unregisterReceiver() {
        Context context = AudioRouteUtil.getContext();
        if (context == null) {
            return -1;
        }
        if (!this.registered) {
            return 0;
        }
        this.registered = false;
        context.unregisterReceiver((BroadcastReceiver)this);
        this.clearAbortBroadcast();
        return 0;
    }

    public String getRenderDeviceName() {
        switch (this.currentRouting) {
            case 8: {
                if (this.mBluetoothDevice != null) {
                    return this.mBluetoothDevice.getName();
                }
                return "failed_bluetooth-headset";
            }
            case 1: {
                return "earpiece";
            }
            case 2: {
                return "built-in speaker";
            }
            case 16: {
                if (this.mUsbHeadsetDevice != null) {
                    return this.mUsbHeadsetDevice.getDeviceName();
                }
                return "failed_usb-headset";
            }
            case 4: {
                if (this.mWiredHeadsetDevice != null) {
                    return this.mWiredHeadsetDevice;
                }
                return "failed_wired-headset";
            }
        }
        return "failed_device_name";
    }

    public String getCaptureDeviceName() {
        return this.getRenderDeviceName();
    }

    public String getSessionInfo() {
        boolean permission2;
        Context context = AudioRouteUtil.getContext();
        if (context == null) {
            return "Context is null";
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            return "AudioManager is null";
        }
        if (this.mCallback == null) {
            return "mCallback is null";
        }
        boolean hasMic = context.getPackageManager().hasSystemFeature("android.hardware.microphone");
        boolean bl = permission2 = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO") == 0;
        assert (audioManager != null);
        return "{ Audio State: audio_mode:" + AudioRouteUtil.modeString(audioManager.getMode()) + ", has_mic:" + hasMic + ", mic_muted:" + audioManager.isMicrophoneMute() + ", speakerphone:" + audioManager.isSpeakerphoneOn() + ", headset:" + audioManager.isWiredHeadsetOn() + ", bt_sco:" + audioManager.isBluetoothScoOn() + ", permission:" + permission2 + " }";
    }

    private void bluetoothScoDisconnectionForNormalMode() {
        Context context = AudioRouteUtil.getContext();
        if (context == null) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: bluetoothScoDisconnectionForNormalMode failed. Context is null.");
            return;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: bluetoothScoDisconnectionForNormalMode failed. AudioManager is null.");
            return;
        }
        int mode = audioManager.getMode();
        boolean bluetoothScoOn = audioManager.isBluetoothScoOn();
        BaeLogging.e(TAG, "AudioRouteDeviceManager: bluetoothScoDisconnectionForNormalMode mode(" + mode + "), bluetoothScoOn(" + bluetoothScoOn + ")");
        if (mode == 0 && bluetoothScoOn) {
            audioManager.stopBluetoothSco();
            audioManager.setBluetoothScoOn(false);
        }
    }

    private void bluetoothScoConnectionCheck() {
        if (this.mBluetoothScoConnectCheckTimes >= 3 || this.mCallback == null) {
            return;
        }
        Context context = AudioRouteUtil.getContext();
        if (context == null) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: bluetoothScoConnectionCheck failed. Context is null.");
            return;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: bluetoothScoConnectionCheck failed. AudioManager is null.");
            return;
        }
        if (this.mBluetoothScoConnectCheckTimes < 3) {
            ++this.mBluetoothScoConnectCheckTimes;
            if (audioManager.isBluetoothScoOn()) {
                BaeLogging.e(TAG, "AudioRouteDeviceManager: bluetoothScoConnectionCheck success.");
                this.mBluetoothScoConnectCheckTimes = 0;
                this.mHandler.removeCallbacks(this::bluetoothScoConnectionCheck);
            } else {
                BaeLogging.e(TAG, "AudioRouteDeviceManager: bluetoothScoConnectionCheck failed. retry again");
                audioManager.startBluetoothSco();
                if (this.mHandler != null) {
                    this.mHandler.postDelayed(this::bluetoothScoConnectionCheck, 5000L);
                }
            }
        } else {
            this.mBluetoothScoConnectCheckTimes = 0;
            this.mHandler.removeCallbacks(this::bluetoothScoConnectionCheck);
        }
    }

    public int setAudioRoute(@RoutingDeviceType int deviceType, boolean isMediaMode) {
        int cacheMode;
        Context context = AudioRouteUtil.getContext();
        if (context == null) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: setAudioRoute failed. Context is null.");
            return -1;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: setAudioRoute failed. AudioManager is null.");
            return -2;
        }
        if (this.mCallback == null) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: setAudioRoute failed. mCallback is null.");
            return -6;
        }
        int mode = audioManager.getMode();
        int n = cacheMode = isMediaMode ? 0 : 3;
        if (cacheMode != mode) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: isMediaMode:" + isMediaMode + ", cacheMode:" + cacheMode + ", systemMode: " + mode + " not matched with system!!!");
            audioManager.setMode(cacheMode);
            mode = audioManager.getMode();
        }
        boolean speakerPhoneOn = audioManager.isSpeakerphoneOn();
        boolean bluetoothScoOn = audioManager.isBluetoothScoOn();
        BaeLogging.e(TAG, "AudioRouteDeviceManager: setAudioRoute, deviceType: " + deviceType + ", cacheMode:" + cacheMode + ", systemMode: " + mode + ", speakerPhoneOn: " + speakerPhoneOn + ", bluetoothScoOn: " + bluetoothScoOn);
        if (mode == 3) {
            if (deviceType == 8) {
                if (!bluetoothScoOn) {
                    audioManager.startBluetoothSco();
                    if (this.mHandler != null) {
                        this.mHandler.removeCallbacks(this::bluetoothScoDisconnectionForNormalMode);
                        this.mHandler.postDelayed(this::bluetoothScoConnectionCheck, 5000L);
                    }
                }
            } else {
                if (bluetoothScoOn) {
                    audioManager.stopBluetoothSco();
                    audioManager.setBluetoothScoOn(false);
                }
                if (deviceType == 2) {
                    if (!speakerPhoneOn) {
                        audioManager.setSpeakerphoneOn(true);
                    }
                } else if (deviceType == 1 || deviceType == 4 || deviceType == 16) {
                    if (speakerPhoneOn) {
                        audioManager.setSpeakerphoneOn(false);
                    }
                } else {
                    BaeLogging.e(TAG, "AudioRouteDeviceManager: setAudioRoute failed. deviceType(" + deviceType + ") invalid.");
                    return -3;
                }
            }
            this.currentRouting = deviceType;
            return 0;
        }
        if (mode == 0) {
            if (bluetoothScoOn) {
                BaeLogging.w(TAG, "AudioRouteDeviceManager: MODE_NORMAL,but BluetoothScoOn is true, force to close it.");
                audioManager.stopBluetoothSco();
                audioManager.setBluetoothScoOn(false);
            } else if (this.mHandler != null) {
                this.mHandler.removeCallbacks(this::bluetoothScoConnectionCheck);
                this.mHandler.postDelayed(this::bluetoothScoDisconnectionForNormalMode, 6000L);
            }
            return 0;
        }
        BaeLogging.e(TAG, "AudioRouteDeviceManager: mode(" + mode + ") is not support to setAudioRoute");
        return -4;
    }

    public int release() {
        AudioManager audioManager;
        this.mCallback = null;
        Context context = AudioRouteUtil.getContext();
        if (context != null && (audioManager = (AudioManager)context.getSystemService("audio")) != null && audioManager.isBluetoothScoOn()) {
            audioManager.stopBluetoothSco();
            audioManager.setBluetoothScoOn(false);
        }
        int ret = 0;
        if (this.unregisterReceiver() != 0) {
            BaeLogging.e(TAG, "AudioRouteDeviceManager: unregisterReceiver failed.");
            ret = -1;
        }
        if (this.mHandler != null) {
            this.mHandler = null;
        }
        this.mBluetoothAdapter = null;
        this.mIntentFilter = null;
        this.mInitDeviceState = 0;
        this.mBluetoothDevice = null;
        this.mUsbHeadsetDevice = null;
        this.mWiredHeadsetDevice = null;
        this.currentRouting = -1;
        return ret;
    }

    public void onReceive(Context context, Intent intent) {
        boolean needReport;
        boolean connectedStatus;
        int deviceType;
        block31: {
            UsbDevice usbDevice;
            int state;
            String action;
            block32: {
                BluetoothDevice bluetoothDevice;
                block30: {
                    if (intent == null) {
                        return;
                    }
                    action = intent.getAction();
                    if (action == null) {
                        BaeLogging.e(TAG, "AudioRouteDeviceManager: action is null");
                        return;
                    }
                    state = -1234;
                    deviceType = -1;
                    connectedStatus = false;
                    needReport = false;
                    BaeLogging.e(TAG, "AudioRouteDeviceManager: received broadcast from system, action: " + action);
                    if (!action.equals(ACTION_STATE_CHANGED)) break block30;
                    state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -99);
                    bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    deviceType = 8;
                    switch (state) {
                        case 10: {
                            BaeLogging.e(TAG, "AudioRouteDeviceManager: ACTION_STATE_CHANGED:STATE_OFF:" + this.mBluetoothDevice);
                            if (this.mBluetoothDevice == null) break;
                            needReport = true;
                            this.mBluetoothDevice = null;
                            connectedStatus = false;
                            break;
                        }
                        case 12: {
                            BaeLogging.e(TAG, "AudioRouteDeviceManager: ACTION_STATE_CHANGED:STATE_ON:" + bluetoothDevice);
                            if (bluetoothDevice == null) break;
                            needReport = true;
                            this.mBluetoothDevice = new MyBluetoothDevice(bluetoothDevice);
                            connectedStatus = true;
                            break;
                        }
                    }
                    break block31;
                }
                if (!action.equals(ACTION_CONNECTION_STATE_CHANGED)) break block32;
                deviceType = 8;
                state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                switch (state) {
                    case 0: {
                        BaeLogging.e(TAG, "AudioRouteDeviceManager: ACTION_CONNECTION_STATE_CHANGED:STATE_DISCONNECTED:" + bluetoothDevice);
                        this.mBluetoothDevice = null;
                        connectedStatus = false;
                        needReport = true;
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        BaeLogging.e(TAG, "AudioRouteDeviceManager: ACTION_CONNECTION_STATE_CHANGED:STATE_CONNECTED:" + bluetoothDevice);
                        if (bluetoothDevice != null) {
                            this.mBluetoothDevice = new MyBluetoothDevice(bluetoothDevice);
                            connectedStatus = true;
                            needReport = true;
                            break;
                        }
                        break block31;
                    }
                    default: {
                        BaeLogging.e(TAG, "AudioRouteDeviceManager: ACTION_CONNECTION_STATE_CHANGED, unknown state: " + state);
                        break;
                    }
                }
                break block31;
            }
            if (action.equals(ACTION_SCO_AUDIO_STATE_UPDATED)) {
                deviceType = 32;
                state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -99);
                switch (state) {
                    case 1: {
                        BaeLogging.e(TAG, "AudioRouteDeviceManager: SCO_AUDIO_STATE_CONNECTED");
                        connectedStatus = true;
                        needReport = true;
                        break;
                    }
                    case 0: {
                        BaeLogging.e(TAG, "AudioRouteDeviceManager: SCO_AUDIO_STATE_DISCONNECTED");
                        connectedStatus = false;
                        needReport = true;
                        break;
                    }
                }
            } else if (action.equals(ACTION_USB_DEVICE_ATTACHED)) {
                usbDevice = (UsbDevice)intent.getParcelableExtra("device");
                BaeLogging.e(TAG, "AudioRouteDeviceManager: ACTION_USB_DEVICE_ATTACHED:" + usbDevice);
                deviceType = 16;
                connectedStatus = true;
                if (this.hasAudioForUsbDevice(usbDevice)) {
                    needReport = true;
                    this.mUsbHeadsetDevice = usbDevice;
                }
            } else if (action.equals(ACTION_USB_DEVICE_DETACHED)) {
                usbDevice = (UsbDevice)intent.getParcelableExtra("device");
                BaeLogging.e(TAG, "AudioRouteDeviceManager: ACTION_USB_DEVICE_DETACHED:" + usbDevice);
                deviceType = 16;
                connectedStatus = false;
                if (this.hasAudioForUsbDevice(usbDevice)) {
                    needReport = true;
                    this.mUsbHeadsetDevice = null;
                }
            } else if (action.equals(ACTION_HEADSET_PLUG)) {
                String address = intent.getStringExtra("address");
                String portName = intent.getStringExtra("portName");
                int connected = intent.getIntExtra("state", -99);
                int hasMic = intent.getIntExtra("microphone", -99);
                if (!"".equals(address) && !"".equals(portName) && portName != null && (portName.startsWith("USB") || portName.startsWith("usb"))) {
                    BaeLogging.e(TAG, "AudioRouteDeviceManager: received ACTION_HEADSET_PLUG, may be is a usb device");
                    return;
                }
                deviceType = 4;
                connectedStatus = connected == 1;
                needReport = true;
                BaeLogging.e(TAG, "AudioRouteDeviceManager: ACTION_HEADSET_PLUG:" + (connectedStatus ? "connected" : "disconnected"));
                this.mWiredHeadsetDevice = connectedStatus ? "wired-headset" : null;
            }
        }
        BaeLogging.e(TAG, "AudioRouteDeviceManager: needReport:" + needReport + ", mCallback:" + (this.mCallback != null) + ", deviceType:" + deviceType + ", connectedStatus:" + connectedStatus);
        if (context != null) {
            int mode = -1;
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            if (audioManager != null) {
                mode = audioManager.getMode();
            }
            boolean flag = connectedStatus && mode == 3 && this.mBluetoothDevice != null && (deviceType == 4 || deviceType == 16);
            BaeLogging.e(TAG, "AudioRouteDeviceManager: flag: " + flag + ", mode: " + mode + ", mBluetoothDevice: " + (this.mBluetoothDevice != null));
            if (flag && needReport && this.mCallback != null) {
                int code = deviceType == 16 ? AudioRouteController.EVENT_DISABLE_BLUETOOTH_HEADSET_WITH_USB_HEADSET_PLUGGED : AudioRouteController.EVENT_DISABLE_BLUETOOTH_HEADSET_WITH_WIRED_HEADSET_PLUGGED;
                this.mCallback.onError(code, "disable bluetooth headset while heaset(usb-headset) plugged in MODE_IN_COMMUNICATION");
                return;
            }
        }
        if (needReport && this.mCallback != null) {
            this.mCallback.onDeviceEvent(deviceType, connectedStatus);
        }
    }

    private class MyBluetoothDevice {
        private String name;
        private BluetoothDevice bluetoothDevice;

        public MyBluetoothDevice(String name) {
            this.name = name;
        }

        public MyBluetoothDevice(BluetoothDevice device) {
            this.bluetoothDevice = device;
        }

        public String getName() {
            if (this.bluetoothDevice == null) {
                return this.name;
            }
            return "bluetooth-headset";
        }

        public String toString() {
            return this.getName();
        }
    }

    public static @interface RoutingDeviceType {
        public static final int UNKNOWN = -1;
        public static final int BUILT_IN_EARPIECE = 1;
        public static final int BUILT_IN_SPEAKER = 2;
        public static final int WIRED_HEADSET = 4;
        public static final int BLUETOOTH_HEADSET = 8;
        public static final int USB_HEADSET = 16;
        public static final int BLUETOOTH_SCO = 32;
    }
}

