/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.webrtc;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.base.ContextUtils;
import com.bytedance.bae.base.ExceptionUtils;
import com.bytedance.bae.base.ThreadUtils;
import com.bytedance.bae.webrtc.WebRtcAudioUtils;
import java.nio.ByteBuffer;

public class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_USAGE;
    private static final int INVALID_AUDIO_SESSION_ID = -1;
    private static int usageAttribute;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrack audioTrack;
    @Nullable
    private AudioTrackThread audioThread;
    private static volatile boolean speakerMute;
    private byte[] emptyBytes;
    private String apiResult = "";
    @Nullable
    private static WebRtcAudioTrackErrorCallback errorCallbackOld;
    @Nullable
    private static ErrorCallback errorCallback;
    private static boolean sForbidVoip;

    public static synchronized void setAudioTrackUsageAttribute(int usage) {
        BaeLogging.w(TAG, "Default usage attribute is changed from: " + DEFAULT_USAGE + " to " + usage);
        usageAttribute = usage;
    }

    private static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    @Deprecated
    public static void setErrorCallback(WebRtcAudioTrackErrorCallback errorCallback) {
        BaeLogging.i(TAG, "Set error callback (deprecated");
        errorCallbackOld = errorCallback;
    }

    public static void setErrorCallback(ErrorCallback errorCallback) {
        BaeLogging.i(TAG, "Set extended error callback");
        WebRtcAudioTrack.errorCallback = errorCallback;
    }

    WebRtcAudioTrack(long nativeAudioTrack) {
        this.threadChecker.checkIsOnValidThread();
        BaeLogging.i(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.nativeAudioTrack = nativeAudioTrack;
        this.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
    }

    private boolean initPlayout(int sampleRate, int channels, boolean forbidVoip) {
        this.apiResult = "InitPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ", forbidVoip=" + forbidVoip + "):";
        sForbidVoip = forbidVoip;
        try {
            this.threadChecker.checkIsOnValidThread();
            BaeLogging.i(TAG, "initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ")");
            int bytesPerFrame = channels * 2;
            this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * (sampleRate / 100));
            BaeLogging.i(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
            this.emptyBytes = new byte[this.byteBuffer.capacity()];
            this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioTrack);
            int channelConfig = this.channelCountToConfiguration(channels);
            int minBufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
            BaeLogging.i(TAG, "AudioTrack.getMinBufferSize: " + minBufferSizeInBytes);
            if (minBufferSizeInBytes < this.byteBuffer.capacity()) {
                this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
                this.apiResult = this.apiResult + "AudioTrack.getMinBufferSize returns an invalid value.";
                return false;
            }
            if (this.audioTrack != null) {
                this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
                this.apiResult = this.apiResult + "Conflict with existing AudioTrack.";
                return false;
            }
            try {
                this.apiResult = this.apiResult + "minBufferSizeInBytes: " + minBufferSizeInBytes;
                this.audioTrack = Build.VERSION.SDK_INT >= 21 ? WebRtcAudioTrack.createAudioTrackOnLollipopOrHigher(sampleRate, channelConfig, minBufferSizeInBytes) : WebRtcAudioTrack.createAudioTrackOnLowerThanLollipop(sampleRate, channelConfig, minBufferSizeInBytes);
            }
            catch (IllegalArgumentException e) {
                this.reportWebRtcAudioTrackInitError(ExceptionUtils.stackTrace(e) + e.getMessage());
                this.releaseAudioResources();
                return false;
            }
            if (this.audioTrack == null || this.audioTrack.getState() != 1) {
                this.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
                this.releaseAudioResources();
                this.apiResult = this.apiResult + "Initialization of audio track failed.";
                return false;
            }
            this.logMainParameters();
            this.logMainParametersExtended();
            return true;
        }
        catch (Exception e) {
            BaeLogging.w(TAG, "initPlayout exception", e);
            this.reportWebRtcAudioTrackInitError(ExceptionUtils.stackTrace(e));
            this.apiResult = this.apiResult + "initPlayout exception";
            return false;
        }
    }

    private boolean startPlayout() {
        this.threadChecker.checkIsOnValidThread();
        BaeLogging.i(TAG, "startPlayout");
        if (this.audioTrack == null) {
            BaeLogging.e(TAG, "null audio track object");
            return false;
        }
        if (this.audioThread != null) {
            BaeLogging.e(TAG, "the previous audio thread leak");
            return false;
        }
        this.apiResult = "StartPlayout:";
        try {
            this.audioTrack.play();
        }
        catch (IllegalStateException e) {
            this.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, "AudioTrack.play failed: " + e.getMessage());
            this.releaseAudioResources();
            this.apiResult = this.apiResult + "AudioTrack.play failed: " + e.getMessage();
            return false;
        }
        if (this.audioTrack.getPlayState() != 3) {
            this.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, "AudioTrack.play failed - incorrect state :" + this.audioTrack.getPlayState());
            this.apiResult = this.apiResult + "AudioTrack.play failed - incorrect state :" + this.audioTrack.getPlayState();
            this.releaseAudioResources();
            return false;
        }
        this.audioThread = new AudioTrackThread("BaeTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopPlayout() {
        this.threadChecker.checkIsOnValidThread();
        BaeLogging.i(TAG, "stopPlayout");
        this.apiResult = "StopPlayout:";
        this.logUnderrunCount();
        if (this.audioThread != null) {
            BaeLogging.i(TAG, "Stopping the AudioTrackThread...");
            this.audioThread.stopThread();
            BaeLogging.i(TAG, "interrupt the AudioTrackThread...");
            this.audioThread.interrupt();
            if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
                BaeLogging.e(TAG, "Join of AudioTrackThread timed out.");
                WebRtcAudioUtils.logAudioState(TAG);
                this.apiResult = this.apiResult + "Join of AudioTrackThread timed out.";
            }
            BaeLogging.i(TAG, "AudioTrackThread has now been stopped.");
            this.audioThread = null;
        }
        this.releaseAudioResources();
        BaeLogging.i(TAG, "stopPlayout release done.");
        return true;
    }

    private String getApiResult() {
        this.threadChecker.checkIsOnValidThread();
        return this.apiResult;
    }

    private int getStreamType() {
        this.threadChecker.checkIsOnValidThread();
        if (null == this.audioTrack) {
            return -1;
        }
        return this.audioTrack.getStreamType();
    }

    private int getStreamMaxVolume() {
        this.threadChecker.checkIsOnValidThread();
        BaeLogging.i(TAG, "getStreamMaxVolume");
        if (this.audioManager == null) {
            return -1;
        }
        return this.audioManager.getStreamMaxVolume(0);
    }

    private boolean setStreamVolume(int volume) {
        this.threadChecker.checkIsOnValidThread();
        BaeLogging.i(TAG, "setStreamVolume(" + volume + ")");
        if (this.audioManager == null) {
            return false;
        }
        if (this.isVolumeFixed()) {
            BaeLogging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, volume, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        this.threadChecker.checkIsOnValidThread();
        BaeLogging.i(TAG, "getStreamVolume");
        if (this.audioManager == null) {
            return -1;
        }
        return this.audioManager.getStreamVolume(0);
    }

    private int getAudioSessionId() {
        if (null == this.audioTrack) {
            return -1;
        }
        return this.audioTrack.getAudioSessionId();
    }

    private void logMainParameters() {
        BaeLogging.i(TAG, "AudioTrack: session ID: " + this.audioTrack.getAudioSessionId() + ", channels: " + this.audioTrack.getChannelCount() + ", sample rate: " + this.audioTrack.getSampleRate() + ", max gain: " + AudioTrack.getMaxVolume());
    }

    @TargetApi(value=21)
    private static AudioTrack createAudioTrackOnLollipopOrHigher(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        BaeLogging.i(TAG, "createAudioTrackOnLollipopOrHigher");
        int nativeOutputSampleRate = AudioTrack.getNativeOutputSampleRate((int)(sForbidVoip ? 3 : 0));
        BaeLogging.i(TAG, "nativeOutputSampleRate: " + nativeOutputSampleRate);
        if (sampleRateInHz != nativeOutputSampleRate) {
            BaeLogging.w(TAG, "Unable to use fast mode since requested sample rate is not native");
        }
        if ((usageAttribute = sForbidVoip ? 1 : DEFAULT_USAGE) != DEFAULT_USAGE) {
            BaeLogging.w(TAG, "A non default usage attribute is used: " + usageAttribute);
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(usageAttribute).setContentType(1).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(sampleRateInHz).setChannelMask(channelConfig).build(), bufferSizeInBytes, 1, 0);
    }

    private static AudioTrack createAudioTrackOnLowerThanLollipop(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        if (sForbidVoip) {
            return new AudioTrack(3, sampleRateInHz, channelConfig, 2, bufferSizeInBytes, 1);
        }
        return new AudioTrack(0, sampleRateInHz, channelConfig, 2, bufferSizeInBytes, 1);
    }

    private void logBufferSizeInFrames() {
        if (Build.VERSION.SDK_INT >= 23) {
            BaeLogging.i(TAG, "AudioTrack: buffer size in frames: " + this.audioTrack.getBufferSizeInFrames());
        }
    }

    private void logBufferCapacityInFrames() {
        if (Build.VERSION.SDK_INT >= 24) {
            BaeLogging.i(TAG, "AudioTrack: buffer capacity in frames: " + this.audioTrack.getBufferCapacityInFrames());
        }
    }

    private void logMainParametersExtended() {
        this.logBufferSizeInFrames();
        this.logBufferCapacityInFrames();
    }

    private void logUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24 && this.audioTrack != null) {
            BaeLogging.i(TAG, "underrun count: " + this.audioTrack.getUnderrunCount());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 4 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    public static void setSpeakerMute(boolean mute) {
        BaeLogging.w(TAG, "setSpeakerMute(" + mute + ")");
        speakerMute = mute;
    }

    private void releaseAudioResources() {
        BaeLogging.i(TAG, "releaseAudioResources");
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    private void reportWebRtcAudioTrackInitError(String errorMessage) {
        BaeLogging.e(TAG, "Init playout error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallbackOld != null) {
            errorCallbackOld.onWebRtcAudioTrackInitError(errorMessage);
        }
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioTrackInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode errorCode, String errorMessage) {
        BaeLogging.e(TAG, "Start playout error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallbackOld != null) {
            errorCallbackOld.onWebRtcAudioTrackStartError(errorMessage);
        }
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioTrackStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioTrackError(String errorMessage) {
        BaeLogging.e(TAG, "Run-time playback error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallbackOld != null) {
            errorCallbackOld.onWebRtcAudioTrackError(errorMessage);
        }
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioTrackError(errorMessage);
        }
    }

    static {
        usageAttribute = DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            BaeLogging.i(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            BaeLogging.i(WebRtcAudioTrack.TAG, "AudioTrack state: " + WebRtcAudioTrack.this.audioTrack.getPlayState());
            int sizeInBytes = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack.this.nativeGetPlayoutData(sizeInBytes, WebRtcAudioTrack.this.nativeAudioTrack);
                if (speakerMute) {
                    WebRtcAudioTrack.this.byteBuffer.clear();
                    WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                int bytesWritten = -1;
                try {
                    bytesWritten = this.writeBytes(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes);
                }
                catch (Exception e) {
                    this.keepAlive = false;
                    BaeLogging.e(WebRtcAudioTrack.TAG, "AudioTrack.write error, Exception: " + e.getMessage());
                    WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write error, Exception: " + e.getMessage());
                }
                if (bytesWritten != sizeInBytes && bytesWritten < 0) {
                    this.keepAlive = false;
                    BaeLogging.e(WebRtcAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: " + bytesWritten);
                    WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write failed: " + bytesWritten);
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            if (WebRtcAudioTrack.this.audioTrack != null) {
                BaeLogging.i(WebRtcAudioTrack.TAG, "Calling AudioTrack.stop...");
                try {
                    WebRtcAudioTrack.this.audioTrack.stop();
                    BaeLogging.i(WebRtcAudioTrack.TAG, "AudioTrack.stop is done.");
                }
                catch (Exception e) {
                    BaeLogging.e(WebRtcAudioTrack.TAG, "AudioTrack.stop failed: " + e.getMessage());
                }
            }
        }

        private int writeBytes(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            if (audioTrack == null) {
                return -1;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                return audioTrack.write(byteBuffer, sizeInBytes, 0);
            }
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), sizeInBytes);
        }

        public void stopThread() {
            BaeLogging.i(WebRtcAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface ErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);
    }

    @Deprecated
    public static interface WebRtcAudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(String var1);

        public void onWebRtcAudioTrackError(String var1);
    }

    public static enum AudioTrackStartErrorCode {
        AUDIO_TRACK_START_EXCEPTION,
        AUDIO_TRACK_START_STATE_MISMATCH;

    }
}

