/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.realx;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.RequiresApi;
import com.bytedance.realx.NativeCellularFunctions;
import com.bytedance.realx.base.CalledByNative;
import com.bytedance.realx.base.RXLogging;
import org.webrtc.ContextUtils;

@RequiresApi(api=23)
public class CellularUtility
extends ConnectivityManager.NetworkCallback {
    private static final String TAG = "CellularUtility";
    private ConnectivityManager connectivityManager = null;
    private Network network = null;
    private String ifName;
    private Boolean inited = false;
    private Boolean shouldEmitAvailable = false;
    private long callback = 0L;

    @CalledByNative
    public static CellularUtility create() {
        if (Build.VERSION.SDK_INT >= 26) {
            RXLogging.w(TAG, "cellular_utility create");
            return new CellularUtility();
        }
        return null;
    }

    @CalledByNative
    public synchronized void init(long callback) {
        if (!this.inited.booleanValue()) {
            try {
                RXLogging.w(TAG, "cellular_utility init");
                this.callback = callback;
                Context context = ContextUtils.getApplicationContext();
                this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkRequest request = new NetworkRequest.Builder().addTransportType(0).addCapability(12).build();
                this.connectivityManager.requestNetwork(request, (ConnectivityManager.NetworkCallback)this);
                this.inited = true;
                RXLogging.w(TAG, "cellular_utility init, connectivity manager: " + this.connectivityManager.toString() + ", network request: " + request.toString());
            }
            catch (Exception e) {
                RXLogging.w(TAG, "cellular_utility init exception: " + e.toString());
            }
        }
    }

    @CalledByNative
    public synchronized void unInit() {
        try {
            if (this.inited.booleanValue()) {
                this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this);
                this.connectivityManager = null;
                this.network = null;
                this.callback = 0L;
                this.inited = false;
                RXLogging.w(TAG, "cellular_utility uninit");
            }
        }
        catch (Exception e) {
            RXLogging.w(TAG, "cellular_utility uninit exception: " + e.toString());
        }
    }

    @CalledByNative
    public synchronized int bindSocketToNetwork(int fd) {
        int ret = -1;
        if (this.network != null) {
            RXLogging.w(TAG, "cellular_utility bind socket to network, fd: " + fd);
            try {
                ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.fromFd((int)fd);
                this.network.bindSocket(parcelFileDescriptor.getFileDescriptor());
                parcelFileDescriptor.detachFd();
                ret = 0;
            }
            catch (Exception e) {
                RXLogging.w(TAG, "cellular_utility bind socket to network exception: " + e.toString());
                e.printStackTrace();
            }
        }
        return ret;
    }

    public synchronized void onAvailable(Network network) {
        RXLogging.w(TAG, "cellular_utility on available, network: " + network.toString());
        if (this.network == null) {
            this.network = network;
            this.shouldEmitAvailable = true;
        }
    }

    public synchronized void onUnavailable() {
        RXLogging.w(TAG, "cellular_utility on unavailable");
        if (this.callback != 0L) {
            NativeCellularFunctions.nativeOnNetworkUnavailable(this.callback);
        }
    }

    public synchronized void onLost(Network network) {
        RXLogging.w(TAG, "cellular_utility on lost, network: " + network.toString());
        if (network.equals((Object)this.network)) {
            this.network = null;
            if (this.callback != 0L) {
                NativeCellularFunctions.nativeOnNetworkLost(this.ifName, this.callback);
            }
        }
    }

    public synchronized void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
        RXLogging.w(TAG, "cellular_utility on capabilities changed, network: " + network.toString() + ", capabilities: " + networkCapabilities.toString());
    }

    public synchronized void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
        RXLogging.w(TAG, "cellular_utility on link properties changed, network: " + network.toString() + ", capabilities: " + linkProperties.toString());
        if (network.equals((Object)this.network)) {
            this.ifName = linkProperties.getInterfaceName();
            if (this.callback != 0L && this.shouldEmitAvailable.booleanValue()) {
                NativeCellularFunctions.nativeOnNetworkAvailable(this.ifName, this.callback);
                this.shouldEmitAvailable = false;
                RXLogging.w(TAG, "cellular_utility call native on network available, name: " + this.ifName);
            }
        }
    }

    public synchronized void onBlockedStatusChanged(Network network, boolean blocked) {
        RXLogging.w(TAG, "cellular_utility on network block status changed, network: " + network.toString() + ", blocked: " + blocked);
        if (network.equals((Object)this.network) && this.callback != 0L) {
            NativeCellularFunctions.nativeOnBlockedStatusChanged(this.ifName, blocked, this.callback);
        }
    }
}

