/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.realx;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.webrtc.CalledByNative;
import org.webrtc.ContextUtils;

public class RXDeviceInfo {
    private static final String TAG = "DeviceInfo";
    public static final int DEVICE_INFO_UNKNOWN = -1;
    public static final String MEMTOTAL_PATTERN = "MemTotal[\\s]*:[\\s]*(\\d+)[\\s]*kB\n";
    private static final String CPU_MANUFACTURER_PATTERN = "Hardware[\\s]*:[\\s]*([\\S\\s]*)\n";
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (Character.isDigit(path.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    private static int getTotalMemory(Context c) {
        long ret = -1L;
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        ActivityManager am = (ActivityManager)c.getSystemService("activity");
        am.getMemoryInfo(memInfo);
        if (memInfo != null) {
            ret = memInfo.totalMem / 1024L;
            return (int)ret;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static int GetTotalMemSize() {
        int ret;
        block23: {
            ret = RXDeviceInfo.getTotalMemory(ContextUtils.getApplicationContext());
            if (ret != -1) {
                return ret;
            }
            Process process = null;
            InputStream in = null;
            try {
                MatchResult result;
                process = new ProcessBuilder("/system/bin/cat", "/proc/meminfo").start();
                in = process.getInputStream();
                if (in == null) break block23;
                Scanner scanner = new Scanner(in);
                if (scanner.findWithinHorizon(MEMTOTAL_PATTERN, 1000) != null && (result = scanner.match()).groupCount() > 0) {
                    try {
                        ret = Integer.parseInt(result.group(1));
                    }
                    catch (NumberFormatException e) {
                        Log.i((String)TAG, (String)("GetTotalMemSize NumberFormatException:" + e.getMessage()));
                    }
                }
                scanner.close();
            }
            catch (IOException e) {
                Log.i((String)TAG, (String)("GetTotalMemSize IOException:" + e.getMessage()));
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)("GetTotalMemSize close input stream fail:" + e.getMessage()));
                }
                try {
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)("GetTotalMemSize close process fail:" + e.getMessage()));
                }
            }
        }
        return ret;
    }

    @CalledByNative
    public static int getNumberOfCPUCores() {
        int cores;
        try {
            cores = RXDeviceInfo.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (cores == -1) {
                cores = RXDeviceInfo.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (cores == -1) {
                cores = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
            }
        }
        catch (SecurityException e) {
            cores = -1;
        }
        catch (NullPointerException e) {
            cores = -1;
        }
        return cores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static String GetCpuModel() {
        String ret;
        block22: {
            ret = "";
            Process process = null;
            InputStream in = null;
            try {
                MatchResult result;
                process = new ProcessBuilder("/system/bin/cat", "/proc/cpuinfo").start();
                in = process.getInputStream();
                if (in == null) break block22;
                Scanner scanner = new Scanner(in);
                if (scanner.findWithinHorizon(CPU_MANUFACTURER_PATTERN, 3000) != null && (result = scanner.match()).groupCount() > 0) {
                    try {
                        ret = result.group(1);
                    }
                    catch (NumberFormatException e) {
                        Log.i((String)TAG, (String)("GetCpuModel NumberFormatException:" + e.getMessage()));
                    }
                }
                scanner.close();
            }
            catch (IOException e) {
                Log.i((String)TAG, (String)("GetCpuModel IOException:" + e.getMessage()));
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)("GetCpuModel close input stream fail:" + e.getMessage()));
                }
                try {
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)("GetCpuModel close process fail:" + e.getMessage()));
                }
            }
        }
        return ret;
    }

    @CalledByNative
    public static String GetDeviceBrand() {
        return Build.MANUFACTURER == null ? "" : Build.MANUFACTURER;
    }

    @CalledByNative
    public static String GetDeviceModel() {
        return Build.MODEL == null ? "" : Build.MODEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static int getCPUMaxFreqKHz() {
        int maxFreq;
        block13: {
            maxFreq = -1;
            try {
                for (int i = 0; i < RXDeviceInfo.getNumberOfCPUCores(); ++i) {
                    String filename = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
                    File cpuInfoMaxFreqFile = new File(filename);
                    if (!cpuInfoMaxFreqFile.exists() || !cpuInfoMaxFreqFile.canRead()) continue;
                    byte[] buffer = new byte[128];
                    try (FileInputStream stream = new FileInputStream(cpuInfoMaxFreqFile);){
                        int endIndex;
                        stream.read(buffer);
                        for (endIndex = 0; Character.isDigit(buffer[endIndex]) && endIndex < buffer.length; ++endIndex) {
                        }
                        String str = new String(buffer, 0, endIndex);
                        Integer freqBound = Integer.parseInt(str);
                        if (freqBound <= maxFreq) continue;
                        maxFreq = freqBound;
                        continue;
                    }
                }
                if (maxFreq != -1) break block13;
                try (FileInputStream stream = new FileInputStream("/proc/cpuinfo");){
                    int freqBound = RXDeviceInfo.parseFileForValue("cpu MHz", stream);
                    if ((freqBound *= 1000) > maxFreq) {
                        maxFreq = freqBound;
                    }
                }
            }
            catch (IOException e) {
                maxFreq = -1;
            }
        }
        return maxFreq;
    }

    private static int parseFileForValue(String textToMatch, FileInputStream stream) {
        byte[] buffer = new byte[1024];
        try {
            int length = stream.read(buffer);
            for (int i = 0; i < length; ++i) {
                int textIndex;
                if (buffer[i] != 10 && i != 0) continue;
                if (buffer[i] == 10) {
                    // empty if block
                }
                for (int j = ++i; j < length && buffer[j] == textToMatch.charAt(textIndex = j - i); ++j) {
                    if (textIndex != textToMatch.length() - 1) continue;
                    return RXDeviceInfo.extractValue(buffer, j);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static int extractValue(byte[] buffer, int index) {
        while (index < buffer.length && buffer[index] != 10) {
            if (Character.isDigit(buffer[index])) {
                int start = index++;
                while (index < buffer.length && Character.isDigit(buffer[index])) {
                    ++index;
                }
                String str = new String(buffer, 0, start, index - start);
                return Integer.parseInt(str);
            }
            ++index;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String fileLocation) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileLocation);
            BufferedReader buf = new BufferedReader(new InputStreamReader(is));
            String fileContents = buf.readLine();
            buf.close();
            int n = RXDeviceInfo.getCoresFromFileString(fileContents);
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int getCoresFromFileString(String str) {
        if (str == null || !str.matches("0-[\\d]+$")) {
            return -1;
        }
        return Integer.valueOf(str.substring(2)) + 1;
    }
}

