/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.realx.video.camera;

import com.bytedance.realx.base.CalledByNative;
import com.bytedance.realx.base.RXLogging;
import java.util.ArrayList;
import org.webrtc.Camera1Enumerator;

public class RXVideoCameraInfo {
    private static final String TAG = "RXVideoCameraInfo";
    private static final int CAMERA_FRONT = 0;
    private static final int CAMERA_BACK = 1;
    private static final int CAMERA_EXTERNAL = 2;
    private static final int CAMERA_INVALID = 3;
    private ArrayList<DeviceInfo> deviceInfos;

    @CalledByNative
    RXVideoCameraInfo() {
        RXLogging.i(TAG, "RXVideoCameraInfo Created...");
        this.deviceInfos = new ArrayList();
        try {
            String[] deviceNames;
            Camera1Enumerator enumerator = new Camera1Enumerator(true, false);
            for (String name : deviceNames = enumerator.getDeviceNames()) {
                DeviceInfo info = new DeviceInfo();
                info.name = name;
                info.cameraId = enumerator.isFrontFacing(name) ? 0 : (enumerator.isBackFacing(name) ? 1 : 2);
                this.deviceInfos.add(info);
            }
        }
        catch (IllegalArgumentException e) {
            RXLogging.i(TAG, "Create VideoCapture failed : " + e.getMessage());
        }
    }

    @CalledByNative
    public int getDeviceNumbers() {
        return this.deviceInfos.size();
    }

    @CalledByNative
    public String getDeviceName(int i) {
        if (i >= this.deviceInfos.size()) {
            return null;
        }
        return this.deviceInfos.get((int)i).name;
    }

    @CalledByNative
    public int getCameraId(int i) {
        if (i >= this.deviceInfos.size()) {
            return 3;
        }
        return this.deviceInfos.get((int)i).cameraId;
    }

    public class DeviceInfo {
        String name;
        int cameraId;
    }
}

