/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.base.media;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import com.bytedance.realx.base.CalledByNative;
import com.ss.bytertc.base.media.RTCNativeFunctions;

public class RTCSurfaceHelper {
    @CalledByNative
    public static Object registerSurfaceCallback(Object androidView, long nativeCallbackHandle, String renderTaskUUID) {
        if (androidView instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)androidView;
            RTCSurfaceViewListener listener = new RTCSurfaceViewListener((SurfaceView)androidView, surfaceView.getHolder().getSurface(), nativeCallbackHandle, renderTaskUUID);
            surfaceView.getHolder().addCallback((SurfaceHolder.Callback)listener);
            return listener;
        }
        if (androidView instanceof TextureView) {
            TextureView textureView = (TextureView)androidView;
            RTCSurfaceTextureListener listener = new RTCSurfaceTextureListener((TextureView)androidView, textureView.getSurfaceTexture(), nativeCallbackHandle, renderTaskUUID);
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)listener);
            return listener;
        }
        return null;
    }

    @CalledByNative
    public static void unRegisterSurfaceCallback(View androidView, Object surfaceCallback) {
        if (androidView instanceof TextureView) {
            TextureView textureView = (TextureView)androidView;
            if (surfaceCallback != null) {
                ((RTCSurfaceTextureListener)surfaceCallback).resetCallback();
            }
            textureView.setSurfaceTextureListener(null);
        } else if (androidView instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)androidView;
            if (surfaceCallback != null) {
                ((RTCSurfaceViewListener)surfaceCallback).resetCallback();
            }
            surfaceView.getHolder().removeCallback((SurfaceHolder.Callback)surfaceCallback);
        }
    }

    static class RTCSurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        private TextureView textureView = null;
        private Surface surface = null;
        private long nativeCallbackHandle = 0L;
        private String renderTaskUUID = null;

        RTCSurfaceTextureListener(TextureView renderView, SurfaceTexture surfaceTexture, long nativeCallbackHandle, String renderTaskUUID) {
            this.textureView = renderView;
            this.surface = surfaceTexture != null ? new Surface(surfaceTexture) : null;
            this.nativeCallbackHandle = nativeCallbackHandle;
            this.renderTaskUUID = renderTaskUUID;
            SurfaceTexture initSurfaceTexture = surfaceTexture;
            if (initSurfaceTexture != null && this.nativeCallbackHandle != 0L) {
                new Handler(Looper.getMainLooper()).post(() -> {
                    SurfaceTexture currentSurfaceTexture = this.textureView.getSurfaceTexture();
                    if (currentSurfaceTexture != null && currentSurfaceTexture == initSurfaceTexture) {
                        RTCNativeFunctions.nativeNotifySurfaceAvailable(nativeCallbackHandle, new Surface(currentSurfaceTexture), renderTaskUUID, false);
                    }
                });
            }
        }

        public void resetCallback() {
            this.nativeCallbackHandle = 0L;
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            if (this.nativeCallbackHandle != 0L) {
                this.surface = new Surface(surfaceTexture);
                RTCNativeFunctions.nativeNotifySurfaceAvailable(this.nativeCallbackHandle, this.surface, this.renderTaskUUID, true);
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            if (this.nativeCallbackHandle != 0L) {
                RTCNativeFunctions.nativeNotifySurfaceSizeChanged(this.nativeCallbackHandle, this.renderTaskUUID);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            if (this.nativeCallbackHandle != 0L) {
                RTCNativeFunctions.nativeNotifySurfaceDestroyed(this.nativeCallbackHandle, this.surface, this.renderTaskUUID, true);
            }
            this.surface = null;
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }

    static class RTCSurfaceViewListener
    implements SurfaceHolder.Callback {
        private SurfaceView surfaceView = null;
        private Surface surface = null;
        private long nativeCallbackHandle = 0L;
        private String renderTaskUUID = null;

        RTCSurfaceViewListener(SurfaceView renderView, Surface surface, long nativeCallbackHandle, String renderTaskUUID) {
            this.surfaceView = renderView;
            this.surface = surface != null && surface.isValid() ? surface : null;
            this.nativeCallbackHandle = nativeCallbackHandle;
            this.renderTaskUUID = renderTaskUUID;
            Surface initSurface = surface;
            if (initSurface != null && this.nativeCallbackHandle != 0L) {
                new Handler(Looper.getMainLooper()).post(() -> {
                    Surface currentSurface = this.surfaceView.getHolder().getSurface();
                    if (currentSurface != null && currentSurface.isValid() && currentSurface == initSurface) {
                        RTCNativeFunctions.nativeNotifySurfaceAvailable(nativeCallbackHandle, currentSurface, renderTaskUUID, false);
                    }
                });
            }
        }

        public void resetCallback() {
            this.nativeCallbackHandle = 0L;
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            if (this.nativeCallbackHandle != 0L) {
                this.surface = surfaceHolder.getSurface();
                RTCNativeFunctions.nativeNotifySurfaceAvailable(this.nativeCallbackHandle, this.surface, this.renderTaskUUID, false);
            }
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int format, int width, int height) {
            if (this.nativeCallbackHandle != 0L) {
                RTCNativeFunctions.nativeNotifySurfaceSizeChanged(this.nativeCallbackHandle, this.renderTaskUUID);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            if (this.nativeCallbackHandle != 0L) {
                RTCNativeFunctions.nativeNotifySurfaceDestroyed(this.nativeCallbackHandle, surfaceHolder.getSurface(), this.renderTaskUUID, false);
            }
            this.surface = null;
        }
    }
}

