/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.base.media.screen;

import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import com.bytedance.realx.base.CalledByNative;
import com.ss.bytertc.base.media.screen.RTCScreenAudioNativeFunctions;
import org.webrtc.ContextUtils;
import org.webrtc.RXScreenCaptureService;
import org.webrtc.ScreenAudioCaptureAndroidManager;
import org.webrtc.ScreenAudioCaptureObserver;

public class ScreenAudioCaptureAndroid
implements ScreenAudioCaptureObserver {
    private static final String TAG = "ScreenAudioCaptureAndroid";
    private long mNativeCaptureObserver;
    private boolean mIsAudioCaptureWorking = false;
    private Context mContext;

    @Override
    public void onAudioFrameCapture(byte[] audioFrame, int samples, int sampleRate, int channel) {
        RTCScreenAudioNativeFunctions.nativeOnAuidoFrameCaptured(this.mNativeCaptureObserver, audioFrame, samples, sampleRate, channel);
    }

    @Override
    public void onCapturerStarted() {
        RTCScreenAudioNativeFunctions.nativeOnCapturerStarted(this.mNativeCaptureObserver);
    }

    @Override
    public void onCapturerStopped() {
        RTCScreenAudioNativeFunctions.nativeOnCapturerStopped(this.mNativeCaptureObserver);
    }

    @CalledByNative
    ScreenAudioCaptureAndroid(long nativeCaptureObserver) {
        this.mNativeCaptureObserver = nativeCaptureObserver;
    }

    @CalledByNative
    public void startCapture() {
        this.mContext = ContextUtils.getApplicationContext();
        if (Build.VERSION.SDK_INT <= 28 || ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.RECORD_AUDIO") != 0) {
            RTCScreenAudioNativeFunctions.nativeOnCapturerError(this.mNativeCaptureObserver, 1);
            return;
        }
        ScreenAudioCaptureAndroidManager.INSTANCE().initialize(this.mContext, this);
        this.mContext.startForegroundService(RXScreenCaptureService.getServiceIntent(this.mContext, 6, null));
        this.mIsAudioCaptureWorking = true;
    }

    @CalledByNative
    public void stopCapture() {
        if (this.mIsAudioCaptureWorking) {
            if (Build.VERSION.SDK_INT > 28) {
                this.mContext.startForegroundService(RXScreenCaptureService.getServiceIntent(this.mContext, 7, null));
            }
            this.mIsAudioCaptureWorking = false;
        }
    }

    @CalledByNative
    public void release() {
        this.stopCapture();
        if (this.mContext != null && Build.VERSION.SDK_INT > 28) {
            this.mContext.startForegroundService(RXScreenCaptureService.getServiceIntent(this.mContext, 8, null));
        }
    }
}

