/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.base.media.screen;

import android.content.Intent;
import android.media.projection.MediaProjection;
import com.bytedance.realx.base.CalledByNative;
import com.ss.bytertc.base.media.screen.RTCScreenVideoNativeFunctions;
import com.ss.bytertc.engine.utils.LogUtil;
import org.webrtc.CapturerObserver;
import org.webrtc.ContextUtils;
import org.webrtc.EglBase;
import org.webrtc.ScreenCapturerAndroid;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;

public class ScreenVideoCaptureAndroid {
    private static final String TAG = "ScreenVideoCaptureAndroid";
    private VideoCapturer mVideoCapturer = null;
    private boolean mIsVideoCaptureInited = false;
    private boolean mIsVideoCaptureWorking = false;
    private long mNativeCaptureObserver;
    private EglBase cameraEglBase = null;
    private EglBase.Context sharedEglGroup = null;
    private Intent mCaptureScreenIntent = null;
    private CapturerObserver localCapturerObserver = new CapturerObserver(){

        @Override
        public void onCapturerStarted(boolean b) {
            if (b) {
                RTCScreenVideoNativeFunctions.nativeOnCapturerStarted(ScreenVideoCaptureAndroid.this.mNativeCaptureObserver);
            } else {
                RTCScreenVideoNativeFunctions.nativeOnCapturerError(ScreenVideoCaptureAndroid.this.mNativeCaptureObserver, 0);
            }
        }

        @Override
        public void onCapturerStopped() {
            RTCScreenVideoNativeFunctions.nativeOnCapturerStopped(ScreenVideoCaptureAndroid.this.mNativeCaptureObserver);
        }

        @Override
        public void onCapturerError(String errorMsg) {
            RTCScreenVideoNativeFunctions.nativeOnCapturerError(ScreenVideoCaptureAndroid.this.mNativeCaptureObserver, 0);
        }

        @Override
        public void onFrameCaptured(VideoFrame videoFrame) {
            RTCScreenVideoNativeFunctions.nativeOnFrameCaptured(ScreenVideoCaptureAndroid.this.mNativeCaptureObserver, videoFrame);
        }
    };

    @CalledByNative
    ScreenVideoCaptureAndroid(long nativeCaptureObserver, EglBase.Context ctx) {
        this.mNativeCaptureObserver = nativeCaptureObserver;
        this.sharedEglGroup = ctx;
    }

    @CalledByNative
    public void startCapture(int width, int height, int frameRate, Intent intent) {
        this.mCaptureScreenIntent = intent;
        if (this.mVideoCapturer != null) {
            this.mVideoCapturer.dispose();
            this.mVideoCapturer = null;
            this.mIsVideoCaptureInited = false;
            this.mIsVideoCaptureWorking = false;
        }
        this.mVideoCapturer = this.createVideoCapturer(this.mCaptureScreenIntent);
        if (this.cameraEglBase == null) {
            this.cameraEglBase = EglBase.create(this.sharedEglGroup);
        }
        if (this.mVideoCapturer != null) {
            ((ScreenCapturerAndroid)this.mVideoCapturer).initialize(this.cameraEglBase.getEglBaseContext(), ContextUtils.getApplicationContext(), this.localCapturerObserver);
            this.mIsVideoCaptureInited = true;
            this.startVideoCapture(width, height, frameRate);
        } else {
            this.mIsVideoCaptureInited = false;
            this.mIsVideoCaptureWorking = false;
        }
    }

    @CalledByNative
    public void stopCapture() {
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            try {
                this.mVideoCapturer.stopCapture();
                this.mIsVideoCaptureWorking = false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @CalledByNative
    public void release() {
        if (this.mVideoCapturer != null) {
            this.stopCapture();
            this.mVideoCapturer.dispose();
            this.mVideoCapturer = null;
        }
        if (this.cameraEglBase != null) {
            this.cameraEglBase.release();
            this.cameraEglBase = null;
        }
        this.mIsVideoCaptureInited = false;
        this.mIsVideoCaptureWorking = false;
        this.sharedEglGroup = null;
        this.mCaptureScreenIntent = null;
    }

    private VideoCapturer createVideoCapturer(Intent mediaProjectionPermissionResultData) {
        try {
            return new ScreenCapturerAndroid(mediaProjectionPermissionResultData, new MediaProjection.Callback(){

                public void onStop() {
                    LogUtil.e(ScreenVideoCaptureAndroid.TAG, "User revoked permission to capture the screen.");
                }
            });
        }
        catch (IllegalArgumentException e) {
            LogUtil.e(TAG, "Create VideoCapture fail : " + e.getMessage());
            return null;
        }
    }

    private void startVideoCapture(int width, int height, int fps) {
        if (this.mVideoCapturer != null) {
            try {
                this.mVideoCapturer.startCapture(width, height, fps);
                this.mIsVideoCaptureWorking = true;
            }
            catch (IllegalArgumentException e) {
                LogUtil.e(TAG, "VideoCapture startCapture fail : " + e.getMessage());
            }
        }
    }
}

