/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.base.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.ss.bytertc.base.utils.NetworkUtils;
import com.ss.bytertc.engine.utils.LogUtil;

public class NetworkConnectChangeReceiver
extends BroadcastReceiver {
    private static final String TAG = "NetworkConnectChangeReceiver";
    private NetworkUtils.NetworkType sNetworkType = NetworkUtils.NetworkType.NONE;
    private Callback mCallback;

    public NetworkConnectChangeReceiver(Callback callback) {
        this.mCallback = callback;
    }

    public void onReceive(Context context, Intent intent) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction()) || "android.net.wifi.WIFI_STATE_CHANGED".equals(intent.getAction()) || "android.net.wifi.STATE_CHANGE".equals(intent.getAction())) {
            NetworkUtils.NetworkType networkType = NetworkUtils.getNetworkType(context);
            LogUtil.d(TAG, "this: " + ((Object)((Object)this)).hashCode() + " before: " + (Object)((Object)this.sNetworkType) + " now: " + (Object)((Object)networkType));
            if (this.sNetworkType != NetworkUtils.NetworkType.NONE && networkType == NetworkUtils.NetworkType.UNKNOWN) {
                return;
            }
            if (this.sNetworkType != networkType) {
                int type = this.getConstantNetworkType(networkType);
                if (this.mCallback != null) {
                    this.mCallback.call(type, NetworkUtils.getDebugInfo());
                }
            }
            this.sNetworkType = networkType;
        }
    }

    private int getConstantNetworkType(NetworkUtils.NetworkType sNetworkType) {
        int type = !sNetworkType.isAvailable() ? 0 : this.getType(sNetworkType);
        return type;
    }

    private int getType(NetworkUtils.NetworkType networkType) {
        int type;
        switch (networkType) {
            case MOBILE: {
                type = 1;
                break;
            }
            case WIFI: {
                type = 2;
                break;
            }
            case MOBILE_2G: {
                type = 3;
                break;
            }
            case MOBILE_3G: {
                type = 4;
                break;
            }
            case MOBILE_4G: {
                type = 5;
                break;
            }
            case MOBILE_5G: {
                type = 6;
                break;
            }
            default: {
                type = -1;
            }
        }
        return type;
    }

    public static interface Callback {
        public void call(int var1, String var2);
    }
}

