/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import android.content.Context;
import com.ss.bytertc.engine.GameRTCEngineImpl;
import com.ss.bytertc.engine.data.AudioFormat;
import com.ss.bytertc.engine.game.AudioProfileType;
import com.ss.bytertc.engine.game.GameRTCEngineConfig;
import com.ss.bytertc.engine.game.GameRTCOrientation;
import com.ss.bytertc.engine.game.GameRTCPositionInfo;
import com.ss.bytertc.engine.game.GameRTCReceiveRange;
import com.ss.bytertc.engine.game.GameRTCRoomConfig;
import com.ss.bytertc.engine.handler.IGameRTCEventHandler;
import com.ss.bytertc.engine.loader.RTCNativeLibraryLoader;
import com.ss.bytertc.engine.loader.RTCNativeLibraryLoaderImpl;
import com.ss.bytertc.engine.type.AttenuationType;
import com.ss.bytertc.engine.type.AudioScenarioType;
import com.ss.bytertc.engine.type.VoiceChangerType;
import com.ss.bytertc.engine.type.VoiceReverbType;
import com.ss.bytertc.engine.utils.AudioFrame;
import com.ss.bytertc.engine.utils.LogUtil;

public abstract class GameRTCEngine {
    private static final String TAG = "GameRTCEngine";
    private static GameRTCEngineImpl mInstance = null;
    protected static RTCNativeLibraryLoader mRtcNativeLibraryLoader = new RTCNativeLibraryLoaderImpl();

    public static synchronized GameRTCEngine create(Context context, GameRTCEngineConfig config, IGameRTCEventHandler eventHandler, String params) {
        if (mInstance == null) {
            try {
                mInstance = new GameRTCEngineImpl(context, config, eventHandler, params);
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return mInstance;
    }

    public static synchronized void destroy() {
        if (mInstance != null) {
            mInstance.doDestroy();
            mInstance = null;
            System.gc();
        }
    }

    public static String getSdkVersion() {
        return GameRTCEngineImpl.getSDKVersion();
    }

    public static void setRtcNativeLibraryLoader(RTCNativeLibraryLoader rtcNativeLibraryLoader) {
        LogUtil.i(TAG, "set rtc native library loader " + rtcNativeLibraryLoader);
        mRtcNativeLibraryLoader = rtcNativeLibraryLoader;
    }

    public abstract int joinRoom(String var1, String var2, String var3, GameRTCRoomConfig var4);

    public abstract int leaveRoom(String var1);

    public abstract int updateToken(String var1, String var2);

    public abstract int updateReceiveRange(String var1, GameRTCReceiveRange var2);

    public abstract int setAttenuationModel(String var1, AttenuationType var2, float var3);

    public abstract int updatePosition(String var1, GameRTCPositionInfo var2);

    public abstract int updateOrientation(String var1, GameRTCOrientation var2, GameRTCOrientation var3, GameRTCOrientation var4);

    public abstract int enableMicrophone(String var1, boolean var2);

    public abstract int enableAudioSend(String var1, boolean var2);

    public abstract int enableSpeakerphone(String var1, boolean var2);

    public abstract int enableAudioReceive(String var1, String var2, boolean var3);

    public abstract int setRecordingVolume(int var1);

    public abstract int setPlaybackVolume(int var1);

    public abstract int setRemoteAudioPlaybackVolume(String var1, String var2, int var3);

    public abstract void EnableExternalAudioDevice(AudioFormat var1, AudioFormat var2);

    public abstract void DisableExternalAudioDevice();

    public abstract int pushExternalAudioFrame(AudioFrame var1);

    public abstract int pullExternalAudioFrame(AudioFrame var1);

    public abstract void setAudioScenario(AudioScenarioType var1);

    public abstract void setAudioProfile(AudioProfileType var1);

    public abstract void setVoiceChangerType(VoiceChangerType var1);

    public abstract void setVoiceReverbType(VoiceReverbType var1);

    public abstract void enableRequestAudioFocus(boolean var1);
}

