/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import android.support.annotation.NonNull;
import com.ss.bytertc.engine.NativeKTVPlayerFunctions;
import com.ss.bytertc.engine.handler.KTVPlayEventHandler;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.ktv.IKTVPlayerEventHandler;
import com.ss.bytertc.ktv.KTVPlayer;
import com.ss.bytertc.ktv.data.AudioPlayType;
import com.ss.bytertc.ktv.data.AudioTrackType;

public class KTVPlayerImpl
extends KTVPlayer {
    private static final String TAG = "KTVPlayerImpl";
    private final long mNativeKTVPlayer;
    private KTVPlayEventHandler handler;
    private long mNativePlayerEventHandler;

    public KTVPlayerImpl(long nativeKTVPlayer) {
        this.mNativeKTVPlayer = nativeKTVPlayer;
    }

    @Override
    public void setPlayerEventHandler(IKTVPlayerEventHandler playerEventHandler) {
        this.handler = new KTVPlayEventHandler(playerEventHandler);
        long oldNativePlayerEventHandler = this.mNativePlayerEventHandler;
        this.mNativePlayerEventHandler = NativeKTVPlayerFunctions.nativeSetPlayerEventHandler(this.mNativeKTVPlayer, this.handler);
        if (oldNativePlayerEventHandler != 0L) {
            NativeKTVPlayerFunctions.nativeReleaseKTVPlayerEventHandler(oldNativePlayerEventHandler);
        }
    }

    @Override
    public void playMusic(@NonNull String musicId, @NonNull AudioTrackType trackType, @NonNull AudioPlayType playType) {
        if (this.mNativeKTVPlayer == 0L) {
            LogUtil.e(TAG, "native mNativeKTVPlayer is invalid, playMusic failed.");
            return;
        }
        NativeKTVPlayerFunctions.nativePlayMusic(this.mNativeKTVPlayer, musicId, trackType.value(), playType.value());
    }

    @Override
    public void pauseMusic(@NonNull String musicId) {
        if (this.mNativeKTVPlayer == 0L) {
            LogUtil.e(TAG, "native mNativeKTVPlayer is invalid, pauseMusic failed.");
            return;
        }
        NativeKTVPlayerFunctions.nativePauseMusic(this.mNativeKTVPlayer, musicId);
    }

    @Override
    public void resumeMusic(@NonNull String musicId) {
        if (this.mNativeKTVPlayer == 0L) {
            LogUtil.e(TAG, "native mNativeKTVPlayer is invalid, resumeMusic failed.");
            return;
        }
        NativeKTVPlayerFunctions.nativeResumeMusic(this.mNativeKTVPlayer, musicId);
    }

    @Override
    public void stopMusic(@NonNull String musicId) {
        if (this.mNativeKTVPlayer == 0L) {
            LogUtil.e(TAG, "native mNativeKTVPlayer is invalid, stopMusic failed.");
            return;
        }
        NativeKTVPlayerFunctions.nativeStopMusic(this.mNativeKTVPlayer, musicId);
    }

    @Override
    public void seekMusic(@NonNull String musicId, int position) {
        if (this.mNativeKTVPlayer == 0L) {
            LogUtil.e(TAG, "native mNativeKTVPlayer is invalid, seekMusic failed.");
            return;
        }
        NativeKTVPlayerFunctions.nativeSeekMusic(this.mNativeKTVPlayer, musicId, position);
    }

    @Override
    public void setMusicVolume(@NonNull String musicId, int volume) {
        if (this.mNativeKTVPlayer == 0L) {
            LogUtil.e(TAG, "native mNativeKTVPlayer is invalid, setMusicVolume failed.");
            return;
        }
        NativeKTVPlayerFunctions.nativeSetMusicVolume(this.mNativeKTVPlayer, musicId, volume);
    }

    @Override
    public void switchAudioTrackType(@NonNull String musicId) {
        if (this.mNativeKTVPlayer == 0L) {
            LogUtil.e(TAG, "native mNativeKTVPlayer is invalid, switchAudioTrackType failed.");
            return;
        }
        NativeKTVPlayerFunctions.nativeSwitchAudioTrackType(this.mNativeKTVPlayer, musicId);
    }

    @Override
    public void setMusicPitch(@NonNull String musicId, int pitch) {
        if (this.mNativeKTVPlayer == 0L) {
            LogUtil.e(TAG, "native mNativeKTVPlayer is invalid, setMusicPitch failed.");
            return;
        }
        NativeKTVPlayerFunctions.nativeSetMusicPitch(this.mNativeKTVPlayer, musicId, pitch);
    }

    @Override
    public void destroy() {
        if (this.mNativePlayerEventHandler != 0L) {
            NativeKTVPlayerFunctions.nativeReleaseKTVPlayerEventHandler(this.mNativePlayerEventHandler);
            this.mNativePlayerEventHandler = 0L;
        }
        this.handler = null;
    }
}

