/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.IRangeAudioObserver;
import com.ss.bytertc.engine.audio.IRangeAudio;
import com.ss.bytertc.engine.data.Position;
import com.ss.bytertc.engine.data.ReceiveRange;
import com.ss.bytertc.engine.handler.RangeAudioObserver;
import com.ss.bytertc.engine.type.AttenuationType;
import com.ss.bytertc.engine.utils.LogUtil;
import java.lang.ref.WeakReference;

public class NativeRangeAudio
implements IRangeAudio {
    private static final String TAG = "NativeRangeAudio";
    private long mNaiveInstance = 0L;
    private long mNativeRangeAudioObserver = 0L;
    private WeakReference<IRangeAudioObserver> mRangeAudioObserver;
    private RangeAudioObserver mERangeAudioObserverInternal;

    public NativeRangeAudio(long instance) {
        this.mNaiveInstance = instance;
    }

    public void release() {
        if (this.mNativeRangeAudioObserver != 0L) {
            NativeRangeAudio.nativeReleaseRangeAudioObserver(this.mNativeRangeAudioObserver);
        }
    }

    public IRangeAudioObserver getRangeAudioObserver() {
        return (IRangeAudioObserver)this.mRangeAudioObserver.get();
    }

    @Override
    public void enableRangeAudio(boolean enable) {
        if (this.mNaiveInstance == 0L) {
            LogUtil.e(TAG, "native RangeAudio is invalid, enableRangeAudio failed.");
            return;
        }
        NativeRangeAudio.nativeEnableRangeAudio(this.mNaiveInstance, enable);
    }

    @Override
    public int updatePosition(Position pos) {
        if (this.mNaiveInstance == 0L) {
            LogUtil.e(TAG, "native RangeAudio is invalid, updatePosition failed.");
            return -1;
        }
        return NativeRangeAudio.nativeUpdatePosition(this.mNaiveInstance, pos.x, pos.y, pos.z);
    }

    @Override
    public int updateReceiveRange(ReceiveRange range) {
        if (this.mNaiveInstance == 0L) {
            LogUtil.e(TAG, "native RangeAudio is invalid, updateReceiveRange failed.");
            return -1;
        }
        return NativeRangeAudio.nativeUpdateReceiveRange(this.mNaiveInstance, range.min, range.max);
    }

    @Override
    public void registerRangeAudioObserver(IRangeAudioObserver observer) {
        if (this.mNaiveInstance == 0L) {
            LogUtil.e(TAG, "native range audio is invalid, registerRangeAudioObserver failed.");
            return;
        }
        if (observer == null) {
            LogUtil.e(TAG, "observer is invalid, registerRangeAudioObserver failed.");
            return;
        }
        this.mRangeAudioObserver = new WeakReference<IRangeAudioObserver>(observer);
        this.mERangeAudioObserverInternal = new RangeAudioObserver(this);
        long handler = this.mNativeRangeAudioObserver;
        this.mNativeRangeAudioObserver = NativeRangeAudio.nativeRegisterRangeAudioObserver(this.mNaiveInstance, this.mERangeAudioObserverInternal);
        if (handler != 0L) {
            NativeRangeAudio.nativeReleaseRangeAudioObserver(handler);
        }
    }

    @Override
    public int setAttenuationModel(AttenuationType type, float coefficient) {
        if (this.mNaiveInstance == 0L) {
            LogUtil.e(TAG, "native range audio is invalid, registerRangeAudioObserver failed.");
            return -1;
        }
        return NativeRangeAudio.nativeSetAttenuationType(this.mNaiveInstance, type.value(), coefficient);
    }

    public static native void nativeEnableRangeAudio(long var0, boolean var2);

    public static native int nativeUpdatePosition(long var0, int var2, int var3, int var4);

    public static native int nativeUpdateReceiveRange(long var0, int var2, int var3);

    public static native long nativeRegisterRangeAudioObserver(long var0, RangeAudioObserver var2);

    public static native void nativeReleaseRangeAudioObserver(long var0);

    public static native int nativeSetAttenuationType(long var0, int var2, float var3);
}

