/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import android.util.Pair;
import com.ss.bytertc.engine.data.VideoOrientation;
import org.webrtc.CalledByNative;

public class VideoStreamDescription {
    public Pair<Integer, Integer> videoSize;
    public int frameRate;
    public int maxKbps;
    public EncoderPreference encodePreference = EncoderPreference.MaintainFramerate;
    public VideoOrientation orientation = VideoOrientation.Adaptive;

    @CalledByNative
    private static VideoStreamDescription create(int width, int height, int frameRate, int maxKbps) {
        return new VideoStreamDescription(width, height, frameRate, maxKbps);
    }

    public VideoStreamDescription() {
    }

    public VideoStreamDescription(int width, int height, int frameRate, int maxKbps) {
        this.videoSize = new Pair((Object)width, (Object)height);
        this.frameRate = frameRate;
        this.maxKbps = maxKbps;
    }

    public VideoStreamDescription(int width, int height, int frameRate, int maxKbps, int codecName, int codecMode, int encodePrefer, int orientation) {
        this.videoSize = new Pair((Object)width, (Object)height);
        this.frameRate = frameRate;
        this.maxKbps = maxKbps;
        this.encodePreference = EncoderPreference.convertFromInt(encodePrefer);
        this.orientation = VideoOrientation.fromId(orientation);
    }

    public boolean isValid() {
        return this.videoSize != null && (Integer)this.videoSize.first > 0 && (Integer)this.videoSize.second > 0 && this.frameRate > 0;
    }

    public String toString() {
        return "VideoStreamDescription{videoSize=" + this.videoSize + ", frameRate=" + this.frameRate + ", maxKbps=" + this.maxKbps + ", encodePreference=" + (Object)((Object)this.encodePreference) + ", orientation=" + (Object)((Object)this.orientation) + '}';
    }

    public static enum EncoderPreference {
        Disabled(0),
        MaintainFramerate(1),
        MaintainQuality(2),
        Balance(3);

        private int value;

        private EncoderPreference(int v) {
            this.value = v;
        }

        public static EncoderPreference convertFromInt(int v) {
            return EncoderPreference.values()[v];
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum VideoCodecType {
        CODEC_TYPE_AUTO(0),
        CODEC_TYPE_H264(1),
        CODEC_TYPE_BYTEVC1(2);

        private int value;

        private VideoCodecType(int v) {
            this.value = v;
        }

        public static VideoCodecType convertFromInt(int v) {
            return VideoCodecType.values()[v];
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CodecMode {
        CODEC_MODE_AUTO(0),
        CODEC_MODE_HARDWARE(1),
        CODEC_MODE_SOFTWARE(2);

        private int value;

        private CodecMode(int v) {
            this.value = v;
        }

        public static CodecMode convertFromInt(int v) {
            return CodecMode.values()[v];
        }

        public int getValue() {
            return this.value;
        }
    }
}

