/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.data.RemoteStreamKey;
import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.data.VideoCodecType;
import com.ss.bytertc.engine.data.VideoPictureType;
import com.ss.bytertc.engine.data.VideoRotation;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.mediaio.IRemoteEncodedVideoFrameObserver;
import com.ss.bytertc.engine.mediaio.RTCEncodedVideoFrame;
import java.lang.ref.WeakReference;
import org.webrtc.CalledByNative;
import org.webrtc.VideoStream;

public class RTCRemoteEncodedVideoFrameObserver {
    private static final String TAG = "RTCRemoteEncodedVideoFrameObserver";
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;

    public RTCRemoteEncodedVideoFrameObserver(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public RTCRemoteEncodedVideoFrameObserver(RTCVideoImpl rtcVideoImpl) {
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
    }

    @CalledByNative
    void onRemoteEncodedVideoFrame(String roomId, String userId, int streamIndex, VideoStream videoStream, long timestampUs, long timestampDtsUs, int videoCodecType, int videoPictureType, int videoRotation) {
        RTCVideoImpl strongVideo;
        IRemoteEncodedVideoFrameObserver encodedVideoFrameObserver;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (encodedVideoFrameObserver = strongEngine.getRemoteEncodedVideoFrameObserver()) != null) {
            encodedVideoFrameObserver.OnRemoteEncodedVideoFrame(new RemoteStreamKey(roomId, userId, StreamIndex.fromId(streamIndex)), new RTCEncodedVideoFrame(videoStream.getBuffer().getData(), timestampUs, timestampDtsUs, videoStream.getWidth(), videoStream.getHeight(), VideoCodecType.fromId(videoCodecType), VideoPictureType.fromId(videoPictureType), VideoRotation.fromId(videoRotation)));
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (encodedVideoFrameObserver = strongVideo.getRemoteEncodedVideoFrameObserver()) != null) {
            encodedVideoFrameObserver.OnRemoteEncodedVideoFrame(new RemoteStreamKey(roomId, userId, StreamIndex.fromId(streamIndex)), new RTCEncodedVideoFrame(videoStream.getBuffer().getData(), timestampUs, timestampDtsUs, videoStream.getWidth(), videoStream.getHeight(), VideoCodecType.fromId(videoCodecType), VideoPictureType.fromId(videoPictureType), VideoRotation.fromId(videoRotation)));
        }
    }
}

