/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.InternalLocalStreamStats;
import com.ss.bytertc.engine.InternalNetworkQualityInfo;
import com.ss.bytertc.engine.InternalRTCStats;
import com.ss.bytertc.engine.InternalRemoteStreamStats;
import com.ss.bytertc.engine.RTCRoomImpl;
import com.ss.bytertc.engine.RTCStream;
import com.ss.bytertc.engine.SubscribeConfig;
import com.ss.bytertc.engine.UserInfo;
import com.ss.bytertc.engine.data.AVSyncState;
import com.ss.bytertc.engine.data.ForwardStreamEventInfo;
import com.ss.bytertc.engine.data.ForwardStreamStateInfo;
import com.ss.bytertc.engine.handler.IRTCRoomEventHandler;
import com.ss.bytertc.engine.type.LocalStreamStats;
import com.ss.bytertc.engine.type.MediaStreamType;
import com.ss.bytertc.engine.type.NetworkQualityStats;
import com.ss.bytertc.engine.type.RTCRoomStats;
import com.ss.bytertc.engine.type.RemoteStreamStats;
import com.ss.bytertc.engine.type.StreamRemoveReason;
import com.ss.bytertc.engine.utils.LogUtil;
import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;

public class RTCRoomEventHandler {
    private static final String TAG = "RtcRoomEventHandler";
    private RTCRoomImpl mRtcRoom;

    public RTCRoomEventHandler(RTCRoomImpl rtcRoom) {
        this.mRtcRoom = rtcRoom;
    }

    @CalledByNative
    public void onLeaveRoom(InternalRTCStats stats) {
        LogUtil.d(TAG, "onLeaveRoom...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onLeaveRoom(new RTCRoomStats(stats));
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onLeaveRoom callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomStateChanged(String roomId, String uid, int state, String extraInfo) {
        LogUtil.d(TAG, "onRoomStateChanged...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onRoomStateChanged(roomId, uid, state, extraInfo);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRoomStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamStateChanged(String roomId, String uid, int state, String extraInfo) {
        LogUtil.d(TAG, "onStreamStateChanged...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onStreamStateChanged(roomId, uid, state, extraInfo);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onStreamStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomWarning(int warn) {
        LogUtil.d(TAG, "onRoomWarning, warnNum: " + warn);
        try {
            this.mRtcRoom.getRtcRoomHandler().onRoomWarning(warn);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRoomWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomError(int err) {
        LogUtil.d(TAG, "onRoomError...errorNum: " + err);
        try {
            this.mRtcRoom.getRtcRoomHandler().onRoomError(err);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRoomError callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAVSyncStateChange(AVSyncState state) {
        LogUtil.d(TAG, "onAVSyncStateChange: " + (Object)((Object)state));
        try {
            this.mRtcRoom.getRtcRoomHandler().onAVSyncStateChange(state);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onAVSyncStateChange callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomStats(InternalRTCStats stats) {
        LogUtil.d(TAG, "onRtcStats...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onRoomStats(new RTCRoomStats(stats));
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRtcStats callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserJoined(UserInfo userInfo, int elapsed) {
        LogUtil.d(TAG, "onUserJoined... uid: " + userInfo.getUid() + ", extraInfo: " + userInfo.getExtraInfo() + ", elapsed: " + elapsed);
        try {
            this.mRtcRoom.getRtcRoomHandler().onUserJoined(userInfo, elapsed);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserJoined callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserLeave(String uid, int reason) {
        LogUtil.d(TAG, "onUserLeave... uid: " + uid + ", reason: " + reason);
        try {
            this.mRtcRoom.getRtcRoomHandler().onUserLeave(uid, reason);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserLeave callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onTokenWillExpire() {
        LogUtil.d(TAG, "onTokenWillExpire");
        try {
            this.mRtcRoom.getRtcRoomHandler().onTokenWillExpire();
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onTokenWillExpire callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserPublishStream(String uid, int type) {
        LogUtil.d(TAG, "onUserPublishStream... uid: " + uid + ", type: " + type);
        try {
            this.mRtcRoom.getRtcRoomHandler().onUserPublishStream(uid, MediaStreamType.valueOf(type));
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserPublishStream callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserUnpublishStream(String uid, int type, int reason) {
        LogUtil.d(TAG, "onUserUnPublishStream... uid: " + uid + ", type: " + type + ", reasen:" + reason);
        try {
            this.mRtcRoom.getRtcRoomHandler().onUserUnpublishStream(uid, MediaStreamType.valueOf(type), StreamRemoveReason.values()[reason]);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserUnPublishStream callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserPublishScreen(String uid, int type) {
        LogUtil.d(TAG, "onUserPublishScreen... uid: " + uid + ", type: " + type);
        try {
            this.mRtcRoom.getRtcRoomHandler().onUserPublishScreen(uid, MediaStreamType.valueOf(type));
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserPublishScreen callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserUnpublishScreen(String uid, int type, int reason) {
        LogUtil.d(TAG, "onUserUnPublishScreen... uid: " + uid + ", type: " + type + ", reasen:" + reason);
        try {
            this.mRtcRoom.getRtcRoomHandler().onUserUnpublishScreen(uid, MediaStreamType.valueOf(type), StreamRemoveReason.values()[reason]);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserUnPublishScreen callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLocalStreamStats(InternalLocalStreamStats stats) {
        LogUtil.d(TAG, "onLocalStreamStats...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onLocalStreamStats(new LocalStreamStats(stats));
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onLocalStreamStats callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteStreamStats(InternalRemoteStreamStats stats) {
        LogUtil.d(TAG, "onRemoteStreamStats...");
        try {
            int quality = 0;
            switch (stats.audioStats.quality) {
                case -1: {
                    quality = 6;
                    break;
                }
                case 0: {
                    quality = 5;
                    break;
                }
                case 1: {
                    quality = 4;
                    break;
                }
                case 2: {
                    quality = 3;
                    break;
                }
                case 3: {
                    quality = 2;
                    break;
                }
                case 4: {
                    quality = 1;
                    break;
                }
            }
            stats.audioStats.quality = quality;
            this.mRtcRoom.getRtcRoomHandler().onRemoteStreamStats(new RemoteStreamStats(stats));
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRemoteStreamStats callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamRemove(RTCStream bs, int reason) {
        LogUtil.d(TAG, "onStreamRemove...uid: " + bs.userId);
        try {
            this.mRtcRoom.getRtcRoomHandler().onStreamRemove(bs, StreamRemoveReason.values()[reason]);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onStreamRemove callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamAdd(RTCStream stream) {
        LogUtil.d(TAG, "onStreamAdd...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onStreamAdd(stream);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onStreamAdd callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamSubscribed(int stateCode, String userId, SubscribeConfig info) {
        LogUtil.d(TAG, "onStreamSubscribed...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onStreamSubscribed(stateCode, userId, info);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onStreamSubscribed callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamPublishSuccess(String uid, boolean isScreen) {
        LogUtil.d(TAG, "onStreamPublishSuccess...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onStreamPublishSuccess(uid, isScreen);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onStreamPublishSuccess callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomMessageReceived(String uid, String message) {
        LogUtil.d(TAG, "onRoomMessageReceived: " + message);
        try {
            this.mRtcRoom.getRtcRoomHandler().onRoomMessageReceived(uid, message);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRoomMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomBinaryMessageReceived(String uid, ByteBuffer message) {
        LogUtil.d(TAG, "onRoomBinaryMessageReceived, length: " + message.capacity());
        try {
            this.mRtcRoom.getRtcRoomHandler().onRoomBinaryMessageReceived(uid, message);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRoomBinaryMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMessageReceived(String uid, String message) {
        LogUtil.d(TAG, "onUserMessageReceived: uid:" + uid + "message" + message);
        try {
            this.mRtcRoom.getRtcRoomHandler().onUserMessageReceived(uid, message);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserBinaryMessageReceived(String uid, ByteBuffer message) {
        LogUtil.d(TAG, "onUserBinaryMessageReceived: uid:" + uid + "binary message length" + message.capacity());
        try {
            this.mRtcRoom.getRtcRoomHandler().onUserBinaryMessageReceived(uid, message);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserBinaryMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMessageSendResult(long msgid, int error) {
        LogUtil.d(TAG, "onUserMessageSendResult...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onUserMessageSendResult(msgid, error);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUserMessageSendResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomMessageSendResult(long msgid, int error) {
        LogUtil.d(TAG, "onRoomMessageSendResult...");
        try {
            this.mRtcRoom.getRtcRoomHandler().onRoomMessageSendResult(msgid, error);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onRoomMessageSendResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSubscribe(String uid, boolean isReconnect) {
        LogUtil.d(TAG, "onSubscribe, uesr_id: " + uid + ", isReconnect: " + isReconnect);
        try {
            this.mRtcRoom.getRtcRoomHandler().onSubscribe(uid, isReconnect);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onSubscribe callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUnSubscribe(String uid, boolean isReconnect) {
        LogUtil.d(TAG, "onUnSubscribe, uesr_id: " + uid + ", isReconnect: " + isReconnect);
        try {
            this.mRtcRoom.getRtcRoomHandler().onUnSubscribe(uid, isReconnect);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onUnSubscribe callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public static ByteBuffer allocateDirectByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    @CalledByNative
    public void onVideoStreamBanned(String user, boolean banned) {
        LogUtil.d(TAG, "onVideoStreamBanned, user: " + user + ", banned: " + (banned ? "true" : "false"));
        try {
            this.mRtcRoom.getRtcRoomHandler().onVideoStreamBanned(user, banned);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onVideoStreamBanned callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioStreamBanned(String user, boolean banned) {
        LogUtil.d(TAG, "onAudioStreamBanned, user: " + user + ", banned: " + (banned ? "true" : "false"));
        try {
            this.mRtcRoom.getRtcRoomHandler().onAudioStreamBanned(user, banned);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onAudioStreamBanned callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onForwardStreamStateChanged(ForwardStreamStateInfo[] stateInfos) {
        LogUtil.d(TAG, "OnForwardStreamStateChanged");
        try {
            this.mRtcRoom.getRtcRoomHandler().onForwardStreamStateChanged(stateInfos);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onForwardStreamStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onForwardStreamEvent(ForwardStreamEventInfo[] eventInfos) {
        LogUtil.d(TAG, "onForwardStreamEvent");
        try {
            this.mRtcRoom.getRtcRoomHandler().onForwardStreamEvent(eventInfos);
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onForwardStreamEvent callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onNetworkQuality(InternalNetworkQualityInfo lQuality, InternalNetworkQualityInfo[] rQualities) {
        LogUtil.d(TAG, "Local onNetworkQuality, uid: " + lQuality.uid + ", info: " + lQuality.toString());
        try {
            IRTCRoomEventHandler roomHandler = this.mRtcRoom.getRtcRoomHandler();
            if (roomHandler != null) {
                NetworkQualityStats[] remoteQualities = new NetworkQualityStats[rQualities.length];
                for (int i = 0; i < rQualities.length; ++i) {
                    LogUtil.d(TAG, "Remote onNetworkQuality, uid: " + rQualities[i].uid + ", info: " + rQualities[i].toString());
                    remoteQualities[i] = new NetworkQualityStats(rQualities[i]);
                }
                roomHandler.onNetworkQuality(new NetworkQualityStats(lQuality), remoteQualities);
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onNetworkQuality callback catch exception.\n" + ex.getMessage());
        }
    }
}

