/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.live;

import com.ss.bytertc.engine.live.ByteRTCStreamMixingEvent;
import com.ss.bytertc.engine.live.ByteRTCStreamMixingType;
import com.ss.bytertc.engine.live.ByteRTCTranscoderErrorCode;
import com.ss.bytertc.engine.live.ILiveTranscodingObserver;
import java.util.HashMap;
import java.util.Map;
import org.webrtc.CalledByNative;
import org.webrtc.VideoFrame;

public class LiveTranscodingObserver {
    private Map<String, ILiveTranscodingObserver> mLiveTransObserver = new HashMap<String, ILiveTranscodingObserver>();
    private Map<String, Boolean> mSupportClientPushStream = new HashMap<String, Boolean>();

    @CalledByNative
    public boolean isSupportClientPushStream(String taskId) {
        if (this.mSupportClientPushStream != null && this.mSupportClientPushStream.containsKey(taskId)) {
            return this.mSupportClientPushStream.get(taskId);
        }
        return false;
    }

    @CalledByNative
    public void onStreamMixingEvent(ByteRTCStreamMixingEvent eventType, String taskId, ByteRTCTranscoderErrorCode error, ByteRTCStreamMixingType mixType) {
        if (this.mLiveTransObserver != null && this.mLiveTransObserver.containsKey(taskId)) {
            this.mLiveTransObserver.get(taskId).onStreamMixingEvent(eventType, taskId, error, mixType);
        }
    }

    @CalledByNative
    public void onMixingAudioFrame(String taskId, byte[] audioFrame, int frameNum) {
        if (this.mLiveTransObserver != null && this.mLiveTransObserver.containsKey(taskId)) {
            this.mLiveTransObserver.get(taskId).onMixingAudioFrame(taskId, audioFrame, frameNum);
        }
    }

    @CalledByNative
    public void onMixingVideoFrame(String taskId, VideoFrame VideoFrame2) {
        if (this.mLiveTransObserver != null && this.mLiveTransObserver.containsKey(taskId)) {
            this.mLiveTransObserver.get(taskId).onMixingVideoFrame(taskId, VideoFrame2);
        }
    }

    @CalledByNative
    public void onDataFrame(String taskId, byte[] dataFrame, long time) {
        if (this.mLiveTransObserver != null && this.mLiveTransObserver.containsKey(taskId)) {
            this.mLiveTransObserver.get(taskId).onDataFrame(taskId, dataFrame, time);
        }
    }

    public void setUserObserver(String taskId, ILiveTranscodingObserver mLiveTranscodingObserver) {
        if (this.mLiveTransObserver == null) {
            this.mLiveTransObserver = new HashMap<String, ILiveTranscodingObserver>();
        }
        if (this.mSupportClientPushStream == null) {
            this.mSupportClientPushStream = new HashMap<String, Boolean>();
        }
        this.mLiveTransObserver.put(taskId, mLiveTranscodingObserver);
        if (mLiveTranscodingObserver != null) {
            this.mSupportClientPushStream.put(taskId, mLiveTranscodingObserver.isSupportClientPushStream());
        } else {
            this.mSupportClientPushStream.put(taskId, false);
        }
    }
}

