/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.mediaio;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.TextureView;
import com.ss.bytertc.engine.mediaio.CountDownLatchI420Buffer;
import com.ss.bytertc.engine.mediaio.IVideoSink;
import com.ss.bytertc.engine.ui.VideoFrameRender;
import com.ss.bytertc.engine.utils.LogUtil;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;

public class TextureEglRenderer
extends EglRenderer
implements TextureView.SurfaceTextureListener {
    private static final String TAG = "TextureEglRenderer";
    private final Object mSurfaceTextureListenerLock = new Object();
    private TextureView.SurfaceTextureListener mSurfaceTextureListener;
    private VideoFrameRender.SurfaceLifecycleCallback mSurfaceLifecycleCallback;
    private volatile WeakReference<TextureView> mTextureViewRef;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final AtomicBoolean mHasInitAtomic = new AtomicBoolean(false);
    private final AtomicBoolean mHasBindAtomic = new AtomicBoolean(false);

    public TextureEglRenderer(String name) {
        super(name);
        this.mTextureViewRef = new WeakReference<Object>(null);
    }

    @Override
    public void init(EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        if (!this.mHasInitAtomic.compareAndSet(false, true)) {
            throw new IllegalStateException("TextureEglRenderer has already init!!!!!!");
        }
        LogUtil.d(TAG, "init");
        super.init(sharedContext, configAttributes, drawer);
    }

    public void bind(TextureView textureView, VideoFrameRender.SurfaceLifecycleCallback callback) {
        if (!this.mHasInitAtomic.get()) {
            throw new IllegalStateException("TextureEglRenderer has not init!!!!!!");
        }
        if (!this.mHasBindAtomic.compareAndSet(false, true)) {
            throw new IllegalStateException("Called bind functions multiple times!!!!!!");
        }
        LogUtil.d(TAG, "bind");
        this.mTextureViewRef = new WeakReference<TextureView>(textureView);
        this.mSurfaceLifecycleCallback = callback;
        this.runOnUIThread(() -> {
            if (textureView.getSurfaceTexture() != null) {
                this.createEglSurface(textureView.getSurfaceTexture());
                if (this.mSurfaceLifecycleCallback != null) {
                    this.mSurfaceLifecycleCallback.onCreated();
                }
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        Object object = this.mSurfaceTextureListenerLock;
        synchronized (object) {
            this.mSurfaceTextureListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
        LogUtil.d(TAG, "onSurfaceTextureAvailable");
        this.createEglSurface(surface);
        if (this.mSurfaceLifecycleCallback != null) {
            this.mSurfaceLifecycleCallback.onCreated();
        }
        Object object = this.mSurfaceTextureListenerLock;
        synchronized (object) {
            if (this.mSurfaceTextureListener != null) {
                this.mSurfaceTextureListener.onSurfaceTextureAvailable(surface, width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        LogUtil.d(TAG, "onSurfaceTextureSizeChanged");
        Object object = this.mSurfaceTextureListenerLock;
        synchronized (object) {
            if (this.mSurfaceTextureListener != null) {
                this.mSurfaceTextureListener.onSurfaceTextureSizeChanged(surface, width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        ThreadUtils.checkIsOnMainThread();
        LogUtil.d(TAG, "onSurfaceTextureDestroyed");
        CountDownLatch completionLatch = new CountDownLatch(1);
        this.releaseEglSurface(completionLatch::countDown);
        ThreadUtils.awaitUninterruptibly(completionLatch);
        if (this.mSurfaceLifecycleCallback != null) {
            this.mSurfaceLifecycleCallback.onDestroy();
        }
        Object object = this.mSurfaceTextureListenerLock;
        synchronized (object) {
            if (this.mSurfaceTextureListener != null) {
                this.mSurfaceTextureListener.onSurfaceTextureDestroyed(surface);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        Object object = this.mSurfaceTextureListenerLock;
        synchronized (object) {
            if (this.mSurfaceTextureListener != null) {
                this.mSurfaceTextureListener.onSurfaceTextureUpdated(surface);
            }
        }
    }

    @Override
    public void onFrame(VideoFrame frame) {
        if (!this.mHasInitAtomic.get() || !this.mHasBindAtomic.get() || this.mTextureViewRef == null) {
            return;
        }
        TextureView textureView = (TextureView)this.mTextureViewRef.get();
        if (frame == null || textureView == null || !textureView.isShown()) {
            return;
        }
        if (frame.getBuffer() instanceof CountDownLatchI420Buffer && textureView instanceof IVideoSink) {
            CountDownLatchI420Buffer autoReleaseBuffer = (CountDownLatchI420Buffer)frame.getBuffer();
            autoReleaseBuffer.retain();
            boolean ret = this.postOnMainThreadAndLock(() -> {
                super.onFrame(frame);
                autoReleaseBuffer.release();
            }, autoReleaseBuffer.getLatch());
            if (!ret) {
                autoReleaseBuffer.release();
            }
        } else {
            super.onFrame(frame);
        }
    }

    @Override
    public void release() {
        TextureView textureView;
        if (!this.mHasInitAtomic.compareAndSet(true, false)) {
            throw new IllegalStateException("TextureEglRenderer has not init or already released!!!!!");
        }
        LogUtil.d(TAG, "release");
        super.release();
        this.mHasBindAtomic.compareAndSet(true, false);
        if (this.mTextureViewRef != null && (textureView = (TextureView)this.mTextureViewRef.get()) != null) {
            textureView.setSurfaceTextureListener(null);
        }
    }

    private void runOnUIThread(Runnable r) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            r.run();
        } else {
            new Handler(Looper.getMainLooper()).post(r);
        }
    }

    private boolean postOnMainThreadAndLock(Runnable runnable, CountDownLatch latch) {
        return this.mainHandler.post(() -> {
            runnable.run();
            try {
                if (latch.getCount() != 0L) {
                    latch.await();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }
}

