/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.ss.bytertc.engine.utils.CommonUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AppMonitor
implements Application.ActivityLifecycleCallbacks {
    public static final int FOREGROUND = 1;
    public static final int BACKGROUND = 0;
    private static volatile AppMonitor INSTANCE;
    private List<Callback> mCallbacks = new CopyOnWriteArrayList<Callback>();

    private AppMonitor(Context context) {
        this.registerLifecycle(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppMonitor get(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<AppMonitor> clazz = AppMonitor.class;
        synchronized (AppMonitor.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AppMonitor(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private void registerLifecycle(Context context) {
        Application application = (Application)context.getApplicationContext();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public AppMonitor register(Context context, Callback callback) {
        if (!this.mCallbacks.contains(callback)) {
            this.mCallbacks.add(callback);
        }
        this.notifyCallback(CommonUtils.isInForeground(context) ? 1 : 0);
        return this;
    }

    public AppMonitor unRegister(Callback callback) {
        if (!this.mCallbacks.contains(callback)) {
            return this;
        }
        this.mCallbacks.remove(callback);
        return this;
    }

    public boolean release(Context context) {
        if (context != null) {
            ((Application)context.getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mCallbacks.clear();
            INSTANCE = null;
            return true;
        }
        return false;
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityResumed(Activity activity) {
        this.notifyCallback(1);
    }

    public void onActivityPaused(Activity activity) {
        this.notifyCallback(0);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    void notifyCallback(int appState) {
        for (Callback callback : this.mCallbacks) {
            callback.callback(appState);
        }
    }

    public static interface Callback {
        public void callback(int var1);
    }
}

